/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.runtree.XDataContext;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MFGetResourceString
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int three = 3;
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs < 1 || numArgs > 3) {
            this.throwErrorNumberOfArguments(numArgs, 1, 3);
        }
        String resourceId = "";
        String resourceFile = "xqejavamsgs";
        Locale resourceLocale = theContext.getEnvironment().getRequestEnvironment().getRunLocale();
        IValue firstArg = theFunctionNode.getParameter(theContext, 0);
        if (!(firstArg instanceof StringValue)) {
            this.throwErrorInvalidArgumentType(1, firstArg, "string");
        }
        resourceId = firstArg.toString();
        if (numArgs >= 2) {
            String str2;
            IValue secondArg = theFunctionNode.getParameter(theContext, 1);
            if (!(secondArg instanceof StringValue)) {
                this.throwErrorInvalidArgumentType(2, secondArg, "string");
            }
            if ((str2 = secondArg.toString()) != null && str2.length() > 0) {
                resourceFile = str2;
            }
        }
        if (numArgs == 3) {
            IValue thirdArg = theFunctionNode.getParameter(theContext, 2);
            if (!(thirdArg instanceof StringValue)) {
                this.throwErrorInvalidArgumentType(3, thirdArg, "string");
            }
            resourceLocale = new Locale(thirdArg.toString());
        }
        String localizedMessage = "";
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(resourceFile, resourceLocale);
        }
        catch (MissingResourceException mre) {
            throw new MacroException("Function GetResourceString encountered unknown resource file: '" + resourceFile + "' for locale '" + resourceLocale + "'.");
        }
        try {
            localizedMessage = bundle.getString(resourceId);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (localizedMessage == null || localizedMessage.isEmpty()) {
            bundle = ResourceBundle.getBundle(resourceFile, new Locale("en"));
            try {
                localizedMessage = bundle.getString(resourceId);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (localizedMessage == null || localizedMessage.isEmpty()) {
            throw new MacroException("Function GetResourceString encountered unknown resource ID: " + resourceId);
        }
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set(localizedMessage);
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "getResourceString";
    }
}

