/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MFPatternMatch;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;

public class MFGrep
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs == 2) {
            MFPatternMatch patternMatcher = new MFPatternMatch();
            String pattern = null;
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            if (firstArg instanceof StringValue) {
                pattern = firstArg.toString();
                patternMatcher.parsePattern(pattern);
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg, "string");
            }
            IValue secondArg = theFunctionNode.getParameter(theContext, 1);
            if (secondArg instanceof ArrayValue) {
                Value[] valueArray = ((ArrayValue)secondArg).getValues();
                ArrayList<Value> resultArray = new ArrayList<Value>();
                for (Value value : valueArray) {
                    String valueStr;
                    if (!(value instanceof StringValue) || !patternMatcher.passesPattern(valueStr = value.toString())) continue;
                    resultArray.add(value);
                }
                ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), resultArray.size());
                ArrayValue outputVal = DataValueFactory.createArrayValue(dType);
                StringValue[] x = new StringValue[]{};
                outputVal.set(resultArray.toArray(x));
                return outputVal;
            }
            this.throwErrorInvalidArgumentType(2, secondArg, "array");
        } else {
            this.throwErrorNumberOfArguments(numArgs, 2);
        }
        return null;
    }

    @Override
    public String getFunctionName() {
        return "grep";
    }
}

