/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;

public class MFLength
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        IValue arg;
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs != 1) {
            this.throwErrorNumberOfArguments(numArgs, 1);
        }
        if ((arg = theFunctionNode.getParameter(theContext, 0)) instanceof ArrayValue) {
            ArrayValue inputArray = (ArrayValue)arg;
            Value[] inputValues = inputArray.getValues();
            ArrayList<StringValue> outValues = new ArrayList<StringValue>();
            for (Value v : inputValues) {
                StringValue outV = this.doLength(v);
                outValues.add(outV);
            }
            int outLen = outValues.size();
            ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), outLen);
            ArrayValue outputArray = DataValueFactory.createArrayValue(dType);
            outputArray.set(outValues.toArray(new StringValue[outLen]));
            return outputArray;
        }
        return this.doLength(arg);
    }

    protected StringValue doLength(IValue v) {
        if (!(v instanceof StringValue)) {
            this.throwErrorInvalidArgumentType(1, v, "string");
        }
        String text = v.toString();
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set(String.valueOf(text.length()));
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "length";
    }
}

