/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

public class MFPatternMatch {
    String pattern;
    boolean negate = false;
    boolean atStart = false;
    boolean atEnd = false;
    final char[] metaCharacters = new char[]{'\\', '|', '(', ')', '[', '{', '^', '$', '*', '+', '.', '?', '!'};

    boolean isMetaCharacter(Character c) {
        for (char metaChar : this.metaCharacters) {
            if (!c.equals(Character.valueOf(metaChar))) continue;
            return true;
        }
        return false;
    }

    void parsePattern(String str) {
        boolean error = false;
        int len = str.length();
        StringBuilder newPattern = new StringBuilder();
        block6: for (int i = 0; i < len && !error; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '!': {
                    if (i == 0) {
                        this.negate = true;
                        continue block6;
                    }
                    error = true;
                    continue block6;
                }
                case '^': {
                    if (this.negate && i == 1 || !this.negate && i == 0) {
                        this.atStart = true;
                        continue block6;
                    }
                    error = true;
                    continue block6;
                }
                case '$': {
                    if (i + 1 == len) {
                        this.atEnd = true;
                        continue block6;
                    }
                    error = true;
                    continue block6;
                }
                case '\\': {
                    char nextChar;
                    if (i + 1 == len) {
                        error = true;
                        continue block6;
                    }
                    if (this.isAlphaNumeric(nextChar = str.charAt(++i))) {
                        error = true;
                        continue block6;
                    }
                    newPattern.append(nextChar);
                    continue block6;
                }
                default: {
                    if (this.isMetaCharacter(Character.valueOf(c))) {
                        error = true;
                        continue block6;
                    }
                    newPattern.append(c);
                }
            }
        }
        if (error) {
            String msg = "The macro functions contains a bad search pattern";
            throw new RuntimeException(msg);
        }
        this.pattern = newPattern.toString();
    }

    boolean passesPattern(String str) {
        int[] offsets = new int[2];
        boolean matches = this.getPatternOffsets(str, offsets);
        if (this.negate) {
            return !matches;
        }
        return matches;
    }

    boolean getPatternOffsets(String str, int[] offsets) {
        int findPos = 0;
        int start = -1;
        int end = -1;
        int findIndex = this.pattern.length() == 0 ? 0 : str.indexOf(this.pattern, findPos);
        boolean matches = true;
        if (findIndex == -1) {
            matches = false;
        }
        if (matches && this.atStart && findIndex != 0) {
            matches = false;
        }
        if (matches && this.atEnd) {
            if (this.atStart) {
                if (str.equals(this.pattern)) {
                    start = findIndex;
                    end = findIndex + this.pattern.length();
                } else {
                    matches = false;
                }
            } else {
                String lastPart = str.substring(str.length() - this.pattern.length());
                if (lastPart.equals(this.pattern)) {
                    start = str.length() - this.pattern.length();
                    end = str.length();
                } else {
                    matches = false;
                }
            }
        } else if (matches) {
            start = findIndex;
            end = findIndex + this.pattern.length();
        }
        offsets[0] = start;
        offsets[1] = end;
        return matches;
    }

    private boolean isAlphaNumeric(char c) {
        String alphaNumChars = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        return "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) >= 0;
    }
}

