/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.DataTypeEnum;
import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MFPromptMany;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.ast.macro.MacroPromptUtils;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.transformation.v5tocogsql.util.QuerySubjectSQLGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.List;

public class MFPrompt
extends MFAbstractFunction {
    static final String COMMA = ",";
    static final String DIGITS = "0123456789";
    static final String DOUBLE_BACKSLASH = "\\\\";
    static final String ESCAPED_SINGLE_QUOTE = "\\'";
    static final String PERIOD = ".";
    static final String SINGLE_BACKSLASH = "\\";
    static final String SINGLE_QUOTE = "'";
    static final String STRING_TYPE_NAME = "string";
    static final String WHITESPACES = " \n\t";
    public static final String DROP_FILTER_MACRO_PROMPT_NIL = "dropFilterDueToNilMacroPromptValue";
    public static final String DROP_FILTER_PROMPT_HANDLING_NOFAULT = "dropFilterDueToPromptHandlingNoFault";
    ContextType cxtType = null;
    String listSeparatorFromSplitFunction;

    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        Parameters contextParams;
        MultiRequestContext mrc;
        String parameterName;
        Parameter param;
        MasterDetailProvider mdProvider;
        boolean isMasterDetail;
        IValue sixthArg;
        IValue fifthArg;
        IValue fourthArg;
        IValue thirdArg;
        IValue secondArg;
        String token;
        IValue firstArg;
        int numArgs;
        MXFunction function;
        IXQEQueryNode parent;
        this.cxtType = this.getContextType(theFunctionNode);
        this.listSeparatorFromSplitFunction = null;
        if (this instanceof MFPromptMany && (parent = theFunctionNode.getParent()) != null && parent.getType() == 1001020 && (function = (MXFunction)parent).getName() == "split" && (numArgs = function.getNumberChildren()) == 2 && (firstArg = function.getParameter(theContext, 0)) instanceof StringValue && ((token = firstArg.toString()).equals(";") || token.equals(COMMA))) {
            this.listSeparatorFromSplitFunction = token;
        }
        int maxArgsAllowed = 6;
        int numArgs2 = theFunctionNode.getNumberChildren();
        String promptName = null;
        boolean variableUsedInName = false;
        if (numArgs2 >= 1) {
            theContext.setVariableUsed(false);
            IValue firstArg2 = theFunctionNode.getParameter(theContext, 0);
            variableUsedInName = theContext.getVariableUsed();
            theContext.setVariableUsed(false);
            if (firstArg2 instanceof StringValue) {
                promptName = firstArg2.toString().trim();
                if (promptName.length() == 0) {
                    promptName = "aPrompt";
                }
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg2, STRING_TYPE_NAME);
            }
        } else {
            this.throwErrorNumberOfArguments(numArgs2, 1, 6);
        }
        String dataTypeName = STRING_TYPE_NAME;
        if (numArgs2 >= 2 && (secondArg = theFunctionNode.getParameter(theContext, 1)) instanceof StringValue) {
            dataTypeName = secondArg.toString();
        }
        String defaultText = new String();
        int thirdArgIndex = 2;
        if (numArgs2 >= 3 && (thirdArg = theFunctionNode.getParameter(theContext, 2)) instanceof StringValue) {
            defaultText = thirdArg.toString();
        }
        String textPreceding = new String();
        int fourthArgIndex = 3;
        if (numArgs2 >= 4 && (fourthArg = theFunctionNode.getParameter(theContext, 3)) instanceof StringValue) {
            textPreceding = fourthArg.toString();
        }
        String modelItem = null;
        int fifthArgIndex = 4;
        if (numArgs2 >= 5 && (fifthArg = theFunctionNode.getParameter(theContext, 4)) instanceof StringValue) {
            modelItem = fifthArg.toString();
        }
        String textFollowing = new String();
        int sixthArgIndex = 5;
        if (numArgs2 >= 6 && (sixthArg = theFunctionNode.getParameter(theContext, 5)) instanceof StringValue) {
            textFollowing = sixthArg.toString();
        }
        boolean formatTheValue = true;
        DataTypeEnum dataTypeEnumVal = MacroPromptUtils.getEnumValueFromDataTypeName(dataTypeName);
        if (dataTypeName.equalsIgnoreCase("token")) {
            formatTheValue = false;
        } else if (this.cxtType == ContextType.eSAPTableFunctionParameter) {
            formatTheValue = false;
        } else {
            switch (dataTypeEnumVal) {
                case DATE: 
                case TIMESTAMP: 
                case TIMESTAMPTZ: 
                case TIME: 
                case TIMETZ: 
                case INTERVAL: 
                case INTERVALYM: {
                    if (this.cxtType != ContextType.eExpression && this.cxtType != ContextType.eOptionalExpression && this.cxtType != ContextType.eProcedureParameter && this.cxtType != ContextType.eNativeSQL) break;
                    formatTheValue = false;
                    break;
                }
                case STRING: {
                    if (this.cxtType != ContextType.eProcedureParameter) break;
                    formatTheValue = false;
                    break;
                }
                case FLOAT: 
                case DOUBLE: 
                case DECIMAL: {
                    if (this.cxtType != ContextType.eExpression && this.cxtType != ContextType.eOptionalExpression) break;
                    formatTheValue = false;
                    break;
                }
                case MEMBERUNIQUENAME: {
                    formatTheValue = false;
                    break;
                }
                default: {
                    formatTheValue = true;
                }
            }
        }
        IDataType dataType = dataTypeEnumVal.getDataType();
        RequestEnvironment reqEnv = (RequestEnvironment)theContext.getEnvironment().getRequestEnvironment();
        Parameters parameters = reqEnv.getRequestParameters();
        String queryName = MFPrompt.getQueryName(theFunctionNode);
        if ((queryName == null || queryName.isEmpty() || queryName.equals("_prePlanV5Query")) && theContext.getQueryName() != null) {
            queryName = theContext.getQueryName();
        }
        if (!(isMasterDetail = (mdProvider = reqEnv.getMasterDetailProvider()).isMasterDetailLinkParameter(promptName, queryName)) && mdProvider.isDetailQuery(queryName)) {
            isMasterDetail = mdProvider.isSameParameterInMasterQuery(promptName, queryName);
        }
        if ((param = parameters.getParameter(parameterName = parameters.getParameterName(promptName, queryName, isMasterDetail, theFunctionNode.getPlanningEnvironment()))) == null && (param = (mrc = theContext.getEnvironment().getMultiRequestContext()).getEffectiveGlobalParameter(parameterName, reqEnv)) != null) {
            parameters.addParameter(param.getName(), param);
        }
        if (param == null && (param = (contextParams = theContext.getLocalParameters()).getParameter(parameterName)) != null) {
            parameters = contextParams;
        }
        boolean bNewParam = false;
        if (null == param) {
            param = new Parameter(parameterName, queryName);
            if (!promptName.equals(parameterName)) {
                param.setOriginalName(promptName);
            }
            parameters.addParameter(parameterName, param);
            bNewParam = true;
        } else {
            param.setQueryName(queryName);
        }
        MFPrompt.updateModelPathForParameter(theFunctionNode, param);
        param.setMasterDetailLinkParameter(isMasterDetail);
        param.setDataType(dataType);
        param.setParameterValueRequiredBeforePlanning(param.isMasterDetailLinkParameter());
        if (param.isMasterDetailLinkParameter()) {
            if (!mdProvider.isDetailQuery(queryName)) {
                List<String> mdLinkNames = mdProvider.getMasterDetailLinkNamesForParameter(promptName, queryName);
                for (String mdLinkName : mdLinkNames) {
                    if (mdLinkName == null || mdProvider.getLink(mdLinkName) == null) continue;
                    String detailQueryName = mdProvider.getLink(mdLinkName).getDetailQueryName();
                    if (((ExecutionEnvironment)reqEnv.getExecutionEnvironment()).getMultiRequestContext().queryRequiresReplan(detailQueryName)) continue;
                    reqEnv.addQueryRequiresReplan(detailQueryName);
                }
            } else {
                reqEnv.addQueryRequiresReplan(queryName);
            }
        }
        param.getCapabilities().setMultivalued(this.getFunctionName().equals("promptmany"));
        if (param.getCapabilities().isUsedInSingleAndMultiValueContext()) {
            ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_PromptMultiAndSingleSelect, parameterName);
            theFunctionNode.getPlanningEnvironment().getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
        }
        this.markParamForNoFaultPromptHandlingHint(theFunctionNode, param);
        if (defaultText == null || defaultText.isEmpty()) {
            this.markParentFilterNodeForRemovalForNoFaultHandlingHint(theFunctionNode);
        }
        boolean hasDefaultValue = true;
        if (this.cxtType == ContextType.eOptionalExpression) {
            param.getCapabilities().setOptional(true);
            hasDefaultValue = true;
            if (defaultText.length() == 0) {
                defaultText = MacroPromptUtils.getDummyValue4DataType(dataType, promptName);
                if (formatTheValue) {
                    defaultText = MacroPromptUtils.genNicePromptValue(defaultText, dataType);
                }
            }
        } else if (defaultText.length() == 0) {
            param.getCapabilities().setOptional(false);
            hasDefaultValue = false;
            param.setExplicitValueRequired(true);
        } else {
            param.getCapabilities().setOptional(true);
            hasDefaultValue = true;
        }
        if (modelItem != null && modelItem.length() > 0) {
            String trimmedModelItem = RQPUtilities.getTrimmedModelItemWithAlias(theContext.getEnvironment(), modelItem);
            param.setModelItem(trimmedModelItem);
        }
        if (variableUsedInName) {
            param.setNameVariable(true);
        }
        param.bindToRequest(reqEnv);
        String promptValue = null;
        String providedValue = this.getPromptValue(param, parameters, formatTheValue, bNewParam, theContext.getMacroContext().getPlanningEnvironment());
        if (providedValue != null) {
            promptValue = textPreceding + providedValue + textFollowing;
        } else if (hasDefaultValue) {
            promptValue = defaultText;
            if (this.cxtType == ContextType.eOptionalExpression || this.cxtType == ContextType.eSAPTableFunctionParameter) {
                this.markParentFilterNodeForRemoval(theFunctionNode);
            }
        } else {
            promptValue = MacroPromptUtils.getDummyValue4DataType(dataType, promptName);
            if (formatTheValue) {
                promptValue = MacroPromptUtils.genNicePromptValue(promptValue, param.getDataType());
            }
            promptValue = textPreceding + promptValue + textFollowing;
        }
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set(promptValue);
        return outputVal;
    }

    private void markParentFilterNodeForRemovalForNoFaultHandlingHint(MXFunction theFunctionNode) {
        V5QuerySet querySet;
        IXQEQueryNode filter = theFunctionNode.getAncestorOfTypes(new int[]{101076, 101008, 101011, 801035});
        if (filter != null && (querySet = (V5QuerySet)filter.getAncestorOfType(101002)) != null && querySet.getIsPromptHandlingNoFault()) {
            filter.setPropertyValue(DROP_FILTER_PROMPT_HANDLING_NOFAULT, true);
        }
    }

    private void markParamForNoFaultPromptHandlingHint(MXFunction theFunctionNode, Parameter param) {
        V5QuerySet querySet;
        IXQEQueryNode filter = theFunctionNode.getAncestorOfTypes(new int[]{101076, 101008, 101011, 801035});
        if (filter != null && (querySet = (V5QuerySet)filter.getAncestorOfType(101002)) != null && querySet.getIsPromptHandlingNoFault()) {
            param.setPromptHandlingNoFault();
        }
    }

    public static void updateModelPathForParameter(MXFunction theFunctionNode, Parameter theParameter) {
        IPlanningEnvironment planEnv = theFunctionNode.getPlanningEnvironment();
        if (planEnv instanceof PlanningEnvironment && ((PlanningEnvironment)planEnv).isMultimodelCase()) {
            V5Query v5Query;
            String modelPath = null;
            boolean sqlQuery = false;
            if (planEnv.getRoot().getType() == 101002 && theParameter.getQueryName() != null && (v5Query = ((V5QuerySet)planEnv.getRoot()).getV5Query(theParameter.getQueryName())) != null) {
                if (v5Query.isSqlQuery()) {
                    sqlQuery = true;
                }
                modelPath = v5Query.getMetadataPathInSource();
            }
            if (!sqlQuery && modelPath == null) {
                modelPath = planEnv.getModelPath();
            }
            if (modelPath != null && !modelPath.isEmpty()) {
                theParameter.setModelPath(modelPath);
            }
        }
    }

    public ContextType getContextType(MXFunction funcNode) {
        ContextType result = ContextType.eExpression;
        IXQEQueryNode filter = funcNode.getAncestorOfTypes(new int[]{101008, 101011});
        if (filter != null) {
            if (filter.getType() == 101008) {
                if (((V5DetailFilter)filter).getUseProperty().equals("optional")) {
                    result = ContextType.eOptionalExpression;
                }
            } else if (filter.getType() == 101011 && ((V5SummaryFilter)filter).getUseProperty().equals("optional")) {
                result = ContextType.eOptionalExpression;
            }
            return result;
        }
        IXQEQueryNode rmEmbeddedFilter = funcNode.getAncestorOfType(801035);
        if (rmEmbeddedFilter != null) {
            if (((RMEmbeddedFilter)rmEmbeddedFilter).getApply().equals("asNeeded")) {
                result = ContextType.eOptionalExpression;
            }
            return result;
        }
        IXQEQueryNode storedProcNode = funcNode.getAncestorOfTypes(new int[]{801030, 101076});
        if (storedProcNode != null) {
            String prop = (String)storedProcNode.getPropertyValue("format");
            if ("sap".equals(prop)) {
                return ContextType.eSAPTableFunctionParameter;
            }
            return ContextType.eProcedureParameter;
        }
        IXQEQueryNode sqlNode = funcNode.getAncestorOfTypes(new int[]{801028, 801027});
        if (sqlNode != null) {
            QuerySubjectSQLGenerator.SqlType sqlType = (QuerySubjectSQLGenerator.SqlType)((Object)sqlNode.getPropertyValue("sqlType"));
            if (sqlType == QuerySubjectSQLGenerator.SqlType.NATIVE || sqlType == QuerySubjectSQLGenerator.SqlType.PASS_THROUGH) {
                return ContextType.eNativeSQL;
            }
            return ContextType.eSQL;
        }
        sqlNode = funcNode.getAncestorOfType(101016);
        if (sqlNode != null) {
            String sqlTypeStr = ((V5SqlQuery)sqlNode).getSqlType();
            if (sqlTypeStr != null) {
                QuerySubjectSQLGenerator.SqlType sqlType = QuerySubjectSQLGenerator.getSqlType(((V5SqlQuery)sqlNode).getSqlType());
                if (sqlType == QuerySubjectSQLGenerator.SqlType.NATIVE || sqlType == QuerySubjectSQLGenerator.SqlType.PASS_THROUGH) {
                    return ContextType.eNativeSQL;
                }
                return ContextType.eSQL;
            }
            return ContextType.eNativeSQL;
        }
        return result;
    }

    public void markParentFilterNodeForRemoval(MXFunction funcNode) {
        IXQEQueryNode filter = funcNode.getAncestorOfTypes(new int[]{101076, 101008, 101011, 801035});
        if (filter != null) {
            filter.setPropertyValue(DROP_FILTER_MACRO_PROMPT_NIL, true);
        }
    }

    public String getPromptValue(Parameter param, Parameters contextParams, boolean formatTheValue, boolean bNewParam, IPlanningEnvironment env) {
        IValue[] promptValues = MacroPromptUtils.getParameterPromptValues(param, contextParams, bNewParam, env);
        if (promptValues == null) {
            return null;
        }
        if (promptValues.length == 0) {
            return null;
        }
        Value value = (Value)promptValues[0];
        if (value.getState() == ValueState.NULL) {
            return null;
        }
        String promptValueStr = value.toString();
        if (promptValueStr.length() == 0) {
            return null;
        }
        if (formatTheValue) {
            promptValueStr = MacroPromptUtils.genNicePromptValue(promptValueStr, param.getDataType());
        } else if (this.cxtType == ContextType.eSAPTableFunctionParameter) {
            promptValueStr = promptValueStr.replace(SINGLE_BACKSLASH, DOUBLE_BACKSLASH);
            promptValueStr = promptValueStr.replace(SINGLE_QUOTE, ESCAPED_SINGLE_QUOTE);
        }
        return promptValueStr;
    }

    @Override
    public String getFunctionName() {
        return "prompt";
    }

    public static String getQueryName(MXFunction theFunctionNode) {
        V5Query v5Query = (V5Query)theFunctionNode.getAncestorOfType(101006);
        if (null != v5Query) {
            return v5Query.getRootQueryName();
        }
        RQPQuery rqpQuery = (RQPQuery)theFunctionNode.getAncestorOfType(801017);
        if (null != rqpQuery) {
            return rqpQuery.getName();
        }
        return new String();
    }

    public static enum ContextType {
        eExpression,
        eOptionalExpression,
        eSQL,
        eNativeSQL,
        eProcedureParameter,
        eSAPTableFunctionParameter;

    }
}

