/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFPrompt;
import com.cognos.xqe.ast.macro.MacroPromptUtils;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;

public class MFPromptMany
extends MFPrompt {
    static final String DOUBLE_BACKSLASH = "\\\\";
    static final String ESCAPED_SINGLE_QUOTE = "\\'";
    static final String SINGLE_BACKSLASH = "\\";
    static final String SINGLE_QUOTE = "'";

    @Override
    public String getPromptValue(Parameter param, Parameters contextParams, boolean formatTheValue, boolean bNewParam, IPlanningEnvironment env) {
        IValue[] promptValues = MacroPromptUtils.getParameterPromptValues(param, contextParams, bNewParam, env);
        if (promptValues == null) {
            return null;
        }
        if (promptValues.length == 0) {
            return null;
        }
        String listSP = this.listSeparatorFromSplitFunction;
        if (listSP == null) {
            switch (this.cxtType) {
                case eOptionalExpression: 
                case eExpression: {
                    listSP = ";";
                    break;
                }
                case eNativeSQL: {
                    XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                    boolean addSpace = configuration.getBooleanProperty("queryPlanning.addSpaceToPromptManySeparatorForNativeSQL[@enabled]", true);
                    if (addSpace) {
                        listSP = ", ";
                        break;
                    }
                    listSP = ",";
                    break;
                }
                default: {
                    listSP = ",";
                }
            }
        }
        String promptValue = "";
        for (int i = 0; i < promptValues.length; ++i) {
            Value currentValue;
            if (i > 0) {
                promptValue = promptValue + listSP;
            }
            String currentValueStr = (currentValue = (Value)promptValues[i]).getState() == ValueState.NULL ? "" : promptValues[i].toString();
            if (formatTheValue) {
                promptValue = promptValue + MacroPromptUtils.genNicePromptValue(currentValueStr, param.getDataType());
                continue;
            }
            if (this.cxtType == MFPrompt.ContextType.eSAPTableFunctionParameter) {
                String str = currentValue.getString();
                str = str.replace(SINGLE_BACKSLASH, DOUBLE_BACKSLASH);
                str = str.replace(SINGLE_QUOTE, ESCAPED_SINGLE_QUOTE);
                promptValue = promptValue + SINGLE_QUOTE + str + SINGLE_QUOTE;
                continue;
            }
            promptValue = promptValue + currentValue;
        }
        return promptValue;
    }

    @Override
    public String getFunctionName() {
        return "promptmany";
    }
}

