/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import java.util.ArrayList;

public class MFStrip
extends MFAbstractFunction {
    public static final String STRIP = "strip";
    public static final String LSTRIP = "lstrip";
    public static final String RSTRIP = "rstrip";

    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs >= 1) {
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            String charactersToStrip = " \t\r\n";
            if (numArgs >= 2) {
                IValue secondArg = theFunctionNode.getParameter(theContext, 1);
                if (secondArg instanceof StringValue) {
                    charactersToStrip = secondArg.toString();
                } else {
                    this.throwErrorInvalidArgumentType(2, secondArg, "string");
                }
            }
            if (firstArg instanceof ArrayValue) {
                ArrayValue inputArray = (ArrayValue)firstArg;
                Value[] inputValues = inputArray.getValues();
                int len = inputValues.length;
                ArrayList<StringValue> outValues = new ArrayList<StringValue>();
                for (int i = 0; i < len; ++i) {
                    if (!(inputValues[i] instanceof StringValue)) continue;
                    StringValue outVal = DataValueFactory.createStringValue();
                    String sval = inputValues[i].toString();
                    String funcName = this.getFunctionName();
                    if (funcName.equals(STRIP) || funcName.equals(LSTRIP)) {
                        sval = this.ltrim(sval, charactersToStrip);
                    }
                    if (funcName.equals(STRIP) || funcName.equals(RSTRIP)) {
                        sval = this.rtrim(sval, charactersToStrip);
                    }
                    outVal.set(sval);
                    outValues.add(outVal);
                }
                ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), outValues.size());
                ArrayValue outputArray = DataValueFactory.createArrayValue(dType);
                outputArray.set(new StringValue[len]);
                StringValue[] x = new StringValue[]{};
                outputArray.set(outValues.toArray(x));
                return outputArray;
            }
            StringValue outputVal = DataValueFactory.createStringValue();
            outputVal.set("");
            String sval = firstArg.toString();
            String funcName = this.getFunctionName();
            if (funcName.equals(STRIP) || funcName.equals(LSTRIP)) {
                sval = this.ltrim(sval, charactersToStrip);
            }
            if (funcName.equals(STRIP) || funcName.equals(RSTRIP)) {
                sval = this.rtrim(sval, charactersToStrip);
            }
            outputVal.append(sval);
            return outputVal;
        }
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set("");
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return STRIP;
    }

    private String ltrim(String str, String charCollection) {
        int i;
        for (i = 0; i < str.length() && charCollection.contains(str.substring(i, i + 1)); ++i) {
        }
        return str.substring(i);
    }

    private String rtrim(String str, String charCollection) {
        int i;
        int strLen = str.length();
        for (i = strLen - 1; i >= 0 && charCollection.contains(str.substring(i, i + 1)); --i) {
        }
        return str.substring(0, i + 1);
    }
}

