/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractBTFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.runtree.XDataContext;

public class MFTimestampMask
extends MFAbstractBTFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs == 2) {
            String inputTimestamp = null;
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            if (firstArg instanceof StringValue) {
                inputTimestamp = firstArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(1, firstArg, "string");
            }
            String formatString = null;
            IValue secondArg = theFunctionNode.getParameter(theContext, 1);
            if (secondArg instanceof StringValue) {
                formatString = secondArg.toString();
            } else {
                this.throwErrorInvalidArgumentType(2, secondArg, "string");
            }
            String formattedTimestamp = this.formatTimestamp(inputTimestamp, formatString);
            StringValue outputVal = DataValueFactory.createStringValue();
            outputVal.set(formattedTimestamp);
            return outputVal;
        }
        this.throwErrorNumberOfArguments(numArgs, 1);
        return null;
    }

    private String formatTimestamp(String timestamp, String formatStr) {
        TimestampWithTZValue ts = MFTimestampMask.createTimestampWithTZValueFromString(timestamp);
        int year = ts.getYear();
        int month = ts.getMonth();
        int day = ts.getDay();
        int hour = ts.getHour();
        int minute = ts.getMinute();
        int second = ts.getSecond();
        long nanosec = ts.getNanoseconds();
        int tzHour = ts.getTimeZoneHour();
        int tzMinute = ts.getTimeZoneMinute();
        char sign = '+';
        if (tzHour < 0) {
            tzHour = -tzHour;
            tzMinute = -tzMinute;
            sign = '-';
        }
        long oneMillion = 1000000L;
        int millisec = (int)(nanosec / 1000000L);
        String result = new String();
        formatStr = formatStr.toLowerCase();
        String twoDigitPattern = "%1$02d";
        if (formatStr.equals("yyyy")) {
            result = String.format("%1$4d", year);
        } else if (formatStr.equals("mm")) {
            result = String.format("%1$02d", month);
        } else if (formatStr.equals("dd")) {
            result = String.format("%1$02d", day);
        } else if (formatStr.equals("yyyy-mm")) {
            result = String.format("%1$4d-%2$02d", year, month);
        } else if (formatStr.equals("yyyymm")) {
            result = String.format("%1$4d%2$02d", year, month);
        } else if (formatStr.equals("yyyy-mm-dd")) {
            result = String.format("%1$4d-%2$02d-%3$02d", year, month, day);
        } else if (formatStr.equals("yyyymmdd")) {
            result = String.format("%1$4d%2$02d%3$02d", year, month, day);
        } else if (formatStr.equals("yyyy-mm-dd hh:mm:ss")) {
            result = String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d", year, month, day, hour, minute, second);
        } else if (formatStr.equals("yyyy-mm-dd hh:mm:ss+hh:mm")) {
            result = String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d%7$1c%8$02d:%9$02d", year, month, day, hour, minute, second, Character.valueOf(sign), tzHour, tzMinute);
        } else if (formatStr.equals("yyyy-mm-dd hh:mm:ss.ff3")) {
            result = String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d.%7$03d", year, month, day, hour, minute, second, millisec);
        } else if (formatStr.equals("yyyy-mm-dd hh:mm:ss.ff3+hh:mm")) {
            result = String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d.%7$03d%8$1c%9$02d:%10$02d", year, month, day, hour, minute, second, millisec, Character.valueOf(sign), tzHour, tzMinute);
        } else if (formatStr.equals("yyyy-mm-ddthh:mm:ss")) {
            result = String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d", year, month, day, hour, minute, second);
        } else if (formatStr.equals("yyyy-mm-ddthh:mm:ss+hh:mm")) {
            result = String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d%7$1c%8$02d:%9$02d", year, month, day, hour, minute, second, Character.valueOf(sign), tzHour, tzMinute);
        } else if (formatStr.equals("yyyy-mm-ddthh:mm:ss.ff3")) {
            result = String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d.%7$03d", year, month, day, hour, minute, second, millisec);
        } else if (formatStr.equals("yyyy-mm-ddthh:mm:ss.ff3+hh:mm")) {
            result = String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d.%7$03d%8$1c%9$02d:%10$02d", year, month, day, hour, minute, second, millisec, Character.valueOf(sign), tzHour, tzMinute);
        }
        return result;
    }

    @Override
    public String getFunctionName() {
        return "timestampmask";
    }
}

