/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MXFunction;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.LocaleConverter;
import java.util.ArrayList;
import java.util.Locale;

public class MFToLower
extends MFAbstractFunction {
    @Override
    IValue executeImpl(XDataContext theContext, MXFunction theFunctionNode) {
        int numArgs = theFunctionNode.getNumberChildren();
        if (numArgs >= 1) {
            IValue firstArg = theFunctionNode.getParameter(theContext, 0);
            String localeStr = "en";
            if (numArgs >= 2) {
                IValue secondArg = theFunctionNode.getParameter(theContext, 1);
                if (secondArg instanceof StringValue) {
                    localeStr = secondArg.toString();
                } else {
                    this.throwErrorInvalidArgumentType(2, secondArg, "string");
                }
            }
            Locale locale = LocaleConverter.strToLocale(localeStr);
            if (firstArg instanceof ArrayValue) {
                ArrayValue inputArray = (ArrayValue)firstArg;
                Value[] inputValues = inputArray.getValues();
                int len = inputValues.length;
                ArrayList<StringValue> outValues = new ArrayList<StringValue>();
                for (int i = 0; i < len; ++i) {
                    if (!(inputValues[i] instanceof StringValue)) continue;
                    StringValue outVal = DataValueFactory.createStringValue();
                    String sval = inputValues[i].toString();
                    sval = locale != null ? sval.toLowerCase(locale) : sval.toLowerCase();
                    outVal.set(sval);
                    outValues.add(outVal);
                }
                ArrayType dType = DataTypeFactory.getArrayType(DataTypeFactory.getStringType(), outValues.size());
                ArrayValue outputArray = DataValueFactory.createArrayValue(dType);
                outputArray.set(new StringValue[len]);
                StringValue[] x = new StringValue[]{};
                outputArray.set(outValues.toArray(x));
                return outputArray;
            }
            StringValue outputVal = DataValueFactory.createStringValue();
            outputVal.set("");
            String sval = firstArg.toString();
            sval = locale != null ? sval.toLowerCase(locale) : sval.toLowerCase();
            outputVal.append(sval);
            return outputVal;
        }
        StringValue outputVal = DataValueFactory.createStringValue();
        outputVal.set("");
        return outputVal;
    }

    @Override
    public String getFunctionName() {
        return "tolower";
    }
}

