/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MXNode;
import com.cognos.xqe.ast.macro.MXVariable;
import com.cognos.xqe.ast.macro.MacroContext;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.XDataContext;

public class MXAssignment
extends MXNode {
    @Override
    IValue executeImpl(XDataContext context) throws MacroException {
        MacroContext macroContext = context.getMacroContext();
        IValue outputVal = null;
        MXVariable var = (MXVariable)this.getChild(0);
        String varName = var.getName();
        if (!macroContext.isDefinedInCurrentBlock(varName)) {
            MXAssignment.throwUndefinedVariable(var, varName);
        }
        MXNode c1 = (MXNode)this.getChild(1);
        MXAssignment.doAssignment(context, var, c1);
        return outputVal;
    }

    @Override
    public int getType() {
        return 1001013;
    }

    protected static void throwUndefinedVariable(MXNode mxn, String varName) {
        String msg = "Undefined variable '" + varName + "'.";
        MacroException me = new MacroException(msg);
        StackTraceElement ste = new StackTraceElement(mxn.getNodeTypeName(), mxn.getTraceName(), "file", mxn.getBeginLine());
        me.addMacroStackTraceElement(ste);
        throw me;
    }

    protected static void throwIllegalAssignment(String varName, String expType, String actType) {
        String msg = "Illegal assignment of " + actType + " to " + expType + " variable '" + varName + "'.";
        throw new MacroException(msg);
    }

    public static void doAssignment(XDataContext context, IXQEQueryNode lvalue, MXNode expr) throws MacroException {
        MXVariable lvalueVar;
        String var0;
        MacroContext macroContext = context.getMacroContext();
        if (!macroContext.isDefinedInCurrentBlock(var0 = (lvalueVar = (MXVariable)lvalue).getName())) {
            MXAssignment.throwUndefinedVariable(lvalueVar, var0);
        }
        IValue rValue = expr.execute(context);
        macroContext.setVariable(var0, rValue);
    }
}

