/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MXArray;
import com.cognos.xqe.ast.macro.MXNode;
import com.cognos.xqe.ast.macro.MXObject;
import com.cognos.xqe.ast.macro.MacroContext;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.runtree.XDataContext;

public class MXVariableArrayEntry
extends MXNode {
    private String name;

    @Override
    IValue executeImpl(XDataContext context) {
        MacroContext macroContext = context.getMacroContext();
        int idx = -1;
        String key = this.getName();
        IValue v = macroContext.getVariable(key);
        if (v == null) {
            MacroContext.throwMacroExceptionReferenceNotFound(this, key);
        }
        String idxStr = null;
        for (int cno = 0; cno < this.getNumberChildren(); ++cno) {
            IValue kval = this.getParameter(context, cno);
            if (kval instanceof IntegerValue) {
                IntegerValue ival = (IntegerValue)kval;
                idx = ival.getInteger();
                idxStr = kval.toString();
            } else if (kval instanceof StringValue) {
                StringValue sval = (StringValue)kval;
                if (v instanceof ArrayValue || v instanceof MXArray) {
                    idx = this.getInteger(sval);
                } else {
                    idxStr = sval.getValue();
                }
            } else {
                throw new MacroException("Macro exception - variable is of an unsupported type");
            }
            if (v instanceof ArrayValue) {
                ArrayValue aval = (ArrayValue)v;
                if (idx >= 0 && idx < aval.size()) {
                    v = aval.getElement(idx);
                    continue;
                }
                this.throwIndexOutOfRange(key, aval.size(), idx);
                continue;
            }
            if (v instanceof MXArray) {
                MXArray arr = (MXArray)v;
                if (idx >= 0 && idx < arr.size()) {
                    v = arr.get(idx);
                    continue;
                }
                this.throwIndexOutOfRange(key, arr.size(), idx);
                continue;
            }
            if (v instanceof MXObject) {
                MXObject hm = (MXObject)v;
                v = hm.get(idxStr);
                continue;
            }
            this.throwNotAnArray(key);
        }
        this.setPropertyValue("result", v);
        return v;
    }

    @Override
    public int getType() {
        return 1001027;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNodeTypeName()).append(":");
        if (this.getName() != null) {
            sb.append(this.getName());
        }
        return sb.toString();
    }

    protected void throwIndexOutOfRange(String varName, int theSize, int theIndex) {
        String msg = "Index out of range error, variable '" + varName + "', low=0, high=" + (theSize - 1) + ", index=" + theIndex;
        MacroException me = new MacroException(msg);
        StackTraceElement ste = new StackTraceElement(this.getNodeTypeName(), this.getTraceName(), "file", this.getBeginLine());
        me.addMacroStackTraceElement(ste);
        throw me;
    }

    protected void throwNotAnArray(String varName) {
        String msg = "Indexing is only supported for arrays. Variable '" + varName + "' is not an array.";
        MacroException me = new MacroException(msg);
        StackTraceElement ste = new StackTraceElement(this.getNodeTypeName(), this.getTraceName(), "file", this.getBeginLine());
        me.addMacroStackTraceElement(ste);
        throw me;
    }
}

