/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.MXNode;
import com.cognos.xqe.ast.macro.MXUndefined;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.util.LinkedStack;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import java.util.HashMap;

public final class MacroContext {
    private MacroExpander expander;
    private ParameterAccessCoordinator pac;
    private Object macroOwner;
    private IPlanningEnvironment env;
    private int macroNestedLevel = 0;
    public static final int MAX_NESTED_LEVELS = 10;
    private LinkedStack<VariableSymbolTable> scopedVariables;
    private StringBuilder execTrace = null;
    private int traceExecDepth = 0;
    private static String traceWhiteSpace = "    ";

    public void traceStart() {
        this.execTrace = new StringBuilder();
        this.traceExecDepth = 0;
    }

    public String traceEnd() {
        if (this.execTrace == null) {
            return null;
        }
        String res = this.execTrace.toString();
        this.execTrace = null;
        return res;
    }

    public boolean traceIsOn() {
        return this.execTrace != null;
    }

    public void trace(String msg) {
        int md = Math.min(this.traceExecDepth, 10);
        for (int i = 0; i < md; ++i) {
            this.execTrace.append(traceWhiteSpace);
        }
        if (md < this.traceExecDepth) {
            this.execTrace.append(String.valueOf(this.traceExecDepth));
            this.execTrace.append(" ");
        }
        this.execTrace.append(msg).append('\n');
    }

    public void traceEnter() {
        ++this.traceExecDepth;
    }

    public void traceExit() {
        --this.traceExecDepth;
    }

    public MacroContext(ParameterAccessCoordinator thePac, MacroExpander theExpander, Object owner, IPlanningEnvironment planEnv) {
        this.expander = theExpander;
        this.pac = thePac;
        this.macroOwner = owner;
        this.env = planEnv;
        this.scopedVariables = new LinkedStack();
    }

    public MacroExpander getExpander() {
        return this.expander;
    }

    public int getMacroNestedLevel() {
        return this.macroNestedLevel;
    }

    public void incrementMacroNestedLevel() {
        ++this.macroNestedLevel;
    }

    public void decrementMacroNestedLevel() {
        --this.macroNestedLevel;
    }

    public ParameterAccessCoordinator getPAC() {
        return this.pac;
    }

    public Object getOwner() {
        return this.macroOwner;
    }

    public void release() {
        this.expander = null;
        this.pac = null;
    }

    public void enterScope() {
        VariableSymbolTable pmaps = new VariableSymbolTable();
        this.scopedVariables.push(pmaps);
    }

    public void exitScope() {
        this.scopedVariables.pop();
    }

    public void setVariable(String varName, IValue val) {
        if (this.traceIsOn() && !(val instanceof MXUndefined)) {
            String msg = varName + " = ";
            msg = val == null ? msg + "null" : msg + val.toString();
            this.trace(msg);
        }
        this.scopedVariables.peek().put(varName, val);
    }

    public void setVariableNoTrace(String varName, IValue val) {
        this.scopedVariables.peek().put(varName, val);
    }

    public boolean isDefinedInCurrentBlock(String varName) {
        return this.scopedVariables.peek().containsKey(varName);
    }

    public boolean isDefined(String varName) {
        for (VariableSymbolTable symbolTable : this.scopedVariables) {
            IValue val = symbolTable.get(varName);
            if (val == null) continue;
            return true;
        }
        return false;
    }

    public IValue getVariable(String varName) {
        for (VariableSymbolTable symbolTable : this.scopedVariables) {
            IValue val = symbolTable.get(varName);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public static void throwMacroExceptionReferenceNotFound(MXNode mxn, String varName) {
        String msg = "ReferenceError: '" + varName + "' is not defined";
        MacroException me = new MacroException(msg);
        StackTraceElement ste = new StackTraceElement(mxn.getNodeTypeName(), mxn.getTraceName(), "file", mxn.getBeginLine());
        me.addMacroStackTraceElement(ste);
        throw me;
    }

    public IPlanningEnvironment getPlanningEnvironment() {
        return this.env;
    }

    private class VariableSymbolTable {
        private HashMap<String, IValue> symbols = new HashMap();

        private VariableSymbolTable() {
        }

        public IValue get(String varName) {
            return this.symbols.get(varName);
        }

        public IValue put(String varName, IValue val) {
            return this.symbols.put(varName, val);
        }

        public boolean containsKey(String varName) {
            return this.symbols.containsKey(varName);
        }
    }
}

