/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MFAbstractFunction;
import com.cognos.xqe.ast.macro.MFAddDays;
import com.cognos.xqe.ast.macro.MFAddHours;
import com.cognos.xqe.ast.macro.MFAddMinutes;
import com.cognos.xqe.ast.macro.MFAddMonths;
import com.cognos.xqe.ast.macro.MFAddSeconds;
import com.cognos.xqe.ast.macro.MFAddYears;
import com.cognos.xqe.ast.macro.MFArray;
import com.cognos.xqe.ast.macro.MFCAMIDList;
import com.cognos.xqe.ast.macro.MFCAMIDListForType;
import com.cognos.xqe.ast.macro.MFCAMPassport;
import com.cognos.xqe.ast.macro.MFCSVIdentityName;
import com.cognos.xqe.ast.macro.MFCSVIdentityNameList;
import com.cognos.xqe.ast.macro.MFCommaSeparatedValues;
import com.cognos.xqe.ast.macro.MFDoubleQuote;
import com.cognos.xqe.ast.macro.MFFirstOfMonth;
import com.cognos.xqe.ast.macro.MFGetConfigurationEntry;
import com.cognos.xqe.ast.macro.MFGetResourceString;
import com.cognos.xqe.ast.macro.MFGrep;
import com.cognos.xqe.ast.macro.MFIndex;
import com.cognos.xqe.ast.macro.MFJoin;
import com.cognos.xqe.ast.macro.MFLStrip;
import com.cognos.xqe.ast.macro.MFLastOfMonth;
import com.cognos.xqe.ast.macro.MFLength;
import com.cognos.xqe.ast.macro.MFModelj;
import com.cognos.xqe.ast.macro.MFParamValue;
import com.cognos.xqe.ast.macro.MFPrompt;
import com.cognos.xqe.ast.macro.MFPromptMany;
import com.cognos.xqe.ast.macro.MFQueryValue;
import com.cognos.xqe.ast.macro.MFRStrip;
import com.cognos.xqe.ast.macro.MFRindex;
import com.cognos.xqe.ast.macro.MFSingleQuote;
import com.cognos.xqe.ast.macro.MFSort;
import com.cognos.xqe.ast.macro.MFSplit;
import com.cognos.xqe.ast.macro.MFSquareBracket;
import com.cognos.xqe.ast.macro.MFStrip;
import com.cognos.xqe.ast.macro.MFSubstitute;
import com.cognos.xqe.ast.macro.MFSubstr;
import com.cognos.xqe.ast.macro.MFTimestampMask;
import com.cognos.xqe.ast.macro.MFToLocal;
import com.cognos.xqe.ast.macro.MFToLower;
import com.cognos.xqe.ast.macro.MFToUTC;
import com.cognos.xqe.ast.macro.MFToUpper;
import com.cognos.xqe.ast.macro.MFUnique;
import com.cognos.xqe.ast.macro.MFUrlEncode;
import com.cognos.xqe.ast.macro.MXEvaluatorVisitor;
import com.cognos.xqe.ast.macro.MXNode;
import com.cognos.xqe.ast.macro.MacroContext;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.ast.macro.parser.JavaCharStream;
import com.cognos.xqe.ast.macro.parser.MacroParser;
import com.cognos.xqe.ast.macro.parser.MacroParserPool;
import com.cognos.xqe.ast.macro.parser.MacroParserTokenManager;
import com.cognos.xqe.ast.macro.parser.ParseException;
import com.cognos.xqe.ast.macro.parser.SimpleNode;
import com.cognos.xqe.ast.macro.parser.Token;
import com.cognos.xqe.ast.macro.parser.TokenMgrError;
import com.cognos.xqe.ast.util.BoundedStringReader;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5FilterExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class MacroExpander {
    public static final char POUND_CHAR = '#';
    public static final String PARSING_ERROR_MSG = "MacroException - a parsing error was encountered in the macro.";
    public static final String MX_MACRO_IMPORT = "macroImport";
    public static final String MX_MACRO_RESULT = "macroResult";
    private static Boolean xqeTracingEnabledForMX = null;
    private static final String OWNER = "owner";
    private static final String MACRO = "macro";
    private HashMap<String, MFAbstractFunction> functions;
    private List<Parameter> localParameters;
    private String executionTrace;
    private MXNode mxTree = null;

    public MacroExpander() {
        this.registerFunctions();
        MacroExpander.getXQETracingEnabledForMX();
    }

    public static boolean getXQETracingEnabledForMX() {
        if (xqeTracingEnabledForMX == null) {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            xqeTracingEnabledForMX = configuration.getBooleanProperty("queryPlanning.includeMacroExpansionInXqeLogs.[@enabled]", false);
        }
        return xqeTracingEnabledForMX;
    }

    public String expand(Object owner, IPlanningEnvironment planEnv, String str) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        ParameterAccessCoordinator pac = reqEnv.getParameterAccessCoordinator((PlanningEnvironment)planEnv);
        return this.expand(owner, planEnv, pac, str, 5);
    }

    public String expandAgain(Object owner, IPlanningEnvironment planEnv) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        ParameterAccessCoordinator pac = reqEnv.getParameterAccessCoordinator((PlanningEnvironment)planEnv);
        return this.expand(owner, planEnv, pac, null, 5);
    }

    public String expandSQL(IXQEQueryNode owner, IPlanningEnvironment planEnv, String str) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        ParameterAccessCoordinator pac = reqEnv.getParameterAccessCoordinator((PlanningEnvironment)planEnv);
        return this.expand(owner, planEnv, pac, str, 4);
    }

    public String expand(Object owner, IPlanningEnvironment planEnv, ParameterAccessCoordinator pac, String str, int state) {
        V5QuerySet querySet;
        Object execEnv = planEnv.getRequestEnvironment().getExecutionEnvironment();
        XDataContext dataContext = execEnv.pushDataContext();
        ExecutionEnvironment executionEnv = (ExecutionEnvironment)execEnv;
        if (executionEnv.getMetadataConnection() == null) {
            executionEnv.setMetdataConnection((IMetadataConnection)planEnv.getMetadataConnection());
        }
        if (!planEnv.getRequestEnvironment().isGetParametersRequest() && planEnv.getRoot() != null && planEnv.getRoot().getType() == 101002 && (querySet = (V5QuerySet)planEnv.getRoot()) != null) {
            String queryName = querySet.getQueryNameReferencedFromRetrieveDataset();
            dataContext.setQueryName(queryName);
        }
        MacroContext macroContext = new MacroContext(pac, this, owner, planEnv);
        dataContext.setMacroContext(macroContext);
        macroContext.traceStart();
        if (this.localParameters != null) {
            for (Parameter object : this.localParameters) {
                dataContext.setLocalParameter(object.getName(), object);
            }
        }
        try {
            if (str == null) {
                IValue evaluated = this.mxTree.execute(dataContext);
                if (evaluated instanceof StringValue) {
                    str = ((StringValue)evaluated).getString();
                }
            } else {
                str = this.expand(planEnv, owner, dataContext, str, state);
            }
        }
        catch (MacroException m) {
            Throwable throwable = m.getCause();
            String fullMessage = m.getMessage();
            String eol = "\n";
            if (throwable instanceof ParseException) {
                ParseException pe = (ParseException)throwable;
                fullMessage = fullMessage + "\n" + this.getParseMessageAndMarkedLocation(str, pe);
            }
            fullMessage = fullMessage + this.getMacroStackTrace(m);
            fullMessage = fullMessage + "\nText to expand:\n" + str;
            throw new MacroException(fullMessage, null);
        }
        catch (XQERuntimeException e) {
            if ("validateAll".equals(planEnv.getRequestEnvironment().getOperationName()) && owner instanceof V5FilterExpression && (e.getMessageKey() == XQEMessageKeys.MSR_SplitRefNotFound || e.getMessageKey() == XQEMessageKeys.MSR_ParentSplitRefNotFound)) {
                for (IXQEQueryNode c : ((V5FilterExpression)owner).getChildren()) {
                    if (!(c instanceof MXNode)) continue;
                    ((V5FilterExpression)owner).detachChild(c);
                }
                String string = "1 = 1";
                return string;
            }
            throw e;
        }
        finally {
            dataContext.setMacroContext(null);
            execEnv.popDataContext(dataContext);
            macroContext.release();
        }
        this.setExecutionTrace(macroContext.traceEnd());
        return str;
    }

    protected void setExecutionTrace(String trace) {
        this.executionTrace = trace;
    }

    public String getExecutionTrace() {
        return this.executionTrace;
    }

    private String getParseMessageAndMarkedLocation(String strToExpand, ParseException pe) {
        Token currentToken = pe.currentToken;
        int[][] expectedTokenSequences = pe.expectedTokenSequences;
        String[] tokenImage = pe.tokenImage;
        String eol = "\n";
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        TreeSet<String> seenSequences = new TreeSet<String>();
        for (int i = 0; i < expectedTokenSequences.length; ++i) {
            String seqText;
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            StringBuffer seq = new StringBuffer();
            for (int j = 0; j < expectedTokenSequences[i].length; ++j) {
                seq.append(tokenImage[expectedTokenSequences[i][j]]).append(' ');
            }
            if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                seq.append("...");
            }
            if (seenSequences.contains(seqText = seq.toString())) continue;
            seenSequences.add(seqText);
            if (expected.length() > 0) {
                expected.append(eol);
            }
            expected.append("    ");
            expected.append(seqText);
        }
        String retval = "Encountered:";
        Token tok = currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + tokenImage[0];
                break;
            }
            retval = retval + " " + tokenImage[tok.kind];
            if (!tokenImage[tok.kind].startsWith("\"")) {
                retval = retval + " \"";
                retval = retval + tok.image;
                retval = retval + "\"";
            }
            tok = tok.next;
        }
        retval = retval + " at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn;
        retval = retval + "." + eol;
        retval = expectedTokenSequences.length == 1 ? retval + "Was expecting:" + eol : retval + "Was expecting one of:" + eol;
        retval = retval + expected.toString();
        return retval;
    }

    private String getMacroStackTrace(MacroException me) {
        StringBuilder ret = new StringBuilder();
        StackTraceElement[] mstack = me.getMacroStackTrace();
        for (int k = 0; k < mstack.length; ++k) {
            StackTraceElement se = mstack[k];
            ret.append("\n    at ").append(se.getClassName()).append(" ").append(se.getMethodName()).append(":").append(se.getLineNumber());
        }
        return ret.toString();
    }

    public String expand(IPlanningEnvironment planEnv, Object owner, XDataContext dataContext, String strToExpand, int state) {
        String str = this.expandExpression(planEnv, owner, dataContext, strToExpand, state);
        if (!strToExpand.equals(str)) {
            planEnv.getExecutionEnvironment().getRequestEnvironment().getResolvedMacros().put(MacroExpander.makeKey(owner, strToExpand), str);
        }
        return str;
    }

    private static String makeKey(Object owner, String macroToExpand) {
        JSONObject jKey = new JSONObject();
        if (owner != null) {
            IMetadata metadata = null;
            if (owner instanceof IMetadata) {
                metadata = (IMetadata)owner;
            } else if (owner instanceof V5BoundMultiPartIdentifier) {
                metadata = ((V5BoundMultiPartIdentifier)owner).getMetadata();
            }
            if (!(metadata == null || metadata instanceof IQuerySubject || metadata instanceof IQueryItem || metadata instanceof IFilter || metadata instanceof ICalculation)) {
                metadata = null;
            }
            if (metadata != null) {
                jKey.put((Object)OWNER, (Object)metadata.getID());
            }
        }
        jKey.put((Object)MACRO, (Object)macroToExpand);
        return jKey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String expandExpression(IPlanningEnvironment planEnv, Object owner, XDataContext dataContext, String strToExpand, int state) {
        IXQEQueryNode qn;
        IValue evaluated;
        if (MacroExpander.getXQETracingEnabledForMX() && owner != null && owner instanceof IXQEQueryNode) {
            IXQEQueryNode qn2 = (IXQEQueryNode)owner;
            qn2.setPropertyValue(MX_MACRO_IMPORT, strToExpand);
        }
        String str = strToExpand;
        SimpleNode n = null;
        MacroParser np = null;
        try {
            np = MacroParserPool.getInstance().borrowParser();
            try {
                BoundedStringReader reader = new BoundedStringReader(str);
                TabJavaCharStream jcstream = new TabJavaCharStream(reader);
                jcstream.setTabStop(4);
                MacroParserTokenManager tknSource = new MacroParserTokenManager(jcstream);
                np.ReInit(tknSource);
                np.token_source.SwitchTo(state);
                np.saveLexerState();
                n = np.Start();
            }
            finally {
                MacroParserPool.getInstance().returnParser(np);
            }
        }
        catch (TokenMgrError | Exception e) {
            IXQEQueryNode dataItem;
            if ("validateAll".equals(planEnv.getRequestEnvironment().getOperationName()) && owner instanceof IXQEQueryNode && (dataItem = ((IXQEQueryNode)owner).getAncestorOfType(101003)) != null) {
                String moduleLocation = (String)dataItem.getPropertyValue("moduleLocation");
                while (moduleLocation == null && (dataItem = dataItem.getAncestorOfType(101003)) != null) {
                    moduleLocation = (String)dataItem.getPropertyValue("moduleLocation");
                }
                if (moduleLocation != null) {
                    String diName = (String)dataItem.getPropertyValue("name");
                    IMessageKey.Param2 msgParam = XQEMessageKeys.MSR_ExpressionParsingError;
                    ResponseMessage msg = new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, msgParam, str, diName);
                    planEnv.getRequestEnvironment().getResponseMessageFolder().appendPlanningResponseMessage(msg, dataItem, planEnv.getRoot());
                    return str;
                }
            }
            if (e instanceof TokenMgrError) {
                throw (TokenMgrError)e;
            }
            throw new MacroException(PARSING_ERROR_MSG, e);
        }
        XQETrace trace = planEnv.getTrace();
        boolean nodeChangeTracingEnabled = trace.isEnable(256);
        if (!MacroExpander.getXQETracingEnabledForMX() && nodeChangeTracingEnabled) {
            trace.removeTraceLevel(256);
        }
        MXEvaluatorVisitor evalVisitor = new MXEvaluatorVisitor(planEnv.getNodeFactory(), this);
        IXQEQueryNode exp = (IXQEQueryNode)n.jjtAccept(evalVisitor, owner);
        if (this.mxTree == null) {
            this.mxTree = (MXNode)exp;
        }
        if ((evaluated = ((MXNode)exp).execute(dataContext)) instanceof StringValue) {
            str = ((StringValue)evaluated).getString();
        }
        if (owner instanceof IXQEQueryNode) {
            qn = (IXQEQueryNode)owner;
            qn.detachChild(exp);
        }
        if (!MacroExpander.getXQETracingEnabledForMX() && nodeChangeTracingEnabled) {
            trace.addTraceLevel(256);
        }
        if (MacroExpander.getXQETracingEnabledForMX() && owner != null && owner instanceof IXQEQueryNode) {
            qn = (IXQEQueryNode)owner;
            qn.setPropertyValue(MX_MACRO_RESULT, str);
        }
        return str;
    }

    MFAbstractFunction getFunction(String fname) {
        return this.functions.get(fname.toLowerCase());
    }

    private void registerFunction(MFAbstractFunction func) {
        if (this.functions == null) {
            this.functions = new HashMap();
        }
        this.functions.put(func.getFunctionName().toLowerCase(), func);
    }

    private void registerFunctions() {
        this.registerFunction(new MFSingleQuote());
        this.registerFunction(new MFDoubleQuote());
        this.registerFunction(new MFArray());
        this.registerFunction(new MFJoin());
        this.registerFunction(new MFSquareBracket());
        this.registerFunction(new MFCommaSeparatedValues());
        this.registerFunction(new MFSort());
        this.registerFunction(new MFUnique());
        this.registerFunction(new MFSplit());
        this.registerFunction(new MFGrep());
        this.registerFunction(new MFSubstitute());
        this.registerFunction(new MFUrlEncode());
        this.registerFunction(new MFAddSeconds());
        this.registerFunction(new MFAddMinutes());
        this.registerFunction(new MFAddHours());
        this.registerFunction(new MFAddDays());
        this.registerFunction(new MFAddMonths());
        this.registerFunction(new MFAddYears());
        this.registerFunction(new MFFirstOfMonth());
        this.registerFunction(new MFLastOfMonth());
        this.registerFunction(new MFToUTC());
        this.registerFunction(new MFTimestampMask());
        this.registerFunction(new MFToLocal());
        this.registerFunction(new MFPrompt());
        this.registerFunction(new MFPromptMany());
        this.registerFunction(new MFCAMIDList());
        this.registerFunction(new MFCSVIdentityName());
        this.registerFunction(new MFCSVIdentityNameList());
        this.registerFunction(new MFCAMPassport());
        this.registerFunction(new MFCAMIDListForType());
        this.registerFunction(new MFGetConfigurationEntry());
        this.registerFunction(new MFToUpper());
        this.registerFunction(new MFToLower());
        this.registerFunction(new MFStrip());
        this.registerFunction(new MFLStrip());
        this.registerFunction(new MFRStrip());
        this.registerFunction(new MFQueryValue());
        this.registerFunction(new MFParamValue());
        this.registerFunction(new MFSubstr());
        this.registerFunction(new MFIndex());
        this.registerFunction(new MFRindex());
        this.registerFunction(new MFLength());
        this.registerFunction(new MFGetResourceString());
        this.registerFunction(new MFModelj());
    }

    public static final boolean isMacro(String str) {
        String strCpy;
        return str != null && (strCpy = str.trim()).length() > 0 && strCpy.charAt(0) == '#' && strCpy.charAt(strCpy.length() - 1) == '#';
    }

    public static final boolean containsPound(String str) {
        return str.indexOf(35) != -1;
    }

    public static boolean macrosResolveToSameValues(TreeMap<String, String> macroMap, IPlanningEnvironment planEnv) {
        if (planEnv == null || macroMap == null || macroMap.size() == 0) {
            return true;
        }
        MacroExpander macroExpander = new MacroExpander();
        for (Map.Entry<String, String> entry : macroMap.entrySet()) {
            JSONObject jKey;
            String jsonKeyStr = entry.getKey();
            try {
                jKey = JSONObject.parse((String)jsonKeyStr);
            }
            catch (IOException e) {
                continue;
            }
            String strToExpand = (String)jKey.get((Object)MACRO);
            Object owner = MacroExpander.getOwner(planEnv.getMetadataConnection(), (String)jKey.get((Object)OWNER));
            String storedValue = entry.getValue();
            String expandedString = macroExpander.expand(owner, planEnv, strToExpand);
            if (expandedString.equals(storedValue)) continue;
            return false;
        }
        return true;
    }

    private static Object getOwner(IMetadataConnection metadataConnection, String ownerID) {
        if (metadataConnection == null || ownerID == null) {
            return null;
        }
        return metadataConnection.bindMetadataReference(ownerID);
    }

    public void setLocalParameters(List<Parameter> p) {
        this.localParameters = new ArrayList<Parameter>();
        this.localParameters.addAll(p);
    }

    public static boolean matchesWithResolvedMacro(TreeMap<String, String> resolvedMacros, Object owner, String macroToResolve, String valueToMatch) {
        String macroResult = resolvedMacros.get(MacroExpander.makeKey(owner, macroToResolve));
        if (macroResult != null) {
            return macroResult.equals(valueToMatch);
        }
        return false;
    }

    public void reset() {
        this.mxTree = null;
    }

    private class TabJavaCharStream
    extends JavaCharStream {
        public TabJavaCharStream(Reader dstream) {
            super(dstream);
        }

        public void setTabStop(int v) {
            this.setTabSize(v);
        }
    }
}

