/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserFilter;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserQueryItem;
import java.util.Map;

public class MacroMetadataContextAccessor {
    public static final String STR_PARENT = "parent.";
    public static final String STR_ID_FOR_EXPR = "idForExpression";
    public static final String STR_SPLIT_REF = "split.ref";
    public static final String STR_THIS = "_this.";
    public static final String STR_CTX_MAP = "contextMap";

    public static String evaluate(Object obj, String property) {
        String valueStr = null;
        if (obj != null && property.startsWith(STR_THIS)) {
            valueStr = "item".equals(property = property.substring(STR_THIS.length())) ? MacroMetadataContextAccessor.getContextItem(obj) : ("query".equals(property) ? MacroMetadataContextAccessor.getContextQuery(obj) : ("model".equals(property) ? MacroMetadataContextAccessor.getContextModel(obj) : MacroMetadataContextAccessor.getContextValue(obj, property)));
        }
        return valueStr;
    }

    public static String getContextItem(Object owner) {
        IXQEQueryNode qn;
        IXQEQueryNode p;
        int[] cats = new int[]{101022, 101003, 201116};
        if (owner instanceof IXQEQueryNode && (p = (qn = (IXQEQueryNode)owner).getAncestorOfCategories(cats)) != null) {
            return (String)p.getPropertyValue("name");
        }
        return null;
    }

    public static String getContextValue(Object owner, String propName) {
        IMetadata parent;
        String v;
        Map mp;
        String res = null;
        if (owner instanceof XQEQueryNode && (mp = (Map)((XQEQueryNode)owner).getPropertyValue(STR_CTX_MAP)) != null && (v = (String)mp.get(propName)) != null) {
            return v;
        }
        if (owner instanceof V5BoundModelIdentifier) {
            V5BoundModelIdentifier v5bmi = (V5BoundModelIdentifier)owner;
            IMetadata meta = v5bmi.getMetadata();
            if (meta instanceof IQueryItem) {
                owner = meta;
            } else {
                res = v5bmi.getIdentifier();
                return res;
            }
        }
        if (owner instanceof IXQEQueryNode) {
            IMetadata meta;
            IXQEQueryNode qn = (IXQEQueryNode)owner;
            int[] cats = new int[]{101022, 101003, 201116, 101008};
            IXQEQueryNode p = qn.getAncestorOfTypes(cats);
            if (p instanceof V5DataItem) {
                V5DataItem di = (V5DataItem)p;
                if (STR_ID_FOR_EXPR.equals(propName)) {
                    res = di.getFullName();
                } else if (propName.startsWith(STR_PARENT)) {
                    V5Selection sel = (V5Selection)di.getParent();
                    V5Query query = (V5Query)sel.getParent();
                    if (STR_ID_FOR_EXPR.equals(propName = propName.substring(STR_PARENT.length()))) {
                        res = UniqueNameGenerator.createSingleNamePart(query.getV5QueryName());
                    }
                }
            } else if (p instanceof V5DetailFilter && (meta = (IMetadata)p.getPropertyValue("contextMetadata")) instanceof MoserFilter) {
                return MacroMetadataContextAccessor.getContextValue(meta, propName);
            }
        } else if (owner instanceof MoserCalculation) {
            MoserCalculation mCalc = (MoserCalculation)owner;
            if (propName.startsWith(STR_PARENT)) {
                parent = mCalc.getParentObject();
                String key = propName.substring(STR_PARENT.length());
                if (parent instanceof MoserQueryItem || parent instanceof MoserCalculation) {
                    res = MacroMetadataContextAccessor.getContextValue(parent, key);
                    return res;
                }
            }
            if (STR_ID_FOR_EXPR.equals(propName)) {
                res = MoserModuleUtil.getNormalizedUniqueId(mCalc.getUniqueID());
            }
        } else if (owner instanceof MoserFilter) {
            MoserFilter mFlt = (MoserFilter)owner;
            if (propName.startsWith(STR_PARENT)) {
                parent = mFlt.getParentObject();
                String key = propName.substring(STR_PARENT.length());
                if (parent instanceof MoserQueryItem) {
                    res = MacroMetadataContextAccessor.getContextValue(parent, key);
                    return res;
                }
            }
            if (STR_ID_FOR_EXPR.equals(propName)) {
                res = mFlt.getUniqueID();
            }
        } else if (owner instanceof MoserQueryItem) {
            MoserQueryItem mqi = (MoserQueryItem)owner;
            if (propName.startsWith(STR_PARENT)) {
                parent = mqi.getParentObject();
                String key = propName.substring(STR_PARENT.length());
                if (parent instanceof MoserQueryItem) {
                    res = MacroMetadataContextAccessor.getContextValue(parent, key);
                    return res;
                }
            }
            if (STR_ID_FOR_EXPR.equals(propName)) {
                res = mqi.getIdForExpressionAlt();
                res = UniqueNameGenerator.createEscapedUniqueNameFromDottedId(res);
            } else if (STR_SPLIT_REF.equals(propName)) {
                res = mqi.getSplitRef();
            }
        } else if (owner instanceof IQueryItem) {
            IQueryItem qi = (IQueryItem)owner;
            if (STR_ID_FOR_EXPR.equals(propName)) {
                res = qi.getV5UniqueName();
            }
        }
        MacroMetadataContextAccessor.throwIfNotFound(owner, res, propName);
        return res;
    }

    protected static void throwIfNotFound(Object owner, String res, String propName) {
        if (res == null && propName.endsWith(STR_SPLIT_REF)) {
            if (owner instanceof IMetadata && propName.equals("parent.split.ref")) {
                throw new XQERuntimeException(XQEMessageKeys.MSR_ParentSplitRefNotFound, ((IMetadata)owner).getName());
            }
            throw new XQERuntimeException(XQEMessageKeys.MSR_SplitRefNotFound);
        }
    }

    public static String getContextQuery(Object owner) {
        return "query";
    }

    public static String getContextModel(Object owner) {
        return "model";
    }
}

