/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.macro;

import com.cognos.xqe.ast.macro.DataTypeEnum;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqemoser.MoserParameterUtil;
import java.util.HashMap;
import java.util.Map;

public class MacroPromptUtils {
    static final String DIGITS = "0123456789";
    static final String COMMA = ",";
    static final String PERIOD = ".";
    static final String WHITESPACES = " \n\t";
    static final String MINUS = "-";
    static final String PLUS = "+";
    static final String COLON = ":";
    static final String SIGNS = "+-";
    static final String SPACE = " ";
    static final String QUESTION_MARK = "?";
    static final String DAYTOHOUR = "DAY TO HOUR";
    static final String DAYTOMINUTE = "DAY TO MINUTE";
    static final String DAYTOSECOND = "DAY TO SECOND";
    static final String HOURTOMINUTE = "HOUR TO MINUTE";
    static final String HOURTOSECOND = "HOUR TO SECOND";
    static final String MINUTETOSECOND = "MINUTE TO SECOND";
    static final String YEARTOMONTH = "YEAR TO MONTH";
    static final String YEAR = "YEAR";
    static final String MONTH = "MONTH";
    static final String DAY = "DAY";
    static final String HOUR = "HOUR";
    static final String MINUTE = "MINUTE";
    static final String SECOND = "SECOND";
    static final char DATE_SEPARATOR = '-';
    static final char TIME_SEPARATOR = ':';
    static final char MILLISECOND_SEPARATOR = '.';
    static final int DATE_MIN_SIZE = 10;
    static final int TIME_MIN_SIZE = 8;
    static HashMap<String, DataTypeEnum> dataTypeEnumLookupByName = null;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    private static synchronized Map<String, DataTypeEnum> getDataTypeEnumLookup() {
        if (dataTypeEnumLookupByName == null) {
            dataTypeEnumLookupByName = new HashMap();
            dataTypeEnumLookupByName.put("xsdstring", DataTypeEnum.STRING);
            dataTypeEnumLookupByName.put("string", DataTypeEnum.STRING);
            dataTypeEnumLookupByName.put("xsddate", DataTypeEnum.DATE);
            dataTypeEnumLookupByName.put("date", DataTypeEnum.DATE);
            dataTypeEnumLookupByName.put("xsddatetime", DataTypeEnum.TIMESTAMP);
            dataTypeEnumLookupByName.put("datetime", DataTypeEnum.TIMESTAMP);
            dataTypeEnumLookupByName.put("date time", DataTypeEnum.TIMESTAMP);
            dataTypeEnumLookupByName.put("timestamp", DataTypeEnum.TIMESTAMP);
            dataTypeEnumLookupByName.put("xsdtime", DataTypeEnum.TIME);
            dataTypeEnumLookupByName.put("time", DataTypeEnum.TIME);
            dataTypeEnumLookupByName.put("xsdtimetz", DataTypeEnum.TIMETZ);
            dataTypeEnumLookupByName.put("timetz", DataTypeEnum.TIMETZ);
            dataTypeEnumLookupByName.put("time with time zone", DataTypeEnum.TIMETZ);
            dataTypeEnumLookupByName.put("xsdtimestamptz", DataTypeEnum.TIMESTAMPTZ);
            dataTypeEnumLookupByName.put("timestamptz", DataTypeEnum.TIMESTAMPTZ);
            dataTypeEnumLookupByName.put("timestamp with time zone", DataTypeEnum.TIMESTAMPTZ);
            dataTypeEnumLookupByName.put("xsdduration", DataTypeEnum.INTERVAL);
            dataTypeEnumLookupByName.put("timeinterval", DataTypeEnum.INTERVAL);
            dataTypeEnumLookupByName.put("interval", DataTypeEnum.INTERVAL);
            dataTypeEnumLookupByName.put("time interval", DataTypeEnum.INTERVAL);
            dataTypeEnumLookupByName.put("xsdintervalym", DataTypeEnum.INTERVALYM);
            dataTypeEnumLookupByName.put("intervalym", DataTypeEnum.INTERVALYM);
            dataTypeEnumLookupByName.put("year month interval", DataTypeEnum.INTERVALYM);
            dataTypeEnumLookupByName.put("xsdshort", DataTypeEnum.SMALLINT);
            dataTypeEnumLookupByName.put("short", DataTypeEnum.SMALLINT);
            dataTypeEnumLookupByName.put("smallint", DataTypeEnum.SMALLINT);
            dataTypeEnumLookupByName.put("xsdint", DataTypeEnum.INTEGER);
            dataTypeEnumLookupByName.put("int", DataTypeEnum.INTEGER);
            dataTypeEnumLookupByName.put("integer", DataTypeEnum.INTEGER);
            dataTypeEnumLookupByName.put("xsdlong", DataTypeEnum.LONG);
            dataTypeEnumLookupByName.put("long", DataTypeEnum.LONG);
            dataTypeEnumLookupByName.put("xsdfloat", DataTypeEnum.FLOAT);
            dataTypeEnumLookupByName.put("float", DataTypeEnum.FLOAT);
            dataTypeEnumLookupByName.put("xsddouble", DataTypeEnum.DOUBLE);
            dataTypeEnumLookupByName.put("double", DataTypeEnum.DOUBLE);
            dataTypeEnumLookupByName.put("real", DataTypeEnum.DOUBLE);
            dataTypeEnumLookupByName.put("numeric", DataTypeEnum.DOUBLE);
            dataTypeEnumLookupByName.put("xsddecimal", DataTypeEnum.DECIMAL);
            dataTypeEnumLookupByName.put("decimal", DataTypeEnum.DECIMAL);
            dataTypeEnumLookupByName.put("memberuniquename", DataTypeEnum.MEMBERUNIQUENAME);
            dataTypeEnumLookupByName.put("mun", DataTypeEnum.MEMBERUNIQUENAME);
        }
        return dataTypeEnumLookupByName;
    }

    public static String genNicePromptValue(String rawValue, IDataType dType) {
        DataTypeEnum dTypeEnum = MacroPromptUtils.getEnumValueFromDataTypeName(dType.getTypeName());
        String singleQuote = "'";
        switch (dTypeEnum) {
            case STRING: {
                return "'" + rawValue.replaceAll("'", "''") + "'";
            }
            case SMALLINT: 
            case INTEGER: 
            case LONG: {
                return rawValue;
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return rawValue.replaceAll(COMMA, PERIOD);
            }
            case DATE: {
                return "DATE '" + rawValue + "'";
            }
            case TIMESTAMP: 
            case TIMESTAMPTZ: {
                return "TIMESTAMP '" + rawValue + "'";
            }
            case TIME: 
            case TIMETZ: {
                return "TIME '" + rawValue + "'";
            }
            case INTERVAL: 
            case INTERVALYM: {
                String tmpStr = "INTERVAL '";
                int qualifierPos = MacroPromptUtils.findFirstNotOf(rawValue, "0123456789+-:. ");
                String qualifierStr = rawValue.substring(qualifierPos);
                String valueWithNoQualifier = rawValue.substring(0, qualifierPos);
                valueWithNoQualifier = valueWithNoQualifier.trim();
                tmpStr = tmpStr + valueWithNoQualifier;
                tmpStr = tmpStr.trim();
                qualifierStr = qualifierStr.trim();
                tmpStr = tmpStr + "' " + qualifierStr;
                return tmpStr;
            }
            case MEMBERUNIQUENAME: {
                break;
            }
            default: {
                return "'" + rawValue + "'";
            }
        }
        return rawValue;
    }

    public static String getDummyValue4DataType(IDataType dType, String promptName) {
        DataTypeEnum dTypeEnum = MacroPromptUtils.getEnumValueFromDataTypeName(dType.getTypeName());
        switch (dTypeEnum) {
            case STRING: {
                return "testValue";
            }
            case DATE: {
                return "2001-01-01";
            }
            case TIMESTAMP: {
                return "2000-01-01 00:00:00.000000000";
            }
            case TIME: {
                return "00:00:00.000000000";
            }
            case TIMESTAMPTZ: {
                return "00:00:00.000000000+00:00";
            }
            case INTERVAL: {
                return "000 00:00:00.000000000 DAY TO SECOND";
            }
            case INTERVALYM: {
                return "0000-00 YEAR TO MONTH";
            }
            case SMALLINT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return "0";
            }
            case MEMBERUNIQUENAME: {
                return QUESTION_MARK + promptName + QUESTION_MARK;
            }
        }
        return "";
    }

    public static DataTypeEnum getEnumValueFromDataTypeName(String dtName) {
        DataTypeEnum result = MacroPromptUtils.getDataTypeEnumLookup().get(dtName.toLowerCase());
        if (result == null) {
            result = DataTypeEnum.STRING;
        }
        return result;
    }

    public static IValue[] getParameterPromptValues(Parameter param, Parameters contextParams, boolean bNewParam, IPlanningEnvironment env) {
        IValue[] values;
        Parameter paramFromCxt = contextParams.getParameter(param.getName());
        if (paramFromCxt == null) {
            MacroPromptUtils.registerUnresolvedParameter(param, contextParams);
            return null;
        }
        MacroPromptUtils.setPromptDataType(param.getName(), param.getDataType(), contextParams);
        paramFromCxt = contextParams.getParameter(param.getName());
        if (!paramFromCxt.validateXmlValuesWithDataType()) {
            param.clearParameterValueItems();
            param.setErrorCode(UnresolvedParameterException.ParameterErrorCodeEnum.INVALID_FORMAT);
            MacroPromptUtils.registerUnresolvedParameter(param, contextParams);
            return null;
        }
        if (bNewParam && env != null) {
            MoserParameterUtil.cloneParameterValues(paramFromCxt, env, true);
        }
        if ((values = paramFromCxt.getParameterValues()).length == 0 && !param.getCapabilities().isOptional()) {
            MacroPromptUtils.registerUnresolvedParameter(param, contextParams);
            return null;
        }
        return values;
    }

    public static String convertValidXMLConstToUDAValue(String userValue, IDataType dType) {
        DataTypeEnum dTypeEnum = MacroPromptUtils.getEnumValueFromDataTypeName(dType.getTypeName());
        switch (dTypeEnum) {
            case SMALLINT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                if (!MacroPromptUtils.isValidConst(userValue, DoubleType.DOUBLETYPE)) {
                    return null;
                }
                return MacroPromptUtils.convXSD2UDAValue(userValue, dTypeEnum.getDataType());
            }
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMPTZ: 
            case TIME: 
            case TIMETZ: 
            case INTERVAL: 
            case INTERVALYM: {
                return MacroPromptUtils.convXSD2UDAValue(userValue, dTypeEnum.getDataType());
            }
            case MEMBERUNIQUENAME: {
                if (MacroPromptUtils.isValidMUNLiteral(userValue)) {
                    return userValue;
                }
                return null;
            }
        }
        return userValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setPromptDataType(String paramName, IDataType desiredDType, Parameters contextParams) {
        Parameter paramFromCxt = contextParams.getParameter(paramName);
        if (paramFromCxt != null) {
            IDataType dTypeUsed = paramFromCxt.getDataType();
            if (dTypeUsed != null) {
                IDataType compatibleDT = MacroPromptUtils.getCompatibleDataType(dTypeUsed, desiredDType);
                if (compatibleDT == null) throw new RuntimeException("Prompt with conflicting data types. ");
                paramFromCxt.setDataType(compatibleDT);
                return;
            } else {
                paramFromCxt.setDataType(desiredDType);
            }
            return;
        } else {
            Parameter newParam = new Parameter(paramName);
            newParam.setDataType(desiredDType);
            contextParams.addParameter(paramName, newParam);
        }
    }

    public static void registerUnresolvedParameter(Parameter param, Parameters contextParams) {
        Parameter paramFromCxt = contextParams.getParameter(param.getName());
        if (paramFromCxt == null) {
            if (!param.isResolved()) {
                contextParams.addParameter(param.getName(), param);
            }
            return;
        }
        if (paramFromCxt.isResolved()) {
            return;
        }
        IDataType compatibleDT = MacroPromptUtils.getCompatibleDataType(paramFromCxt.getDataType(), param.getDataType());
        if (compatibleDT == null) {
            throw new RuntimeException("Prompt with conflicting data types");
        }
        paramFromCxt.setDataType(compatibleDT);
        if (paramFromCxt.getModelItem().length() == 0) {
            paramFromCxt.setModelItem(param.getModelItem());
        }
        if (paramFromCxt.getCapabilities().isOptional()) {
            paramFromCxt.getCapabilities().setOptional(param.getCapabilities().isOptional());
        }
    }

    public static IDataType getCompatibleDataType(IDataType existingDT, IDataType newDT) {
        if (existingDT.equals(newDT)) {
            return existingDT;
        }
        DataTypeEnum existingEnumDT = MacroPromptUtils.getEnumValueFromDataTypeName(existingDT.getTypeName());
        DataTypeEnum newEnumDT = MacroPromptUtils.getEnumValueFromDataTypeName(newDT.getTypeName());
        switch (existingEnumDT) {
            case STRING: {
                return newDT;
            }
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMPTZ: 
            case TIME: 
            case TIMETZ: 
            case INTERVAL: 
            case INTERVALYM: {
                switch (newEnumDT) {
                    case STRING: {
                        return existingDT;
                    }
                }
                if (existingEnumDT != newEnumDT) {
                    return null;
                }
            }
            case SMALLINT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                switch (newEnumDT) {
                    case STRING: {
                        return existingDT;
                    }
                    case SMALLINT: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DECIMAL: {
                        if (existingEnumDT.compareTo(newEnumDT) > 0) {
                            return newDT;
                        }
                        return existingDT;
                    }
                }
                return null;
            }
        }
        return existingDT;
    }

    public static int findFirstOf(String input, String chars, int startPos) {
        for (int i = startPos; i < input.length(); ++i) {
            if (chars.indexOf(input.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstOf(String input, String chars) {
        return MacroPromptUtils.findFirstOf(input, chars, 0);
    }

    public static int findFirstNotOf(String input, String chars) {
        return MacroPromptUtils.findFirstNotOf(input, chars, 0);
    }

    public static int findFirstNotOf(String input, String chars, int startPos) {
        for (int i = startPos; i < input.length(); ++i) {
            if (chars.indexOf(input.charAt(i)) != -1) continue;
            return i;
        }
        return -1;
    }

    public static int findLastOf(String input, String chars) {
        int startPos;
        for (int i = startPos = input.length() - 1; i >= 0; --i) {
            if (chars.indexOf(input.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean checkSignedFloat(String userValue) {
        String text = userValue.replaceAll(COMMA, PERIOD);
        int end = MacroPromptUtils.findFloat(text);
        if (end == -1) {
            return false;
        }
        if (end == 0) {
            return true;
        }
        if (end == text.length() - 1) {
            return false;
        }
        String s = text.substring(end + 1);
        return MacroPromptUtils.checkInt(s);
    }

    public static boolean checkInt(String userValue) {
        int end = MacroPromptUtils.findSignedInt(userValue);
        if (end == -1) {
            return false;
        }
        if (end == 0) {
            return true;
        }
        return MacroPromptUtils.findFirstNotOf(userValue, WHITESPACES, end) == -1;
    }

    public static int findFloat(String userValue) {
        int returnValue;
        String floatPart;
        int newstart = MacroPromptUtils.findFirstOf(userValue, "dDeE");
        if (newstart >= 0) {
            floatPart = userValue.substring(0, newstart);
            returnValue = newstart;
        } else {
            floatPart = userValue;
            returnValue = 0;
        }
        int end = MacroPromptUtils.findFirstOf(floatPart, PERIOD);
        if (end == -1) {
            if (MacroPromptUtils.checkInt(floatPart)) {
                return returnValue;
            }
            return -1;
        }
        if (end == floatPart.length() - 1) {
            return -1;
        }
        String firstIntPart = floatPart.substring(0, end);
        String secondIntPart = floatPart.substring(++end);
        end = MacroPromptUtils.checkAndFindSign(firstIntPart);
        if (end == -1) {
            return -1;
        }
        firstIntPart = firstIntPart.substring(end);
        firstIntPart = firstIntPart.trim();
        secondIntPart = secondIntPart.trim();
        if (firstIntPart.length() > 0 && MacroPromptUtils.findFirstNotOf(firstIntPart, DIGITS) != -1) {
            return -1;
        }
        if (MacroPromptUtils.findFirstNotOf(secondIntPart, DIGITS) != -1) {
            return -1;
        }
        return returnValue;
    }

    public static int findSignedInt(String userValue) {
        String s;
        if (userValue.length() == 0) {
            return -1;
        }
        int start = MacroPromptUtils.checkAndFindSign(userValue);
        if (start == -1) {
            return -1;
        }
        int end = MacroPromptUtils.findFirstOf(userValue, DIGITS);
        if (end == -1) {
            return -1;
        }
        if (end != start && MacroPromptUtils.findFirstNotOf(s = userValue.substring(start, end), WHITESPACES) >= 0) {
            return -1;
        }
        start = end;
        if ((end = MacroPromptUtils.findFirstOf(userValue, WHITESPACES, start)) >= 0) {
            s = userValue.substring(start, end);
        } else {
            s = userValue.substring(start);
            end = 0;
        }
        if (s.length() == 0) {
            return -1;
        }
        if (MacroPromptUtils.findFirstNotOf(s, DIGITS) >= 0) {
            return -1;
        }
        return end;
    }

    public static int checkAndFindSign(String userValue) {
        int start = MacroPromptUtils.findFirstOf(userValue, SIGNS);
        if (start >= 0) {
            String s = userValue.substring(0, start);
            if (MacroPromptUtils.findFirstNotOf(s, WHITESPACES) >= 0) {
                return -1;
            }
            if (start < userValue.length() - 1) {
                return start + 1;
            }
            return -1;
        }
        return 0;
    }

    public static boolean isValidConst(String userValue, IDataType dType) {
        DataTypeEnum dTypeEnum = MacroPromptUtils.getEnumValueFromDataTypeName(dType.getTypeName());
        switch (dTypeEnum) {
            case SMALLINT: 
            case INTEGER: 
            case LONG: {
                return MacroPromptUtils.findSignedInt(userValue) >= 0;
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return MacroPromptUtils.checkSignedFloat(userValue);
            }
            case DATE: {
                String s;
                int start = MacroPromptUtils.findUDADate(userValue);
                if (start == -1) {
                    return false;
                }
                if (start <= 0 || (start = MacroPromptUtils.findFirstNotOf(s = userValue.substring(start), WHITESPACES)) < 0) break;
                return false;
            }
            case TIME: {
                int start = MacroPromptUtils.findUDATime(userValue);
                if (start != -1) break;
                return false;
            }
            case TIMETZ: {
                int start = MacroPromptUtils.findUDATime(userValue);
                if (start == -1 || start == 0) {
                    return false;
                }
                String tz = userValue.substring(start);
                if (MacroPromptUtils.findUDATZ(tz)) break;
                return false;
            }
            case TIMESTAMP: {
                int start = MacroPromptUtils.findUDADate(userValue);
                if (start == -1 || start == 0) {
                    return false;
                }
                String sz = userValue.substring(start);
                if ((start = MacroPromptUtils.findUDATime(sz)) != -1) break;
                return false;
            }
            case TIMESTAMPTZ: {
                int start = MacroPromptUtils.findUDADate(userValue);
                if (start == -1 || start == 0) {
                    return false;
                }
                String timeStr = userValue.substring(start);
                if ((start = MacroPromptUtils.findUDATime(timeStr)) == -1 || start == 0) {
                    return false;
                }
                String tzStr = timeStr.substring(start);
                if (MacroPromptUtils.findUDATZ(tzStr)) break;
                return false;
            }
            case INTERVAL: {
                if (MacroPromptUtils.findUDATimeInterval(userValue)) break;
                return false;
            }
            case INTERVALYM: {
                if (MacroPromptUtils.findUDAIntervalYM(userValue)) break;
                return false;
            }
        }
        return true;
    }

    public static boolean findUDAIntervalYM(String userValue) {
        String str = userValue.trim().toUpperCase();
        if (str.indexOf(YEARTOMONTH) != -1) {
            return MacroPromptUtils.findYearToMonthInterval(str);
        }
        if (str.indexOf(YEAR) != -1) {
            return MacroPromptUtils.findYearInterval(str);
        }
        if (str.indexOf(MONTH) != -1) {
            return MacroPromptUtils.findMonthInterval(str);
        }
        return false;
    }

    public static boolean findMonthInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = str.indexOf(MONTH);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        return MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findYearInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = str.indexOf(YEAR);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        return MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findYearToMonthInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = MacroPromptUtils.findFirstOf(str, MINUS);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        if (MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        end = str.indexOf(YEARTOMONTH);
        sz = str.substring(start, end);
        return (sz = sz.trim()).length() <= 2 && MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findUDATimeInterval(String userValue) {
        String str = userValue.trim().toUpperCase();
        if (str.indexOf(DAYTOHOUR) >= 0) {
            return MacroPromptUtils.findDayToHourInterval(str);
        }
        if (str.indexOf(DAYTOMINUTE) >= 0) {
            return MacroPromptUtils.findDayToMinuteInterval(str);
        }
        if (str.indexOf(DAYTOSECOND) >= 0) {
            return MacroPromptUtils.findDayToSecondInterval(str);
        }
        if (str.indexOf(HOURTOMINUTE) >= 0) {
            return MacroPromptUtils.findHourToMinuteInterval(str);
        }
        if (str.indexOf(HOURTOSECOND) >= 0) {
            return MacroPromptUtils.findHourToSecondInterval(str);
        }
        if (str.indexOf(MINUTETOSECOND) >= 0) {
            return MacroPromptUtils.findMinuteToSecondInterval(str);
        }
        if (str.indexOf(DAY) >= 0) {
            return MacroPromptUtils.findDayInterval(str);
        }
        if (str.indexOf(HOUR) >= 0) {
            return MacroPromptUtils.findHourInterval(str);
        }
        if (str.indexOf(MINUTE) >= 0) {
            return MacroPromptUtils.findMinuteInterval(str);
        }
        if (str.indexOf(SECOND) >= 0) {
            return MacroPromptUtils.findSecondInterval(str);
        }
        return false;
    }

    public static boolean findSecondInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = MacroPromptUtils.findFirstOf(str, PERIOD);
        if (end != -1) {
            String sz = str.substring(start, end);
            if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
                return false;
            }
            start = end + 1;
            end = str.indexOf(SECOND);
            sz = str.substring(start, end);
            if (!MacroPromptUtils.isDecimalDigits(sz = sz.trim(), false)) {
                return false;
            }
        } else {
            end = str.indexOf(SECOND);
            if (end == -1) {
                return false;
            }
            String sz = str.substring(start, end);
            if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
                return false;
            }
        }
        return true;
    }

    public static boolean findMinuteInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = str.indexOf(MINUTE);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        return MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findHourInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = str.indexOf(HOUR);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        return MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findDayInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = str.indexOf(DAY);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        return MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findMinuteToSecondInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = MacroPromptUtils.findFirstOf(str, COLON);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        if ((end = MacroPromptUtils.findFirstOf(str, PERIOD, start)) != -1) {
            sz = str.substring(start, end);
            if (sz.length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
                return false;
            }
            start = end + 1;
            end = str.indexOf(MINUTETOSECOND);
            sz = str.substring(start, end);
            if (!MacroPromptUtils.isDecimalDigits(sz = sz.trim(), false)) {
                return false;
            }
        } else {
            end = str.indexOf(MINUTETOSECOND);
            if (end == -1) {
                return false;
            }
            sz = str.substring(start, end);
            if ((sz = sz.trim()).length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
                return false;
            }
        }
        return true;
    }

    public static boolean findHourToSecondInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = MacroPromptUtils.findFirstOf(str, COLON);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        sz = str.substring(start, end = MacroPromptUtils.findFirstOf(str, COLON, start));
        if (sz.length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        if ((end = MacroPromptUtils.findFirstOf(str, PERIOD, start)) != -1) {
            sz = str.substring(start, end);
            if (sz.length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
                return false;
            }
            start = end + 1;
            end = str.indexOf(HOURTOSECOND);
            sz = str.substring(start, end);
            if (!MacroPromptUtils.isDecimalDigits(sz = sz.trim(), false)) {
                return false;
            }
        } else {
            end = str.indexOf(HOURTOSECOND);
            if (end == -1) {
                return false;
            }
            sz = str.substring(start, end);
            if ((sz = sz.trim()).length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
                return false;
            }
        }
        return true;
    }

    public static boolean findHourToMinuteInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = MacroPromptUtils.findFirstOf(str, COLON);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        end = str.indexOf(HOURTOMINUTE);
        sz = str.substring(start, end);
        return (sz = sz.trim()).length() == 2 && MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findDayToSecondInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = MacroPromptUtils.findFirstOf(str, SPACE);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        sz = str.substring(start, end = MacroPromptUtils.findFirstOf(str, COLON, start));
        if (sz.length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        sz = str.substring(start, end = MacroPromptUtils.findFirstOf(str, COLON, start));
        if (sz.length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        if ((end = MacroPromptUtils.findFirstOf(str, PERIOD, start)) != -1) {
            sz = str.substring(start, end);
            if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
                return false;
            }
            start = end + 1;
            end = str.indexOf(DAYTOSECOND);
            sz = str.substring(start, end);
            if (!MacroPromptUtils.isDecimalDigits(sz = sz.trim())) {
                return false;
            }
        } else {
            end = str.indexOf(DAYTOSECOND);
            if (end == -1) {
                return false;
            }
            sz = str.substring(start, end);
            if ((sz = sz.trim()).length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
                return false;
            }
        }
        return true;
    }

    public static boolean findDayToMinuteInterval(String str) {
        int start = 0;
        int end = MacroPromptUtils.findFirstOf(str, SPACE);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        sz = str.substring(start, end = MacroPromptUtils.findFirstOf(str, COLON, start));
        if (sz.length() != 2 || !MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        end = str.indexOf(DAYTOMINUTE);
        sz = str.substring(start, end);
        return (sz = sz.trim()).length() == 2 && MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findDayToHourInterval(String str) {
        int start = MacroPromptUtils.findFirstOf(str, DIGITS);
        int end = MacroPromptUtils.findFirstOf(str, SPACE);
        if (end == -1) {
            return false;
        }
        String sz = str.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
            return false;
        }
        start = end + 1;
        end = str.indexOf(DAYTOHOUR);
        sz = str.substring(start, end);
        return (sz = sz.trim()).length() == 2 && MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static boolean findUDATZ(String userValue) {
        String sz;
        int start = MacroPromptUtils.findFirstOf(userValue, SIGNS);
        if (start == -1 || start != 0) {
            return false;
        }
        int end = userValue.indexOf(COLON, start);
        if (end == -1 || end == userValue.length() - 1) {
            return false;
        }
        if (!MacroPromptUtils.isDecimalDigits(sz = userValue.substring(++start, end), true)) {
            return false;
        }
        start = end + 1;
        sz = userValue.substring(start);
        return MacroPromptUtils.isDecimalDigits(sz, true);
    }

    public static int findUDATime(String userValue) {
        int newstart = 0;
        if (0 == userValue.length()) {
            return -1;
        }
        int start = MacroPromptUtils.findFirstNotOf(userValue, WHITESPACES);
        if (start == -1) {
            return -1;
        }
        int end = userValue.indexOf(COLON, start);
        if (end == -1 || end == userValue.length() - 1) {
            return -1;
        }
        String sz = userValue.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz)) {
            return -1;
        }
        start = end + 1;
        if ((end = userValue.indexOf(COLON, start)) == -1 || end == userValue.length() - 1) {
            return -1;
        }
        sz = userValue.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz)) {
            return -1;
        }
        start = end + 1;
        if ((end = userValue.indexOf(PERIOD, start)) == -1) {
            end = MacroPromptUtils.findFirstOf(userValue, SIGNS, start);
            if (end == -1) {
                sz = userValue.substring(start);
                if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
                    return -1;
                }
                return newstart;
            }
            sz = userValue.substring(start, end);
            if (!MacroPromptUtils.isDecimalDigits(sz)) {
                return -1;
            }
            newstart = end;
            return newstart;
        }
        if (end == -1 || end == userValue.length() - 1) {
            return -1;
        }
        sz = userValue.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz)) {
            return -1;
        }
        start = end + 1;
        if ((end = MacroPromptUtils.findFirstOf(userValue, SIGNS, start)) == -1) {
            end = userValue.length();
        } else {
            newstart = end;
        }
        sz = userValue.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz, true)) {
            return -1;
        }
        return newstart;
    }

    public static int findUDADate(String userValue) {
        int newstart;
        if (userValue.length() == 0) {
            return -1;
        }
        int start = MacroPromptUtils.findFirstNotOf(userValue, WHITESPACES);
        if (start == -1) {
            return -1;
        }
        int end = userValue.indexOf(MINUS, start);
        if (end == -1 || end == userValue.length() - 1) {
            return -1;
        }
        String sz = userValue.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz)) {
            return -1;
        }
        start = end + 1;
        if ((end = userValue.indexOf(MINUS, start)) == -1 || end == userValue.length() - 1) {
            return -1;
        }
        sz = userValue.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz)) {
            return -1;
        }
        start = end + 1;
        if ((end = MacroPromptUtils.findFirstOf(userValue, WHITESPACES, start)) == -1) {
            end = userValue.length();
            newstart = 0;
        } else {
            newstart = end;
        }
        sz = userValue.substring(start, end);
        if (!MacroPromptUtils.isDecimalDigits(sz)) {
            return -1;
        }
        return newstart;
    }

    public static boolean isDecimalDigits(String str, boolean allowWhitespaces) {
        if (0 == str.length()) {
            return false;
        }
        int start = MacroPromptUtils.findFirstNotOf(str, DIGITS);
        if (start == -1) {
            return true;
        }
        if (!allowWhitespaces) {
            return false;
        }
        String s = str.substring(start);
        return (start = MacroPromptUtils.findFirstNotOf(s, WHITESPACES)) == -1;
    }

    public static boolean isDecimalDigits(String str) {
        return MacroPromptUtils.isDecimalDigits(str, false);
    }

    public static String convXSD2UDAValue(String xsdValue, IDataType dType) {
        String udaValue = xsdValue;
        DataTypeEnum enumDType = MacroPromptUtils.getEnumValueFromDataTypeName(dType.getTypeName());
        switch (enumDType) {
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                udaValue = xsdValue.replaceAll(COMMA, PERIOD);
                break;
            }
            case DATE: {
                udaValue = udaValue.trim();
                return MacroPromptUtils.parseDate(udaValue);
            }
            case TIME: {
                udaValue = udaValue.trim();
                return MacroPromptUtils.parseTime(udaValue);
            }
            case TIMETZ: {
                udaValue = udaValue.trim();
                return MacroPromptUtils.parseTimeTZ(udaValue);
            }
            case TIMESTAMP: {
                udaValue = udaValue.trim();
                return MacroPromptUtils.parseTimestamp(udaValue);
            }
            case TIMESTAMPTZ: {
                udaValue = udaValue.trim();
                return MacroPromptUtils.parseTimestampTZ(udaValue);
            }
            case INTERVAL: {
                udaValue = udaValue.trim();
                return MacroPromptUtils.parseTimeInterval(udaValue);
            }
            case INTERVALYM: {
                udaValue = udaValue.trim();
                return MacroPromptUtils.parseIntervalYM(udaValue);
            }
        }
        return udaValue;
    }

    public static String parseIntervalYM(String udaValue) {
        if (MacroPromptUtils.findUDAIntervalYM(udaValue)) {
            return udaValue;
        }
        return MacroPromptUtils.parseXSDDurationAsIntervalYM(udaValue);
    }

    public static String parseXSDDurationAsTimeInterval(String udaValue) {
        int dIdx;
        int mIdx;
        int yIdx;
        int end;
        if (udaValue.length() == 0) {
            return null;
        }
        Integer day = 0;
        Integer hour = 0;
        Integer minute = 0;
        Integer second = 0;
        Integer millisecond = 0;
        boolean signed = false;
        int index = 0;
        if (udaValue.charAt(index) == '-') {
            signed = true;
            ++index;
        }
        if (udaValue.charAt(index) != 'P') {
            return null;
        }
        if ((end = udaValue.indexOf(84, ++index)) == -1) {
            end = udaValue.length();
        }
        if ((yIdx = udaValue.indexOf(89, index)) != -1 && yIdx < end) {
            Integer d = MacroPromptUtils.getInt(udaValue, index, yIdx);
            if (d == null || d != 0) {
                return null;
            }
            index = yIdx + 1;
        }
        if ((mIdx = udaValue.indexOf(77, index)) != -1 && mIdx < end) {
            Integer d = MacroPromptUtils.getInt(udaValue, index, mIdx);
            if (d == null || d != 0) {
                return null;
            }
            index = mIdx + 1;
        }
        if ((dIdx = udaValue.indexOf(68, index)) != -1 && dIdx < end && (day = MacroPromptUtils.getInt(udaValue, index, dIdx)) == null) {
            return null;
        }
        if (end != udaValue.length()) {
            int sIdx;
            int mtIdx;
            if ((index = end++) == (end = udaValue.length())) {
                return null;
            }
            int hIdx = udaValue.indexOf(72, index);
            if (hIdx != -1) {
                hour = MacroPromptUtils.getInt(udaValue, index, end);
                if (hour == null) {
                    return null;
                }
                index = hIdx + 1;
            }
            if ((mtIdx = udaValue.indexOf(77, index)) != -1) {
                Integer d = MacroPromptUtils.getInt(udaValue, index, end);
                if (d == null || d != 0) {
                    return null;
                }
                index = mtIdx + 1;
            }
            if ((sIdx = udaValue.indexOf(83, index)) != -1) {
                Integer d = 0;
                int msIdx = udaValue.indexOf(46, index);
                if (msIdx != -1 && msIdx < sIdx) {
                    second = MacroPromptUtils.getInt(udaValue, index, msIdx);
                    if (second == null) {
                        return null;
                    }
                    index = msIdx + 1;
                    if (index == udaValue.length()) {
                        return null;
                    }
                    millisecond = MacroPromptUtils.getInt(udaValue, index, sIdx);
                    if (d == null) {
                        return null;
                    }
                } else {
                    second = MacroPromptUtils.getInt(udaValue, index, sIdx);
                    if (second == null) {
                        return null;
                    }
                }
            }
        }
        String newIntervalTimeStr = signed ? String.format("-%1$d %2$02d:%3$02d:%4$02d.%5$03d", (int)day, (int)hour, (int)minute, (int)second, (int)millisecond) : String.format("%1$d %2$02d:%3$02d:%4$02d.%5$03d", (int)day, (int)hour, (int)minute, (int)second, (int)millisecond);
        return newIntervalTimeStr + SPACE + DAYTOSECOND;
    }

    public static String parseXSDDurationAsIntervalYM(String udaValue) {
        Integer d;
        int dIdx;
        int mIdx;
        int yIdx;
        int end;
        if (udaValue.length() == 0) {
            return null;
        }
        Integer year = 0;
        Integer month = 0;
        boolean signed = false;
        int index = 0;
        if (udaValue.charAt(index) == '-') {
            signed = true;
            ++index;
        }
        if (udaValue.charAt(index) != 'P') {
            return null;
        }
        if ((end = udaValue.indexOf(84, ++index)) == -1) {
            end = udaValue.length();
        }
        if ((yIdx = udaValue.indexOf(89, index)) != -1 && yIdx < end) {
            year = MacroPromptUtils.getInt(udaValue, index, yIdx);
            if (year == null) {
                return null;
            }
            index = yIdx + 1;
        }
        if ((mIdx = udaValue.indexOf(77, index)) != -1 && mIdx < end) {
            month = MacroPromptUtils.getInt(udaValue, index, mIdx);
            if (month == null) {
                return null;
            }
            index = mIdx + 1;
        }
        if ((dIdx = udaValue.indexOf(68, index)) != -1 && dIdx < end && ((d = MacroPromptUtils.getInt(udaValue, index, dIdx)) == null || d != 0)) {
            return null;
        }
        if (end != udaValue.length()) {
            int sIdx;
            int mtIdx;
            if ((index = end++) == (end = udaValue.length())) {
                return null;
            }
            int hIdx = udaValue.indexOf(72, index);
            if (hIdx != -1) {
                Integer d2 = MacroPromptUtils.getInt(udaValue, index, end);
                if (d2 == null || d2 != 0) {
                    return null;
                }
                index = hIdx + 1;
            }
            if ((mtIdx = udaValue.indexOf(77, index)) != -1) {
                Integer d3 = MacroPromptUtils.getInt(udaValue, index, end);
                if (d3 == null || d3 != 0) {
                    return null;
                }
                index = mtIdx + 1;
            }
            if ((sIdx = udaValue.indexOf(83, index)) != -1) {
                int msIdx = udaValue.indexOf(46, index);
                if (msIdx != -1 && msIdx < sIdx) {
                    Integer d4 = MacroPromptUtils.getInt(udaValue, index, msIdx);
                    if (d4 == null || d4 != 0) {
                        return null;
                    }
                    index = msIdx + 1;
                    if (index == udaValue.length()) {
                        return null;
                    }
                    d4 = MacroPromptUtils.getInt(udaValue, index, sIdx);
                    if (d4 == null || d4 != 0) {
                        return null;
                    }
                } else {
                    Integer d5 = MacroPromptUtils.getInt(udaValue, index, sIdx);
                    if (d5 == null || d5 != 0) {
                        return null;
                    }
                }
            }
        }
        String newIntervalYMStr = signed ? String.format("-%1$04d-%2$02d", (int)year, (int)month) : String.format("%1$04d-%2$02d", (int)year, (int)month);
        return newIntervalYMStr + SPACE + YEARTOMONTH;
    }

    public static Integer getInt(String udaValue, int start, int end) {
        String strInt = udaValue.substring(start, end);
        if (MacroPromptUtils.isDecimalDigits(strInt)) {
            return Integer.parseInt(strInt);
        }
        return null;
    }

    public static String parseTimeInterval(String udaValue) {
        if (MacroPromptUtils.findUDATimeInterval(udaValue)) {
            return udaValue;
        }
        return MacroPromptUtils.parseXSDDurationAsTimeInterval(udaValue);
    }

    public static String parseTimestampTZ(String udaValue) {
        int numOfDateValues = 3;
        int[] dateValues = new int[3];
        int numOfTimeValues = 4;
        int[] timeValues = new int[4];
        if (!MacroPromptUtils.getDate(udaValue, dateValues)) {
            return null;
        }
        int index = 10;
        if (udaValue.length() == index || udaValue.charAt(index) != 'T' && udaValue.charAt(index) != ' ') {
            return null;
        }
        if (udaValue.length() == ++index) {
            return null;
        }
        if (!MacroPromptUtils.getTime(udaValue, timeValues, index)) {
            return null;
        }
        boolean signed = false;
        int[] tzValues = new int[2];
        int tzSignIdx = MacroPromptUtils.findFirstOf(udaValue, SIGNS, 18);
        if (tzSignIdx == -1) {
            tzValues[0] = 0;
            tzValues[1] = 0;
        } else {
            if (udaValue.charAt(tzSignIdx) == MINUS.charAt(0)) {
                signed = true;
            }
            if (!MacroPromptUtils.getTZ(udaValue, tzSignIdx, tzValues)) {
                return null;
            }
        }
        if (signed) {
            return String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d.%7$03d-%8$02d:%9$02d", dateValues[0], dateValues[1], dateValues[2], timeValues[0], timeValues[1], timeValues[2], timeValues[3], tzValues[0], tzValues[1]);
        }
        return String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d.%7$03d+%8$02d:%9$02d", dateValues[0], dateValues[1], dateValues[2], timeValues[0], timeValues[1], timeValues[2], timeValues[3], tzValues[0], tzValues[1]);
    }

    public static String parseTimestamp(String udaValue) {
        int numOfDateValues = 3;
        int[] dateValues = new int[3];
        int numOfTimeValues = 4;
        int[] timeValues = new int[4];
        if (!MacroPromptUtils.getDate(udaValue, dateValues)) {
            return null;
        }
        int index = 10;
        if (udaValue.length() == index || udaValue.charAt(index) != 'T' && udaValue.charAt(index) != ' ') {
            return null;
        }
        if (udaValue.length() == ++index) {
            return null;
        }
        if (!MacroPromptUtils.getTime(udaValue, timeValues, index)) {
            return null;
        }
        return String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d.%7$03d", dateValues[0], dateValues[1], dateValues[2], timeValues[0], timeValues[1], timeValues[2], timeValues[3]);
    }

    public static String parseTimeTZ(String udaValue) {
        boolean signed = false;
        int numOfTimeValues = 4;
        int[] timeValues = new int[4];
        int index = 0;
        if (!MacroPromptUtils.getTime(udaValue, timeValues, index)) {
            return null;
        }
        int minTimeSize = 8;
        int[] tzValues = new int[2];
        int tzSignIdx = MacroPromptUtils.findFirstOf(udaValue, SIGNS, 8);
        if (tzSignIdx == -1) {
            tzValues[0] = 0;
            tzValues[1] = 0;
        } else {
            if (udaValue.charAt(tzSignIdx) == MINUS.charAt(0)) {
                signed = true;
            }
            if (!MacroPromptUtils.getTZ(udaValue, tzSignIdx, tzValues)) {
                return null;
            }
        }
        int three = 3;
        String newTimeTZString = signed ? String.format("%1$02d:%2$02d:%3$02d.%4$03d-%5$02d:%6$02d", timeValues[0], timeValues[1], timeValues[2], timeValues[3], tzValues[0], tzValues[1]) : String.format("%1$02d:%2$02d:%3$02d.%4$03d+%5$02d:%6$02d", timeValues[0], timeValues[1], timeValues[2], timeValues[3], tzValues[0], tzValues[1]);
        return newTimeTZString;
    }

    public static boolean getTZ(String udaValue, int start, int[] tzValues) {
        Integer tzHour;
        int index = MacroPromptUtils.findFirstOf(udaValue, SIGNS, start);
        char startChar = udaValue.charAt(start);
        if (startChar != MINUS.charAt(0) && startChar != PLUS.charAt(0)) {
            return false;
        }
        int three = 3;
        if (udaValue.charAt(index + 3) != ':') {
            return false;
        }
        if ((tzHour = MacroPromptUtils.parseInteger(udaValue, ++index, 2)) == null) {
            return false;
        }
        tzValues[0] = tzHour;
        Integer tzMinute = MacroPromptUtils.parseInteger(udaValue, index += 3, 2);
        if (tzMinute == null) {
            return false;
        }
        tzValues[1] = tzMinute;
        return true;
    }

    public static String parseTime(String udaValue) {
        int numOfTimeValues = 4;
        int[] timeValues = new int[4];
        int start = 0;
        if (!MacroPromptUtils.getTime(udaValue, timeValues, start)) {
            return null;
        }
        return String.format("%1$02d:%2$02d:%3$02d.%4$03d", timeValues[0], timeValues[1], timeValues[2], timeValues[3]);
    }

    public static boolean getTime(String udaValue, int[] timeValues, int start) {
        if (udaValue.length() < 8) {
            return false;
        }
        int numOfTimeValues = 4;
        if (timeValues.length < 4) {
            timeValues = new int[4];
        }
        int idxOfFirstSep = start + 2;
        int five = 5;
        int idxOfSecondSep = start + 5;
        if (udaValue.charAt(idxOfFirstSep) != ':' || udaValue.charAt(idxOfSecondSep) != ':') {
            return false;
        }
        int index = start;
        Integer hour = MacroPromptUtils.parseInteger(udaValue, index, 2);
        if (hour == null) {
            return false;
        }
        timeValues[0] = hour;
        index = idxOfFirstSep + 1;
        Integer minute = MacroPromptUtils.parseInteger(udaValue, index, 2);
        if (minute == null) {
            return false;
        }
        timeValues[1] = minute;
        index = idxOfSecondSep + 1;
        Integer second = MacroPromptUtils.parseInteger(udaValue, index, 2);
        if (second == null) {
            return false;
        }
        timeValues[2] = second;
        if (udaValue.length() == 8 + start) {
            timeValues[3] = 0;
            return true;
        }
        int msSeparatorIdx = 8 + start;
        if (udaValue.charAt(msSeparatorIdx) == '.') {
            index = msSeparatorIdx + 1;
            int tzIndex = MacroPromptUtils.findLastOf(udaValue, SIGNS);
            int n = -1;
            if (tzIndex != -1 && tzIndex > msSeparatorIdx) {
                n = tzIndex - msSeparatorIdx - 1;
            }
            if (msSeparatorIdx == udaValue.length()) {
                return false;
            }
            Integer millisecond = MacroPromptUtils.parseInteger(udaValue, index, n);
            if (millisecond != null) {
                timeValues[3] = millisecond;
            } else {
                return false;
            }
        }
        return true;
    }

    public static String parseDate(String udaValue) {
        int numOfDateValues = 3;
        int[] dateValues = new int[3];
        if (!MacroPromptUtils.getDate(udaValue, dateValues)) {
            return null;
        }
        return String.format("%1$4d-%2$02d-%3$02d", dateValues[0], dateValues[1], dateValues[2]);
    }

    public static boolean getDate(String udaValue, int[] dateValues) {
        Integer day;
        if (udaValue.length() < 10) {
            return false;
        }
        if (udaValue.charAt(0) == '-') {
            return false;
        }
        int numOfDigitsInYear = 4;
        int index = udaValue.indexOf(MINUS);
        if (index != 4) {
            return false;
        }
        Integer year = MacroPromptUtils.parseInteger(udaValue, 0, 4);
        if (year == null) {
            return false;
        }
        dateValues[0] = year;
        Integer month = MacroPromptUtils.parseInteger(udaValue, ++index, 2);
        if (month == null) {
            return false;
        }
        dateValues[1] = month;
        int indexOfSecondDateSeparator = 7;
        index = udaValue.indexOf(MINUS, index);
        if (index != 7) {
            return false;
        }
        if ((day = MacroPromptUtils.parseInteger(udaValue, ++index, 2)) == null) {
            return false;
        }
        dateValues[2] = day;
        return true;
    }

    public static Integer parseInteger(String udaValue, int start, int numOfCharsToParse) {
        int end = numOfCharsToParse >= 0 ? start + numOfCharsToParse : udaValue.length();
        String intStr = udaValue.substring(start, end);
        if (MacroPromptUtils.isDecimalDigits(intStr)) {
            return Integer.parseInt(intStr);
        }
        return null;
    }

    public static boolean isValidMUNLiteral(String munLiteral) {
        String portablePart;
        int lhsOffset = munLiteral.indexOf("->");
        if (lhsOffset == -1) {
            return false;
        }
        String lhs = munLiteral.substring(0, lhsOffset);
        if (!MacroPromptUtils.isValidNPartName(lhs)) {
            return false;
        }
        int rhsOffset = MacroPromptUtils.findFirstNotOf(munLiteral, MINUS, lhsOffset);
        if (rhsOffset == -1) {
            return false;
        }
        if ((rhsOffset = MacroPromptUtils.findFirstNotOf(munLiteral, "> \n\t", rhsOffset)) == -1) {
            return false;
        }
        String rhs = munLiteral.substring(rhsOffset, munLiteral.length());
        int colonOffset = rhs.indexOf(COLON);
        if (colonOffset == -1 || MacroPromptUtils.isColonEnclosedInBrackets(rhs, colonOffset)) {
            String portablePart2 = rhs.substring(0);
            return MacroPromptUtils.isValidNPartName(portablePart2);
        }
        String tempPortablePart = rhs.substring(0, colonOffset);
        int portablePartOffset = MacroPromptUtils.findFirstNotOf(tempPortablePart, " \n\t\r", 0);
        if (portablePartOffset != -1 && !MacroPromptUtils.isValidNPartName(portablePart = tempPortablePart.substring(portablePartOffset))) {
            return false;
        }
        int nativeOffset = MacroPromptUtils.findFirstNotOf(rhs, ": \n\t\r", colonOffset);
        if (nativeOffset != -1) {
            String nativePart = rhs.substring(nativeOffset, rhs.length());
            return MacroPromptUtils.isValidNPartName(nativePart);
        }
        return false;
    }

    public static boolean isValidNPartName(String nPartName) {
        nPartName = nPartName.trim();
        try {
            UniqueNameParser.parse(nPartName, -1);
        }
        catch (UniqueNameParserException e) {
            mErrorLogger.log(e);
            return false;
        }
        return true;
    }

    public static boolean isColonEnclosedInBrackets(String strWithColon, int colonOffset) {
        int openBracketOffset = strWithColon.lastIndexOf(91, colonOffset);
        if (openBracketOffset == -1) {
            return false;
        }
        int closeBracketOffset = strWithColon.indexOf(93, colonOffset);
        return closeBracketOffset != -1;
    }
}

