/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractMDXMember
extends AbstractMDXNode {
    private static final String PROP_IS_VALUE_EXPRESSION_FOR_SPECIFIC_AGGREGATION = "isValueExpressionForSpecificAggregation";
    public static final String RECORD_REPLACEMENTS_FOR = "recordReplacementsFor";
    public static final String REPLACEMENTS_FOR = "replacementsFor";

    @Override
    public int getType() {
        return 1022;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1022) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public boolean isCalculatedMember() {
        return false;
    }

    public boolean isAscendantOrDescendantOfCurrentMember() {
        return false;
    }

    public boolean couldResolveToEmptyMember() {
        return true;
    }

    public IHierarchy getHierarchy() {
        MDXHierInfo hierInfo = this.getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1) {
            throw new XQERuntimeException(XQEMessageKeys.MD_InvalidNumberOfHierarchyForMemeber);
        }
        return hierInfo.getProjectedHierarchy(0);
    }

    @Override
    public boolean isProjectedDescendant(AbstractMDXNode node) {
        return node == this;
    }

    @Override
    public void isProjectedDescendant(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> returnNodes) {
        if (nodes.contains(this)) {
            returnNodes.add(this);
            nodes.remove(this);
        }
    }

    @Override
    public boolean projectsOnlyExplicitMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        IHierarchy thisHierarchy = this.getHierarchy();
        if (hierarchy != null && !thisHierarchy.equals(hierarchy)) {
            return false;
        }
        return !this.isContextDependent(thisHierarchy);
    }

    @Override
    public boolean projectsOnlyCalculatedMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        IHierarchy thisHierarchy = this.getHierarchy();
        if (hierarchy != null && !thisHierarchy.equals(hierarchy)) {
            return false;
        }
        return this.getType() == 1013;
    }

    @Override
    public int collectCogMDXGroupProjNodesForRules(IHierarchy hierarchy, List<AbstractMDXNode> mdxNodeList, AbstractMDXNode boundary, AbstractOLAPColumn column) {
        this.throwOnInvalidChildCategories();
        IHierarchy thisHierarchy = this.getHierarchy();
        if (hierarchy != null && !thisHierarchy.equals(hierarchy)) {
            return 0;
        }
        int[] explicitMemberTypes = new int[]{1067, 1013};
        if (this.isOfTypes(explicitMemberTypes)) {
            mdxNodeList.add(this);
            return 1;
        }
        return 0;
    }

    @Override
    public boolean noAncestorDescendantRelationshipAmongProjectedMembers() {
        return true;
    }

    public boolean isValueExpressionForSpecificAggregation() {
        Boolean propValue = (Boolean)this.getPropertyValue(PROP_IS_VALUE_EXPRESSION_FOR_SPECIFIC_AGGREGATION);
        if (propValue == null) {
            propValue = Boolean.FALSE;
        }
        return propValue;
    }

    public void setIsValueExpressionForSpecificAggregation() {
        this.setPropertyValue(PROP_IS_VALUE_EXPRESSION_FOR_SPECIFIC_AGGREGATION, Boolean.TRUE);
    }

    public void setRecordReplacementMembersForTransformation(String transformationName) {
        if (transformationName != null && transformationName.length() > 0) {
            this.setPropertyValue(RECORD_REPLACEMENTS_FOR, transformationName);
            return;
        }
        this.removeProperty(RECORD_REPLACEMENTS_FOR);
    }

    public List<AbstractMDXMember> getReplacementMemberListForTransf(String transformationName) {
        return (List)this.getPropertyValue(transformationName);
    }

    public void addReplacementMemberForTransf(AbstractMDXMember replacement) {
        String transformationName = (String)this.getPropertyValue(RECORD_REPLACEMENTS_FOR);
        if (transformationName == null) {
            return;
        }
        List<AbstractMDXMember> calcs = this.getReplacementMemberListForTransf(transformationName);
        if (calcs == null) {
            calcs = new ArrayList<AbstractMDXMember>();
            this.setPropertyValue(transformationName, calcs);
        }
        MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
        if (this.getType() == 1013 && mdxQuery != null && mdxQuery.isListReport()) {
            List<Integer> edgeMappingColumns = ((MDXCalculatedMemberReference)this).getEdgeMappingColumns();
            if (edgeMappingColumns == null) {
                this.throwInternalError("edgeMappingColumns == null");
            } else {
                Iterator<Integer> it = edgeMappingColumns.iterator();
                while (it.hasNext()) {
                    calcs.add(replacement);
                    it.next();
                }
            }
        } else {
            calcs.add(replacement);
        }
        this.setPropertyValue(transformationName, calcs);
    }
}

