/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameParser;

public final class BaseProperty
extends AbstractMDXNode {
    public static final String PROPERTY_METADATA = "propertyMetadata";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_ROLE_TYPE = "propertyRoleType";
    public static final String PROPERTY_DATA_TYPE = "propertyDataType";
    public static final String SUPPLEMENTARY_METADATA = "supplementaryMetadata";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public void bind(IQueryItem propertyMetadata) {
        this.setPropertyValue(PROPERTY_METADATA, propertyMetadata);
        this.setPropertyValue(PROPERTY_NAME, propertyMetadata.getName());
        String propType = propertyMetadata.getDatatypeName();
        this.setPropertyValue(PROPERTY_DATA_TYPE, MetadataUtil.convertDataType(propType));
    }

    public boolean bind(RoleTypeEnum roleType, IDataType dataType, String mdxName) {
        this.setPropertyValue(PROPERTY_ROLE_TYPE, (Object)roleType);
        IDataType propertyDataType = roleType.getDataType();
        if (propertyDataType == null) {
            propertyDataType = dataType;
        }
        this.setPropertyValue(PROPERTY_DATA_TYPE, propertyDataType);
        String propertyMdxName = roleType.toMDXKeyword();
        if (propertyMdxName == null) {
            propertyMdxName = mdxName;
        }
        this.setPropertyValue(PROPERTY_NAME, propertyMdxName);
        return propertyMdxName != null;
    }

    @Override
    public int getType() {
        return 1025;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1025) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public String getMDXName() {
        String unqualifiedPropertyName = null;
        String qualifiedPropertyName = null;
        IQueryItem property = this.getPropertyMetadata();
        qualifiedPropertyName = (String)this.getPropertyValue("externalName");
        if (qualifiedPropertyName == null || qualifiedPropertyName.length() == 0) {
            qualifiedPropertyName = property != null ? property.getUniqueName() : this.getPropertyName();
        }
        if (qualifiedPropertyName != null) {
            if (RoleTypeEnum.isRSAPIKeyword(qualifiedPropertyName)) {
                qualifiedPropertyName = RoleTypeEnum.rsapiToMdx(qualifiedPropertyName);
            }
        } else {
            this.throwInternalError("qualifiedPropertyName == null");
        }
        try {
            unqualifiedPropertyName = UniqueNameParser.parseLastIdentifier(qualifiedPropertyName);
        }
        catch (Exception e) {
            mErrorLogger.log(e);
            this.throwInternalError("", e);
        }
        return unqualifiedPropertyName;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append("\"");
        if (this.getPropertyMetadata() != null) {
            buffer.append(this.getMDXName());
        } else if (this.getPropertyName() != null) {
            buffer.append(this.getPropertyName());
        } else {
            this.throwInternalError("");
        }
        buffer.append("\"");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("ci", -1);
        trace.attribute("type", "qs:property");
        if (this.getPropertyMetadata() != null) {
            trace.data(this.getPropertyMetadata().getUniqueName());
        } else if (this.getPropertyName() != null) {
            trace.data(RoleTypeEnum.mdxToRsapi(this.getPropertyName()));
        } else {
            this.throwInternalError("");
        }
        trace.endElement();
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        boolean status = false;
        int thisType = this.getType();
        int nodeType = node.getType();
        IQueryItem thisMetadataProperty = this.getPropertyMetadata();
        IQueryItem nodeMetadataProperty = ((BaseProperty)node).getPropertyMetadata();
        String thisCustomProperty = this.getPropertyName();
        String nodeCustomProperty = ((BaseProperty)node).getPropertyName();
        if (thisType == nodeType && thisMetadataProperty == nodeMetadataProperty && (thisCustomProperty == nodeCustomProperty || thisCustomProperty.equals(nodeCustomProperty))) {
            status = true;
        }
        return status;
    }

    @Override
    public int isValidPlannedQuery() {
        int status = this.getId();
        if ((this.getPropertyMetadata() != null || this.getPropertyName() != null) && this.getNumberChildren() == 0) {
            status = -1;
        }
        return status;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    public IQueryItem getPropertyMetadata() {
        return (IQueryItem)this.getPropertyValue(PROPERTY_METADATA);
    }

    public void setPropertyName(String name) {
        this.setPropertyValue(PROPERTY_NAME, name);
    }

    public String getPropertyName() {
        return (String)this.getPropertyValue(PROPERTY_NAME);
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_METADATA, PROPERTY_NAME, PROPERTY_ROLE_TYPE, PROPERTY_DATA_TYPE};
    }

    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROPERTY_DATA_TYPE);
    }

    public IQueryItem getSupplementaryMetadata() {
        return (IQueryItem)this.getPropertyValue(SUPPLEMENTARY_METADATA);
    }

    public void setSupplementaryMetadata(IQueryItem supplementryMetadata) {
        this.setPropertyValue(SUPPLEMENTARY_METADATA, supplementryMetadata);
    }
}

