/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummaryExpr;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import java.util.ArrayList;
import java.util.List;

public final class CogMDXReportSummary
extends CogMDXGroup {
    public static final String PROP_STRING_TUPLECOMPLETED = "tupleCompleted";
    public static final String PROPERTY_REF_EXPRESSION_SUMMARY_FOR = "refExpressionSummaryIsFor";
    public static final String PROP_BOOLEAN_READY_FOR_REMOVAL = "readyForRemoval";

    @Override
    public int getType() {
        return 1080;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1080) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void bindSummaryToDetailExpr(IXQEQueryNode aExpression) {
        if (aExpression == null) {
            this.removeProperty(PROPERTY_REF_EXPRESSION_SUMMARY_FOR);
        } else {
            this.setPropertyValue(PROPERTY_REF_EXPRESSION_SUMMARY_FOR, aExpression);
        }
    }

    public static void updateRefSummary(IXQEQueryNode oldNode, IXQEQueryNode newNode) {
        MDXQuery queryNode = (MDXQuery)oldNode.getAncestorOfType(1002);
        if (queryNode == null) {
            return;
        }
        IXQEQueryNode[] reportSummaries = queryNode.getDescendantsOfType(1080, false);
        for (int idx = 0; idx < reportSummaries.length; ++idx) {
            CogMDXReportSummary reportSummary = (CogMDXReportSummary)reportSummaries[idx];
            if (reportSummary.getDetailExpr() != oldNode) continue;
            reportSummary.bindSummaryToDetailExpr(newNode);
        }
    }

    public IXQEQueryNode getDetailExpr() {
        return (IXQEQueryNode)this.getPropertyValue(PROPERTY_REF_EXPRESSION_SUMMARY_FOR);
    }

    public void setTupleCompleted() {
        this.setPropertyValue(PROP_STRING_TUPLECOMPLETED, Boolean.TRUE);
    }

    public boolean isTupleCompleted() {
        return this.getPropertyValue(PROP_STRING_TUPLECOMPLETED) == Boolean.TRUE;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        if (this.isReadyForRemoval()) {
            return super.getHierarchyInfo();
        }
        this.throwOnInvalidChildCategories();
        AbstractMDXNode expr = (AbstractMDXNode)this.getDetailExpr();
        if (expr == null) {
            expr = (AbstractMDXNode)this.getChild(0);
        }
        if (expr == null) {
            this.throwInternalError("Cannot find expression defining the dimensionality of this Report Summary");
        }
        return expr.getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        if (this.isReadyForRemoval()) {
            return super.getLevelInfo(hierarchy);
        }
        MDXLevelInfo op1ExprInfo = ((AbstractMDXNode)this.getChild(0)).getLevelInfo(hierarchy);
        AbstractMDXSet refDetailExpr = (AbstractMDXSet)this.getDetailExpr();
        if (refDetailExpr != null) {
            MDXHierInfo mdxProjectedSetHierInfo = refDetailExpr.getHierarchyInfo();
            List<IHierarchy> projHierarchies = mdxProjectedSetHierInfo.getProjectedHierarchies();
            for (IHierarchy projHierarchy : projHierarchies) {
                if (op1ExprInfo.getHierarchyInfo().projectsHierarchy(projHierarchy) || hierarchy != null && !hierarchy.equals(projHierarchy)) continue;
                op1ExprInfo.addProjectedHierarchy(projHierarchy.getLevel(0));
            }
        }
        int numberChildren = this.getNumberChildren();
        for (int idx = 0; idx < numberChildren; ++idx) {
            MDXLevelInfo op2ExprInfo = ((AbstractMDXNode)this.getChild(idx)).getLevelInfo(hierarchy);
            op1ExprInfo.replaceProjectedHierarchies(op2ExprInfo);
        }
        return op1ExprInfo;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = new int[]{1021, 1068};
        return categories;
    }

    @Override
    protected boolean isContextDependent(AbstractMDXNode contextBoundary) {
        return ((AbstractMDXNode)this.getChild(0)).isContextDependent(contextBoundary);
    }

    @Override
    protected boolean isContextDependent(IHierarchy hierarchy, AbstractMDXNode contextBoundary) {
        return ((AbstractMDXNode)this.getChild(0)).isContextDependent(hierarchy, contextBoundary);
    }

    @Override
    public boolean projectsCalculatedMember() {
        return true;
    }

    @Override
    public int isValidPlannedQuery() {
        int status = this.getId();
        return status;
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        AbstractMDXSet projectedSet = (AbstractMDXSet)this.getDetailExpr();
        if (projectedSet == null) {
            return false;
        }
        if (this.couldResolveToEmptySetForProvider(ignoreNonEmpty)) {
            return true;
        }
        return projectedSet.couldResolveToEmptySet(ignoreTags, ignoreRaggedUnbalanced, true);
    }

    @Override
    public boolean projectsOnlyExplicitMembers(IHierarchy hierarchy) {
        return false;
    }

    @Override
    public boolean projectsOnlyCalculatedMembers(IHierarchy hierarchy) {
        return false;
    }

    @Override
    protected void addMemberToContext(IXQENodeFactory factory, IHierarchy hierarchy, AbstractMDXMember member, boolean replaceUnresolvedCurrentMemberRefs, AbstractMDXNode contextBoundary) {
    }

    @Override
    public int getNumberOfProjectedTuples() {
        int numberOfTuples = 0;
        int numberOfAbstractSets = 0;
        int numberInNestedSet = 0;
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (!child.isOfCategory(1068)) continue;
            ++numberOfTuples;
        }
        ArrayList<Integer> numberOfTuplesPerNestedSet = new ArrayList<Integer>();
        for (int i = 0; i < numberChildren; ++i) {
            IXQEQueryNode child = this.getChild(i);
            if (!child.isOfCategory(1021)) continue;
            ++numberOfAbstractSets;
            numberInNestedSet = ((AbstractMDXSet)child).getNumberOfProjectedTuples();
            numberOfTuplesPerNestedSet.add(numberInNestedSet);
            if (numberInNestedSet != -1) continue;
            return -1;
        }
        if (numberOfTuples > 0) {
            if (numberOfAbstractSets > 1) {
                this.throwInternalError("ReportSummary with tuples are not expected to have more than 1 nested edge group.");
            }
            if (numberOfTuplesPerNestedSet.size() == 0) {
                numberInNestedSet = 1;
            }
            numberOfTuples *= numberInNestedSet;
        } else {
            if (numberOfAbstractSets > 2) {
                this.throwInternalError("ReportSummary are not expected to have more than 2 nested sets.");
            }
            numberOfTuples = (Integer)numberOfTuplesPerNestedSet.get(0);
            if (numberOfTuplesPerNestedSet.size() == 2) {
                numberOfTuples *= ((Integer)numberOfTuplesPerNestedSet.get(1)).intValue();
            }
        }
        return numberOfTuples;
    }

    @Override
    public boolean isNotReplaceableWithHierarchize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean areIntersectingProjDescendants(AbstractMDXNode node1, AbstractMDXNode node2) {
        return false;
    }

    @Override
    public IHierarchy getFirstSetHierarchy() {
        this.throwOnInvalidChildCategories();
        AbstractMDXNode detailExpr = (AbstractMDXNode)this.getDetailExpr();
        if (detailExpr != null) {
            return detailExpr.getHierarchyInfo().getProjectedHierarchy(0);
        }
        return null;
    }

    @Override
    protected void appendProjectedCalculatedMembers(List<MDXCalculatedMemberReference> calcMembers) {
    }

    public boolean isReadyForRemoval() {
        return this.getPropertyValue(PROP_BOOLEAN_READY_FOR_REMOVAL) == Boolean.TRUE;
    }

    public void setReadyForRemoval(boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_READY_FOR_REMOVAL, Boolean.TRUE);
    }

    public RSAPIDataItem getRSAPIDataItem(CogMDXReportSummaryExpr summExpr) {
        if (this.getRSAPIDataItemList() == null || this.getRSAPIDataItemList().isEmpty()) {
            return null;
        }
        List<IXQEQueryNode> summExprs = this.getDescendantsOfTypeOrdered(1028, false);
        for (int i = 0; i < summExprs.size(); ++i) {
            if (summExprs.get(i) != summExpr) continue;
            return this.getRSAPIDataItemList().get(i);
        }
        return null;
    }
}

