/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.olap.AbstractMDXStringValueExpression;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public class CogMDXStringFunction
extends AbstractMDXStringValueExpression {
    protected static final String PROPERTY_FUNCTION_TYPE = "functionType";
    protected static final String PROPERTY_FUNCTION_NAME = "functionName";
    protected static final String PROPERTY_FUNCTION_MDX = "functionMDX";
    public static final int UPPER = 1;
    public static final int LOWER = 2;

    @Override
    public int getType() {
        return 1149;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1149) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public int getOperatorType() {
        return (Integer)this.getPropertyValue(PROPERTY_FUNCTION_TYPE);
    }

    public void setOperatorType(int type) {
        this.setPropertyValue(PROPERTY_FUNCTION_TYPE, XQEIntegerPool.getInteger(type));
        switch (type) {
            case 1: {
                this.setOperatorMDX("UPPER");
                break;
            }
            case 2: {
                this.setOperatorMDX("LOWER");
                break;
            }
        }
    }

    public void setOperatorMDX(String mdx) {
        this.setPropertyValue(PROPERTY_FUNCTION_MDX, mdx);
    }

    private String getMDXString() {
        return (String)this.getPropertyValue(PROPERTY_FUNCTION_MDX);
    }

    @Override
    public String getMDXTextName() {
        return this.getMDXString();
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: 
            case 2: {
                if (index != 0) break;
                categories = new int[]{1061};
                break;
            }
        }
        if (categories != null) {
            return categories;
        }
        return new int[0];
    }

    @Override
    public int getMinimumNumberChildren() {
        switch (this.getOperatorType()) {
            case 1: 
            case 2: {
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    private String getOperatorTypeString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "toUpper";
                break;
            }
            case 2: {
                operatorTypeString = "toLower";
                break;
            }
        }
        return operatorTypeString;
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement(this.getOperatorTypeString(), -1);
        trace.endElement();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(this.getMDXTextName());
        buffer.append("(");
        this.getChild(0).writeFormattedText(buffer);
        int numberChildren = this.getNumberChildren();
        for (int i = 1; i < numberChildren; ++i) {
            buffer.append(", ");
            this.getChild(i).writeFormattedText(buffer);
        }
        buffer.append(")");
    }
}

