/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXLevel;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import java.util.Collection;
import java.util.HashMap;

public final class MDXAncestors
extends AbstractMDXSetOperator {
    @Override
    public int getType() {
        return 1044;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1044) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public String getMDXTextName() {
        return "ANCESTORS";
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("set", -1);
        trace.endElement();
        trace.beginElement("apply", -1);
        trace.beginElement("ancestor", -1);
        trace.endElement();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
        trace.endElement();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 2;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 ? new int[]{1022} : (index == 1 ? new int[]{1023, 1062} : new int[]{});
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        MDXLevelInfo memberInfo = ((AbstractMDXMember)this.getChild(0)).getLevelInfo(hierarchy);
        if (memberInfo.isEmpty()) {
            return memberInfo;
        }
        IHierarchy memberHierarchy = memberInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (this.getChild(1).isOfCategory(1023)) {
            ILevel targetLevel = ((AbstractMDXLevel)this.getChild(1)).getLevel();
            if (!targetLevel.getHierarchy().equals(memberHierarchy)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
            memberInfo.adjustProjectedLevelsToLevel(targetLevel);
        } else if (this.getChild(1).getType() == 1064 && ((MDXNumericConstant)this.getChild(1)).getConstantValue() instanceof Integer) {
            int targetLevelOffset = (Integer)((MDXNumericConstant)this.getChild(1)).getConstantValue();
            memberInfo.adjustProjectedLevelsByOffset(memberHierarchy, -targetLevelOffset);
        } else {
            memberInfo = new MDXLevelInfo();
            memberInfo.addProjectedHierarchy(memberHierarchy);
        }
        return memberInfo;
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).isAscendantOrDescendantOfCurrentMember();
    }

    @Override
    public boolean projectsCalculatedMember() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).isCalculatedMember();
    }

    @Override
    public boolean projectsNonCalculatedMember() {
        return !this.projectsCalculatedMember();
    }

    @Override
    public boolean projectsDuplicates() {
        return false;
    }

    @Override
    public boolean isHierarchized() {
        return true;
    }

    @Override
    public boolean projectsAtMostOneTuple() {
        return true;
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        this.throwOnInvalidChildCategories();
        if (((AbstractMDXMember)this.getChild(0)).couldResolveToEmptyMember()) {
            return true;
        }
        MDXLevelInfo memberLevelInfo = ((AbstractMDXMember)this.getChild(0)).getLevelInfo();
        if (memberLevelInfo.isEmpty()) {
            return true;
        }
        IHierarchy hierarchy = memberLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        ILevel highestLevel = memberLevelInfo.getHighestProjectedLevel(hierarchy);
        if (this.getChild(1).isOfCategory(1023)) {
            ILevel targetLevel = ((AbstractMDXLevel)this.getChild(1)).getLevel();
            if (!targetLevel.getHierarchy().equals(hierarchy)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
            if (targetLevel.getIndex() > highestLevel.getIndex()) {
                return true;
            }
            return this.couldResolveToEmptySetForProvider(ignoreNonEmpty);
        }
        if (this.getChild(1).getType() == 1064 && ((MDXNumericConstant)this.getChild(1)).getConstantValue() instanceof Integer) {
            int targetLevelOffset = (Integer)((MDXNumericConstant)this.getChild(1)).getConstantValue();
            if (targetLevelOffset < 0) {
                return true;
            }
            int highestTargetLevelIndex = highestLevel.getIndex() - targetLevelOffset;
            if (highestTargetLevelIndex < 0) {
                return true;
            }
            return this.couldResolveToEmptySetForProvider(ignoreNonEmpty);
        }
        return true;
    }

    @Override
    public boolean projectsOnlyExplicitMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).projectsOnlyExplicitMembers(hierarchy);
    }

    @Override
    public boolean projectsOnlyCalculatedMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).projectsOnlyCalculatedMembers(hierarchy);
    }

    @Override
    public boolean isProjectedDescendant(AbstractMDXNode node) {
        return node == this;
    }

    @Override
    public void isProjectedDescendant(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> returnNodes) {
        if (nodes.contains(this)) {
            returnNodes.add(this);
            nodes.remove(this);
        }
    }

    @Override
    public boolean isRaggedUnbalancedCompensationApplicable() {
        boolean isRaggedCompensationRequired = false;
        if (this.getChild(1).getType() != 1064) {
            IHierarchy hierarchy = this.getHierarchyInfo().getProjectedHierarchy(0);
            isRaggedCompensationRequired = ((AbstractMDXMember)this.getChild(0)).isContextDependent(hierarchy, (AbstractMDXNode)this);
        }
        return isRaggedCompensationRequired;
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        ILevel highestReferencedLevel = super.getHighestReferencedLevel(hierarchy);
        ILevel projectedLevel = this.getLevelInfo(hierarchy).getHighestProjectedLevel(hierarchy);
        if (projectedLevel != null) {
            if (highestReferencedLevel == null) {
                highestReferencedLevel = projectedLevel;
            } else if (projectedLevel.getIndex() < highestReferencedLevel.getIndex()) {
                highestReferencedLevel = projectedLevel;
            }
        }
        return highestReferencedLevel;
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        MDXLevelInfo lvlInfo = this.getLevelInfo();
        if (lvlInfo.getHierarchyInfo().getNumberOfNonMeasureHierarchiesProjected() == 1 && lvlInfo.getNumProjectedLevels(lvlInfo.getHierarchyInfo().getProjectedHierarchy(0)) > 0) {
            double n = 0.0;
            HashMap<ILevel, Double> mp = new HashMap<ILevel, Double>();
            for (ILevel l : lvlInfo.getProjectedLevels(lvlInfo.getHierarchyInfo().getProjectedHierarchy(0))) {
                n += 1.0;
                mp.put(l, 1.0);
            }
            return MDXOOMInfo.createOOMInfo(n, mp);
        }
        return MDXOOMInfo.unkownOOM();
    }
}

