/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import java.util.Collection;

public final class MDXAscendants
extends AbstractMDXSetOperator {
    @Override
    public int getType() {
        return 1045;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1045) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public String getMDXTextName() {
        return "ASCENDANTS";
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("ascendantSet", -1);
        trace.endElement();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 ? new int[]{1022} : new int[]{};
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        MDXLevelInfo memberInfo = ((AbstractMDXMember)this.getChild(0)).getLevelInfo(hierarchy);
        if (hierarchy != null && !memberInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
            return memberInfo;
        }
        if (memberInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        IHierarchy memberHierarchy = memberInfo.getHierarchyInfo().getProjectedHierarchy(0);
        memberInfo.adjustProjectedLevelsToAscendants(memberHierarchy);
        return memberInfo;
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).isAscendantOrDescendantOfCurrentMember();
    }

    @Override
    public boolean projectsCalculatedMember() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).isCalculatedMember();
    }

    @Override
    public boolean projectsNonCalculatedMember() {
        return !this.projectsCalculatedMember();
    }

    @Override
    public boolean projectsDuplicates() {
        return false;
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        this.throwOnInvalidChildCategories();
        if (this.couldResolveToEmptySetForProvider(ignoreNonEmpty)) {
            return true;
        }
        return ((AbstractMDXMember)this.getChild(0)).couldResolveToEmptyMember();
    }

    @Override
    public boolean projectsOnlyExplicitMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).projectsOnlyExplicitMembers(hierarchy);
    }

    @Override
    public boolean projectsOnlyCalculatedMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).projectsOnlyCalculatedMembers(hierarchy);
    }

    @Override
    public boolean isProjectedDescendant(AbstractMDXNode node) {
        return node == this;
    }

    @Override
    public void isProjectedDescendant(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> returnNodes) {
        if (nodes.contains(this)) {
            returnNodes.add(this);
            nodes.remove(this);
        }
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        ILevel highestReferencedLevel = super.getHighestReferencedLevel(hierarchy);
        ILevel projectedLevel = this.getLevelInfo(hierarchy).getHighestProjectedLevel(hierarchy);
        if (projectedLevel != null) {
            if (highestReferencedLevel == null) {
                highestReferencedLevel = projectedLevel;
            } else if (projectedLevel.getIndex() < highestReferencedLevel.getIndex()) {
                highestReferencedLevel = projectedLevel;
            }
        }
        return highestReferencedLevel;
    }
}

