/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXBooleanExpression;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;

public class MDXComparisonOperator
extends AbstractMDXBooleanExpression {
    protected static final String PROPERTY_OPERATOR_TYPE = "type";
    protected static final String PROPERTY_MDX_SYNTAX = "mdxSyntax";
    public static final int COMP_OP_EQ = 1;
    public static final int COMP_OP_NEQ = 2;
    public static final int COMP_OP_GT = 3;
    public static final int COMP_OP_LT = 4;
    public static final int COMP_OP_LEQ = 5;
    public static final int COMP_OP_GEQ = 6;
    public static final int COMP_OP_STARTSWITH = 7;
    public static final int COMP_OP_ENDSWITH = 8;
    public static final int COMP_OP_CONTAINS = 9;
    public static final int MSAS_SYNTAX = 1;
    public static final int MDX_ENGINE_SYNTAX = 2;
    public static final int TMR_DIRECT_SYNTAX = 3;
    private static final String PROP_BOOLEAN_CONVERTED_TO_COGMDXIN = "convertedToCogMDXIn";
    private static final String ZERO = "0";
    private static final String MSAS_MDX_SYNTAX_1 = "IIF(VBA!INSTR(";
    private static final String MSAS_MDX_SYNTAX_2 = ")<>0, VBA!MID(";
    private static final String MSAS_MDX_SYNTAX_3 = ", VBA!INSTR(";
    private static final String MSAS_MDX_SYNTAX_4 = "), VBA!LEN(";
    private static final String MSAS_MDX_SYNTAX_5 = "))=";
    private static final String MSAS_MDX_SYNTAX_6 = ", 0)";
    private static final String MSAS_MDX_SYNTAX_7 = "VBA!LEFT(";
    private static final String MSAS_MDX_SYNTAX_8 = ", VBA!LEN(";
    private static final String MSAS_MDX_SYNTAX_9 = "VBA!RIGHT(";
    private static final String TMR_CONTAINS_SYNTAX_1 = "INSTR(1 , ";
    private static final String TMR_CONTAINS_SYNTAX_2 = ", 1) >= 1 ";
    private static final String TMR_STARTSWITH_SYNTAX_1 = "LEFT(";
    private static final String TMR_STARTSENDSWITH_SYNTAX_1 = ", LEN(";
    private static final String TMR_STARTSENDSWITH_SYNTAX_2 = "))=";
    private static final String TMR_ENDSWITH_SYNTAX_1 = "RIGHT(";

    @Override
    public int getType() {
        return 1070;
    }

    public int getOperatorType() {
        return (Integer)this.getPropertyValue(PROPERTY_OPERATOR_TYPE);
    }

    public void setOperatorType(int type) {
        if (type != 1 && type != 2 && type != 6 && type != 5 && type != 3 && type != 4 && type != 7 && type != 8 && type != 9) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid operand in call to MDXComparisonOperator.setOperatorType().");
        }
        this.setPropertyValue(PROPERTY_OPERATOR_TYPE, XQEIntegerPool.getInteger(type));
    }

    public void setMDXSyntax(int mdxSyntax) {
        this.setPropertyValue(PROPERTY_MDX_SYNTAX, mdxSyntax);
    }

    public int getMDXSyntax() {
        Integer value = (Integer)this.getPropertyValue(PROPERTY_MDX_SYNTAX);
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1070) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public String getOperatorTypeString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "eq";
                break;
            }
            case 2: {
                operatorTypeString = "neq";
                break;
            }
            case 3: {
                operatorTypeString = "gt";
                break;
            }
            case 4: {
                operatorTypeString = "lt";
                break;
            }
            case 6: {
                operatorTypeString = "geq";
                break;
            }
            case 5: {
                operatorTypeString = "leq";
                break;
            }
            case 7: {
                operatorTypeString = "startsWith";
                break;
            }
            case 8: {
                operatorTypeString = "endsWith";
                break;
            }
            case 9: {
                operatorTypeString = "contains";
                break;
            }
        }
        return operatorTypeString;
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement(this.getOperatorTypeString(), -1);
        trace.endElement();
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            this.getChild(i).dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("operatorTypeName", this.getOperatorTypeString());
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 || index == 1 ? new int[]{1061, 1129} : new int[]{};
        return categories;
    }

    public String getMDXString() {
        String operatorTypeString = null;
        int operatorType = this.getOperatorType();
        switch (operatorType) {
            case 1: {
                operatorTypeString = "=";
                break;
            }
            case 2: {
                operatorTypeString = "<>";
                break;
            }
            case 3: {
                operatorTypeString = ">";
                break;
            }
            case 4: {
                operatorTypeString = "<";
                break;
            }
            case 6: {
                operatorTypeString = ">=";
                break;
            }
            case 5: {
                operatorTypeString = "<=";
                break;
            }
            case 9: {
                operatorTypeString = "CONTAINS";
                break;
            }
            case 7: {
                operatorTypeString = "STARTSWITH";
                break;
            }
            case 8: {
                operatorTypeString = "ENDSWITH";
                break;
            }
        }
        return operatorTypeString;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        int mdxSyntax = 0;
        int type = this.getOperatorType();
        if (type == 9 || type == 8 || type == 7) {
            mdxSyntax = this.getMDXSyntax();
            MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
            if (mdxQuery != null && mdxQuery.getDataSourceType().equals("TMR") && !mdxQuery.getUseLocalQueryProcessing()) {
                mdxSyntax = 3;
            }
        }
        if (mdxSyntax == 1) {
            this.writeMSASSyntax(buffer);
        } else if (mdxSyntax == 2) {
            this.writeMDXEngineSyntax(buffer);
        } else if (mdxSyntax == 3) {
            this.writeTMRDirectSyntax(buffer);
        } else {
            boolean isEssbase = this.isUseEssbasePropertyFormat();
            if (isEssbase) {
                buffer.append("(");
            }
            this.getChild(0).writeFormattedText(buffer);
            buffer.append(" ");
            buffer.append(this.getMDXString());
            buffer.append(" ");
            this.getChild(1).writeFormattedText(buffer);
            if (isEssbase) {
                buffer.append(")");
            }
        }
    }

    private void writeMDXEngineSyntax(StringBuilder buffer) {
        int type = this.getOperatorType();
        switch (type) {
            case 9: {
                buffer.append("CONTAINS");
                buffer.append("(");
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(", ");
                this.getChild(1).writeFormattedText(buffer);
                buffer.append(")");
                break;
            }
            case 7: {
                buffer.append("STARTSWITH");
                buffer.append("(");
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(", ");
                this.getChild(1).writeFormattedText(buffer);
                buffer.append(")");
                break;
            }
            case 8: {
                buffer.append("ENDSWITH");
                buffer.append("(");
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(", ");
                this.getChild(1).writeFormattedText(buffer);
                buffer.append(")");
                break;
            }
        }
    }

    private void writeTMRDirectSyntax(StringBuilder buffer) {
        int type = this.getOperatorType();
        switch (type) {
            case 9: {
                buffer.append(TMR_CONTAINS_SYNTAX_1);
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(", ");
                this.getChild(1).writeFormattedText(buffer);
                buffer.append(TMR_CONTAINS_SYNTAX_2);
                break;
            }
            case 7: {
                buffer.append(TMR_STARTSWITH_SYNTAX_1);
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(TMR_STARTSENDSWITH_SYNTAX_1);
                this.getChild(1).writeFormattedText(buffer);
                buffer.append("))=");
                this.getChild(1).writeFormattedText(buffer);
                break;
            }
            case 8: {
                buffer.append(TMR_ENDSWITH_SYNTAX_1);
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(TMR_STARTSENDSWITH_SYNTAX_1);
                this.getChild(1).writeFormattedText(buffer);
                buffer.append("))=");
                this.getChild(1).writeFormattedText(buffer);
                break;
            }
        }
    }

    private void writeMSASSyntax(StringBuilder buffer) {
        int type = this.getOperatorType();
        switch (type) {
            case 9: {
                buffer.append(MSAS_MDX_SYNTAX_1);
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(", ");
                this.getChild(1).writeFormattedText(buffer);
                buffer.append(MSAS_MDX_SYNTAX_2);
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(MSAS_MDX_SYNTAX_3);
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(", ");
                this.getChild(1).writeFormattedText(buffer);
                buffer.append(MSAS_MDX_SYNTAX_4);
                this.getChild(1).writeFormattedText(buffer);
                buffer.append("))=");
                this.getChild(1).writeFormattedText(buffer);
                buffer.append(MSAS_MDX_SYNTAX_6);
                break;
            }
            case 7: {
                buffer.append(MSAS_MDX_SYNTAX_7);
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(MSAS_MDX_SYNTAX_8);
                this.getChild(1).writeFormattedText(buffer);
                buffer.append("))=");
                this.getChild(1).writeFormattedText(buffer);
                break;
            }
            case 8: {
                buffer.append(MSAS_MDX_SYNTAX_9);
                this.getChild(0).writeFormattedText(buffer);
                buffer.append(MSAS_MDX_SYNTAX_8);
                this.getChild(1).writeFormattedText(buffer);
                buffer.append("))=");
                this.getChild(1).writeFormattedText(buffer);
                break;
            }
        }
    }

    @Override
    public int getMinimumNumberChildren() {
        return 2;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this.getType() == node.getType() && this.getOperatorType() == ((MDXComparisonOperator)node).getOperatorType()) {
            return super.isSameExpression(node, compareCalcDefiniton);
        }
        return false;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_OPERATOR_TYPE};
    }

    @Override
    public boolean isConditionsOnValueExpressions() {
        this.throwOnInvalidChildCategories();
        return true;
    }

    @Override
    public List<AbstractMDXValueExpression> getContextDependentValueExpressionConditionOperands() {
        this.throwOnInvalidChildCategories();
        ArrayList<AbstractMDXValueExpression> result = new ArrayList<AbstractMDXValueExpression>();
        if (((AbstractMDXNode)this.getChild(0)).isContextDependent(false)) {
            result.add((AbstractMDXValueExpression)this.getChild(0));
        }
        if (((AbstractMDXNode)this.getChild(1)).isContextDependent(false)) {
            result.add((AbstractMDXValueExpression)this.getChild(1));
        }
        return result;
    }

    public boolean isConvertToCogMDXIn() {
        return Boolean.TRUE.equals(this.getPropertyValue(PROP_BOOLEAN_CONVERTED_TO_COGMDXIN));
    }

    public void setConvertToCogMDXIn(boolean convertToCogMDXIn) {
        this.setPropertyValue(PROP_BOOLEAN_CONVERTED_TO_COGMDXIN, convertToCogMDXIn);
    }
}

