/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXDateTimeValueExpression;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQETrace;

public class MDXDateTimeConstant
extends AbstractMDXDateTimeValueExpression {
    public static final String PROPERTY_VALUE = "value";

    @Override
    public int getType() {
        return 1151;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1151) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setConstantValue(Value value) {
        this.setPropertyValue(PROPERTY_VALUE, value);
    }

    public Value getConstantValue() {
        return (Value)this.getPropertyValue(PROPERTY_VALUE);
    }

    @Override
    public int isValidPlannedQuery() {
        int status = this.getId();
        if (this.getNumberChildren() == 0) {
            return -1;
        }
        return status;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[0];
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append("\"");
        buffer.append(((Value)this.getPropertyValue(PROPERTY_VALUE)).getString());
        buffer.append("\"");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        Object value = this.getPropertyValue(PROPERTY_VALUE);
        trace.beginElement("cn", -1);
        if (value instanceof TimestampValue || value instanceof DateValue) {
            trace.attribute("type", "xsd:dateTime");
        } else if (value instanceof TimeValue) {
            trace.attribute("type", "xsd:time");
        } else {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        trace.data(((Value)this.getPropertyValue(PROPERTY_VALUE)).getXSDLiteral());
        trace.endElement();
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this.getType() == node.getType() && this.getConstantValue().equals(((MDXDateTimeConstant)node).getConstantValue())) {
            return super.isSameExpression(node, compareCalcDefiniton);
        }
        return false;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_VALUE};
    }

    @Override
    public boolean isLiteral() {
        return true;
    }
}

