/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXLevel;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.util.DescendantsRangeFlagEnum;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class MDXDescendants
extends AbstractMDXSetOperator {
    protected static final String NODE_CUSTOM_PROPERTY_RANGE_ID = "rangeId";
    protected static final String PROP_INCLUDE_MEMBER_WITH_BEFORE = "includeMemberWithBefore";

    public MDXDescendants() {
        this.setRangeFlag(0);
    }

    @Override
    public int getType() {
        return 1052;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1052) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setRangeFlag(int range) {
        this.setPropertyValue(NODE_CUSTOM_PROPERTY_RANGE_ID, XQEIntegerPool.getInteger(range));
    }

    public int getRangeFlag() {
        Integer range = this.getIntegerPropertyValue(NODE_CUSTOM_PROPERTY_RANGE_ID);
        if (range == null) {
            this.throwInternalError("Range flag not set.");
        }
        return range;
    }

    public void setIncludeMemberWithBefore(boolean includeMember) {
        this.setPropertyValue(PROP_INCLUDE_MEMBER_WITH_BEFORE, includeMember);
    }

    public boolean getIncludeMemberWithBefore() {
        Boolean value = this.getBooleanPropertyValue(PROP_INCLUDE_MEMBER_WITH_BEFORE);
        if (value == null) {
            return true;
        }
        return value;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("rangeString", DescendantsRangeFlagEnum.getStringFlag(this.getRangeFlag()));
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        boolean includeMember = true;
        int range = this.getRangeFlag();
        if (range == 1 || range == 3 || range == 5 || range == 6) {
            includeMember = this.getIncludeMemberWithBefore();
        }
        if (!includeMember) {
            buffer.append("EXCEPT");
            buffer.append("(");
        }
        buffer.append("DESCENDANTS");
        buffer.append("(");
        boolean isFirst = true;
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            childIterator.next().writeFormattedText(buffer);
        }
        if (this.getRangeFlag() != 0) {
            buffer.append(", ");
            buffer.append(DescendantsRangeFlagEnum.getStringFlag(this.getRangeFlag()));
        }
        buffer.append(")");
        if (!includeMember) {
            buffer.append(", ");
            buffer.append("{");
            this.getChild(0).writeFormattedText(buffer);
            buffer.append("}");
            buffer.append(")");
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        if (this.getCachingId() != 0) {
            trace.attribute("id", this.getCachingId());
        }
        trace.beginElement("descendantSet", -1);
        trace.endElement();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        String beforeFlag = "before";
        if (this.getIncludeMemberWithBefore()) {
            beforeFlag = "beforeWithMember";
        }
        switch (this.getRangeFlag()) {
            case 1: {
                this.addMDQueryRangeFlag(trace, beforeFlag);
                break;
            }
            case 2: {
                this.addMDQueryRangeFlag(trace, "after");
                break;
            }
            case 3: {
                this.addMDQueryRangeFlag(trace, beforeFlag);
                this.addMDQueryRangeFlag(trace, "after");
                break;
            }
            case 4: {
                this.addMDQueryRangeFlag(trace, "self");
                this.addMDQueryRangeFlag(trace, "after");
                break;
            }
            case 5: {
                this.addMDQueryRangeFlag(trace, "self");
                this.addMDQueryRangeFlag(trace, beforeFlag);
                break;
            }
            case 6: {
                this.addMDQueryRangeFlag(trace, "self");
                this.addMDQueryRangeFlag(trace, beforeFlag);
                this.addMDQueryRangeFlag(trace, "after");
                break;
            }
        }
        trace.endElement();
    }

    private void addMDQueryRangeFlag(XQETrace trace, String option) {
        trace.beginElement("cn", -1);
        trace.attribute("type", "xsd:string");
        trace.data(option);
        trace.endElement();
    }

    @Override
    public int getMinimumNumberChildren() {
        return 2;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        categories = index == 0 ? new int[]{1022} : (index == 1 ? new int[]{1023, 1062} : new int[]{});
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).getHierarchyInfo();
    }

    @Override
    public MDXLevelInfo getLevelInfo(IHierarchy forHierarchy) {
        this.throwOnInvalidChildCategories();
        MDXLevelInfo memberInfo = ((AbstractMDXMember)this.getChild(0)).getLevelInfo(forHierarchy);
        if (memberInfo.isEmpty()) {
            return memberInfo;
        }
        if (memberInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        IHierarchy hierarchy = memberInfo.getHierarchyInfo().getProjectedHierarchy(0);
        List<Object> projectedLevels = new LinkedList();
        if (this.getChild(1).isOfCategory(1023)) {
            ILevel targetLevel = ((AbstractMDXLevel)this.getChild(1)).getLevel();
            if (!targetLevel.getHierarchy().equals(hierarchy)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
            for (int i = 0; i < memberInfo.getNumProjectedLevels(hierarchy); ++i) {
                MDXLevelInfo.LevelInfo wrappedInfo;
                ILevel memberLevel = memberInfo.getProjectedLevel(hierarchy, i);
                if (memberLevel instanceof MDXLevelInfo.LevelInfo && !(wrappedInfo = (MDXLevelInfo.LevelInfo)memberLevel).hasNonCalculation() && !wrappedInfo.equals(targetLevel)) continue;
                int memberLevelIndex = memberLevel.getIndex();
                int targetLevelIndex = targetLevel.getIndex();
                MDXDescendants.adjustLevelInfoByLevelObject(this.getRangeFlag(), this.getIncludeMemberWithBefore(), targetLevel, hierarchy, targetLevelIndex, memberLevelIndex, projectedLevels);
            }
        } else if (this.getChild(1).getType() == 1064 && ((MDXNumericConstant)this.getChild(1)).getConstantValue() instanceof Integer) {
            int targetLevelOffset = (Integer)((MDXNumericConstant)this.getChild(1)).getConstantValue();
            for (int i = 0; i < memberInfo.getNumProjectedLevels(hierarchy); ++i) {
                int memberLevelIndex;
                int targetLevelIndex;
                MDXLevelInfo.LevelInfo wrappedInfo;
                ILevel memberLevel = memberInfo.getProjectedLevel(hierarchy, i);
                if (memberLevel instanceof MDXLevelInfo.LevelInfo && !(wrappedInfo = (MDXLevelInfo.LevelInfo)memberLevel).hasNonCalculation() && wrappedInfo.getIndex() != targetLevelOffset || (targetLevelIndex = (memberLevelIndex = memberLevel.getIndex()) + targetLevelOffset) < 0) continue;
                MDXDescendants.adjustLevelInfoByLevelIndex(this.getRangeFlag(), this.getIncludeMemberWithBefore(), hierarchy, targetLevelIndex, memberLevelIndex, projectedLevels);
            }
        } else {
            projectedLevels = hierarchy.getLevels();
        }
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        if (projectedLevels.size() == 0) {
            levelInfo.addProjectedHierarchyNoLevels(hierarchy);
        } else {
            levelInfo.addProjectedLevels(projectedLevels);
        }
        return levelInfo;
    }

    public static void adjustLevelInfoByLevelObject(int rangeFlag, boolean bIncludeMemberWithBefore, ILevel targetLevel, IHierarchy hierarchy, int targetLevelIndex, int memberLevelIndex, List<ILevel> projectedLevels) {
        switch (rangeFlag) {
            case 0: {
                if (targetLevelIndex < memberLevelIndex) break;
                projectedLevels.add(targetLevel);
                break;
            }
            case 1: {
                if (!bIncludeMemberWithBefore) {
                    ++memberLevelIndex;
                }
                if (targetLevelIndex <= memberLevelIndex) break;
                for (int index = memberLevelIndex; index < targetLevelIndex; ++index) {
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 2: {
                for (int index = targetLevelIndex + 1; index < hierarchy.getLevelCount(); ++index) {
                    if (index < memberLevelIndex) continue;
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 5: {
                if (!bIncludeMemberWithBefore) {
                    ++memberLevelIndex;
                }
                for (int index = memberLevelIndex; index <= targetLevelIndex; ++index) {
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 4: {
                for (int index = targetLevelIndex; index < hierarchy.getLevelCount(); ++index) {
                    if (index < memberLevelIndex) continue;
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 3: {
                if (!bIncludeMemberWithBefore) {
                    ++memberLevelIndex;
                }
                for (int index = memberLevelIndex; index < hierarchy.getLevelCount(); ++index) {
                    if (index == targetLevelIndex) continue;
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 6: {
                if (!bIncludeMemberWithBefore) {
                    ++memberLevelIndex;
                }
                for (int index = memberLevelIndex; index < hierarchy.getLevelCount(); ++index) {
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
        }
    }

    public static void adjustLevelInfoByLevelIndex(int rangeFlag, boolean bIncludeMemberWithBefore, IHierarchy hierarchy, int targetLevelIndex, int memberLevelIndex, List<ILevel> projectedLevels) {
        switch (rangeFlag) {
            case 0: {
                if (targetLevelIndex < memberLevelIndex || targetLevelIndex >= hierarchy.getLevelCount()) break;
                if (hierarchy.isRagged() && targetLevelIndex != memberLevelIndex) {
                    for (int index = targetLevelIndex; index < hierarchy.getLevelCount(); ++index) {
                        projectedLevels.add(hierarchy.getLevels().get(index));
                    }
                    break;
                }
                projectedLevels.add(hierarchy.getLevels().get(targetLevelIndex));
                break;
            }
            case 1: {
                if (targetLevelIndex <= memberLevelIndex) break;
                if (hierarchy.isRagged() || targetLevelIndex > hierarchy.getLevelCount()) {
                    targetLevelIndex = hierarchy.getLevelCount();
                }
                if (!bIncludeMemberWithBefore) {
                    ++memberLevelIndex;
                }
                for (int index = memberLevelIndex; index < targetLevelIndex; ++index) {
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 2: {
                if (targetLevelIndex < memberLevelIndex && hierarchy.isRagged()) {
                    targetLevelIndex = 0;
                }
                for (int index = targetLevelIndex + 1; index < hierarchy.getLevelCount(); ++index) {
                    if (index < memberLevelIndex) continue;
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 5: {
                if (targetLevelIndex >= hierarchy.getLevelCount()) {
                    targetLevelIndex = hierarchy.getLevelCount() - 1;
                }
                if (!bIncludeMemberWithBefore) {
                    ++memberLevelIndex;
                }
                for (int index = memberLevelIndex; index <= targetLevelIndex; ++index) {
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 4: {
                for (int index = targetLevelIndex; index < hierarchy.getLevelCount(); ++index) {
                    if (index < memberLevelIndex) continue;
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 3: {
                if (!bIncludeMemberWithBefore) {
                    ++memberLevelIndex;
                }
                for (int index = memberLevelIndex; index < hierarchy.getLevelCount(); ++index) {
                    if (index == targetLevelIndex && !hierarchy.isRagged()) continue;
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
            case 6: {
                if (!bIncludeMemberWithBefore) {
                    ++memberLevelIndex;
                }
                for (int index = memberLevelIndex; index < hierarchy.getLevelCount(); ++index) {
                    projectedLevels.add(hierarchy.getLevels().get(index));
                }
                break;
            }
        }
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).getType() == 1076;
    }

    @Override
    public boolean projectsCalculatedMember() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).isCalculatedMember();
    }

    @Override
    public boolean projectsNonCalculatedMember() {
        return !this.projectsCalculatedMember();
    }

    @Override
    public boolean projectsDuplicates() {
        return false;
    }

    @Override
    public boolean isHierarchized() {
        return true;
    }

    @Override
    public ILevel getLowestReferencedLevel(IHierarchy hierarchy) {
        return this.getLevelInfo(hierarchy).getLowestProjectedLevel(hierarchy);
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        return this.getLevelInfo(hierarchy).getHighestProjectedLevel(hierarchy);
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{NODE_CUSTOM_PROPERTY_RANGE_ID, PROP_INCLUDE_MEMBER_WITH_BEFORE};
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        block32: {
            IHierarchy hierarchy;
            MDXLevelInfo memberLevelInfo;
            block31: {
                this.throwOnInvalidChildCategories();
                if (((AbstractMDXMember)this.getChild(0)).couldResolveToEmptyMember()) {
                    return true;
                }
                memberLevelInfo = ((AbstractMDXMember)this.getChild(0)).getLevelInfo();
                if (memberLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
                }
                hierarchy = memberLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
                if (!this.getChild(1).isOfCategory(1023)) break block31;
                MDXLevelInfo targetLevelInfo = ((AbstractMDXLevel)this.getChild(1)).getLevelInfo(hierarchy);
                if (!targetLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
                }
                if (targetLevelInfo.getProjectedLevels(hierarchy).size() == 0) {
                    return true;
                }
                for (int i = 0; i < memberLevelInfo.getNumProjectedLevels(hierarchy); ++i) {
                    ILevel memberLevel = memberLevelInfo.getProjectedLevel(hierarchy, i);
                    block19: for (int j = 0; j < targetLevelInfo.getNumProjectedLevels(hierarchy); ++j) {
                        ILevel targetLevel = targetLevelInfo.getProjectedLevel(hierarchy, j);
                        int memberLevelIndex = memberLevel.getIndex();
                        int targetLevelIndex = targetLevel.getIndex();
                        switch (this.getRangeFlag()) {
                            case 0: {
                                if (targetLevelIndex < memberLevelIndex) {
                                    return true;
                                }
                                if (targetLevelIndex <= memberLevelIndex || ignoreRaggedUnbalanced || !hierarchy.isUnbalanced() && !hierarchy.isRagged()) continue block19;
                                return true;
                            }
                            case 1: {
                                if (targetLevelIndex > memberLevelIndex) continue block19;
                                return true;
                            }
                            case 2: {
                                if (targetLevelIndex == hierarchy.getLevelCount() - 1) {
                                    return true;
                                }
                                if (ignoreRaggedUnbalanced || !hierarchy.isUnbalanced() && !hierarchy.isRagged()) continue block19;
                                return true;
                            }
                            case 5: {
                                if (targetLevelIndex >= memberLevelIndex) continue block19;
                                return true;
                            }
                            case 4: {
                                if (targetLevelIndex <= memberLevelIndex || ignoreRaggedUnbalanced || !hierarchy.isUnbalanced() && !hierarchy.isRagged()) continue block19;
                                return true;
                            }
                            case 3: {
                                if (targetLevelIndex != memberLevelIndex || ignoreRaggedUnbalanced || !hierarchy.isUnbalanced() && !hierarchy.isRagged()) continue block19;
                                return true;
                            }
                            case 6: {
                                continue block19;
                            }
                        }
                    }
                }
                break block32;
            }
            if (this.getChild(1).getType() != 1064 || !(((MDXNumericConstant)this.getChild(1)).getConstantValue() instanceof Integer)) break block32;
            int targetLevelOffset = (Integer)((MDXNumericConstant)this.getChild(1)).getConstantValue();
            block20: for (int i = 0; i < memberLevelInfo.getNumProjectedLevels(hierarchy); ++i) {
                ILevel memberLevel = memberLevelInfo.getProjectedLevel(hierarchy, i);
                int memberLevelIndex = memberLevel.getIndex();
                int targetLevelIndex = memberLevelIndex + targetLevelOffset;
                if (targetLevelIndex < 0) {
                    return true;
                }
                switch (this.getRangeFlag()) {
                    case 0: {
                        if (targetLevelIndex >= hierarchy.getLevelCount() || targetLevelIndex < memberLevelIndex) {
                            return true;
                        }
                        if (targetLevelIndex <= memberLevelIndex || ignoreRaggedUnbalanced || !hierarchy.isUnbalanced() && !hierarchy.isRagged()) continue block20;
                        return true;
                    }
                    case 1: {
                        if (targetLevelIndex > memberLevelIndex) continue block20;
                        return true;
                    }
                    case 2: {
                        if (targetLevelIndex >= hierarchy.getLevelCount() - 1) {
                            return true;
                        }
                        if (ignoreRaggedUnbalanced || !hierarchy.isUnbalanced() && !hierarchy.isRagged()) continue block20;
                        return true;
                    }
                    case 5: {
                        if (targetLevelIndex >= memberLevelIndex) continue block20;
                        return true;
                    }
                    case 4: {
                        if (targetLevelIndex <= memberLevelIndex) continue block20;
                        if (targetLevelIndex >= hierarchy.getLevelCount()) {
                            return true;
                        }
                        if (ignoreRaggedUnbalanced || !hierarchy.isUnbalanced() && !hierarchy.isRagged()) continue block20;
                        return true;
                    }
                    case 3: {
                        if (targetLevelIndex != memberLevelIndex || ignoreRaggedUnbalanced || !hierarchy.isUnbalanced() && !hierarchy.isRagged()) continue block20;
                        return true;
                    }
                    case 6: {
                        continue block20;
                    }
                }
            }
        }
        return this.couldResolveToEmptySetForProvider(ignoreNonEmpty);
    }

    @Override
    public boolean projectsOnlyExplicitMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXMember)this.getChild(0)).projectsOnlyExplicitMembers(hierarchy);
    }

    @Override
    public boolean projectsOnlyCalculatedMembers(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        return false;
    }

    @Override
    public boolean isRaggedUnbalancedCompensationApplicable() {
        boolean isRaggedCompensationRequired = false;
        if (this.getChild(1).getType() != 1064) {
            isRaggedCompensationRequired = true;
        }
        return isRaggedCompensationRequired;
    }

    @Override
    public boolean isProjectedDescendant(AbstractMDXNode node) {
        return node == this;
    }

    @Override
    public void isProjectedDescendant(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> returnNodes) {
        if (nodes.contains(this)) {
            returnNodes.add(this);
            nodes.remove(this);
        }
    }

    @Override
    public boolean isNotReplaceableWithHierarchize() {
        AbstractMDXNode mdxNode = (AbstractMDXNode)this.getChild(0);
        return !mdxNode.isOfCategory(1076);
    }

    @Override
    public MDXOOMInfo computeOOM(MDXOOMContext context) {
        return MDXOOMInfo.createOOMInfoDescendants(context, this.getLevelInfo(), ((AbstractMDXNode)this.getChild(0)).computeOOM(context));
    }
}

