/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.trace.XQETrace;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MDXDimensionProperties {
    public static final String MDX_EDGE_DIMENSION_PROPERTIES = "dimensionProperties";
    private Set<String> mDimensionProperties = new TreeSet<String>();
    private Set<IQueryItem> mDimensionCustomProperties = new HashSet<IQueryItem>();

    public MDXDimensionProperties() {
        this.mDimensionProperties.add("PARENT_UNIQUE_NAME");
        this.mDimensionProperties.add("PARENT_LEVEL");
    }

    public void addMemberProperty(String memberProperty) {
        this.mDimensionProperties.add(memberProperty);
    }

    public void addCustomMemberProperty(IQueryItem queryItemProperty) {
        if (!this.containsMemberProperty(queryItemProperty.getUniqueName())) {
            this.addMemberProperty(queryItemProperty.getUniqueName());
        }
        this.mDimensionCustomProperties.add(queryItemProperty);
    }

    public void addCustomerDimensionProperties(MDXDimensionProperties dimensionProperties) {
        List<IQueryItem> dimensionPropertiesList = dimensionProperties.getCustomMemberProperties();
        for (IQueryItem property : dimensionPropertiesList) {
            this.addCustomMemberProperty(property);
        }
    }

    public void removeMemberProperty(String memberProperty) {
        this.mDimensionProperties.remove(memberProperty);
    }

    public boolean containsMemberProperty(String memberProperty) {
        return this.mDimensionProperties.contains(memberProperty);
    }

    public List<IQueryItem> getCustomMemberProperties() {
        ArrayList<IQueryItem> customMemberProperties = new ArrayList<IQueryItem>();
        customMemberProperties.addAll(this.mDimensionCustomProperties);
        return customMemberProperties;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (String currentProperty : this.mDimensionProperties) {
            if (currentProperty.equals("_rollupType")) continue;
            if (buffer.length() > 0) {
                buffer.append(", ");
                buffer.append(" ");
            }
            buffer.append(currentProperty);
        }
        return buffer.toString();
    }

    public void writeFormattedText(StringBuilder buffer) {
        if (this.mDimensionProperties.size() > 0 || this.mDimensionCustomProperties.size() > 0) {
            buffer.append(" ");
            buffer.append("DIMENSION PROPERTIES");
            buffer.append(" ");
            buffer.append(this.toString());
        }
    }

    public boolean hasNonMDDSDefault() {
        boolean hasNonMDDSDefault = false;
        Iterator<String> it = this.mDimensionProperties.iterator();
        while (it.hasNext()) {
            if (RoleTypeEnum.isRSAPIDefault(it.next())) continue;
            hasNonMDDSDefault = true;
            break;
        }
        return hasNonMDDSDefault;
    }

    public void dumpFormattedXMLQuery(XQETrace trace) {
        if (this.hasNonMDDSDefault()) {
            trace.beginElement(MDX_EDGE_DIMENSION_PROPERTIES, -1);
            for (String propertyNameOrg : this.mDimensionProperties) {
                if (RoleTypeEnum.isRSAPIDefault(propertyNameOrg)) continue;
                trace.beginElement("ci", -1);
                trace.attribute("type", "qs:property");
                if (propertyNameOrg.equals("DESCRIPTION")) {
                    trace.data(propertyNameOrg.toLowerCase());
                } else {
                    String propertyName = RoleTypeEnum.mdxToRsapi(propertyNameOrg);
                    trace.data(propertyName);
                }
                trace.endElement();
            }
            trace.endElement();
        }
    }

    public String dumpFormattedXMLQueryString() {
        XQETrace trace = new XQETrace();
        trace.setNodeIDGenerator(new XQEIDGenerator());
        trace.setTraceLevelAll();
        trace.setIndentString(" ");
        StringWriter stringWriter = new StringWriter();
        trace.addStream(stringWriter);
        this.dumpFormattedXMLQuery(trace);
        return stringWriter.toString();
    }
}

