/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXSetOperator;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.trace.XQETrace;
import java.util.Iterator;
import java.util.List;

public final class MDXExtract
extends AbstractMDXSetOperator {
    @Override
    public int getType() {
        return 1106;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1106) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append("EXTRACT");
        buffer.append("(");
        boolean isFirst = true;
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            childIterator.next().writeFormattedText(buffer);
        }
        buffer.append(")");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("extractSet", -1);
        trace.endElement();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        if (index == 0) {
            return new int[]{1021};
        }
        if (index > 0) {
            return new int[]{1072};
        }
        return new int[0];
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        MDXHierInfo result = new MDXHierInfo();
        MDXHierInfo setHierInfo = ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
        if (setHierInfo.getNumProjectedHierarchies() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidMDXExtractExpr);
        }
        int numberChildren = this.getNumberChildren();
        for (int i = 1; i < numberChildren; ++i) {
            MDXHierInfo hierInfo = ((AbstractMDXHierarchy)this.getChild(i)).getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() != 1 || !setHierInfo.projectsHierarchies(hierInfo)) {
                throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidMDXExtractExpr);
            }
            result.appendProjectedHierarchies(hierInfo);
        }
        return result;
    }

    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        MDXLevelInfo result = new MDXLevelInfo();
        MDXLevelInfo setLevelInfo = ((AbstractMDXSet)this.getChild(0)).getLevelInfo(hierarchy);
        if (setLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidMDXExtractExpr);
        }
        int numberChildren = this.getNumberChildren();
        for (int i = 1; i < numberChildren; ++i) {
            MDXHierInfo hierInfo = ((AbstractMDXHierarchy)this.getChild(i)).getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() != 1 || !setLevelInfo.getHierarchyInfo().projectsHierarchy(hierInfo.getProjectedHierarchy(0))) {
                throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidMDXExtractExpr);
            }
            result.appendProjectedHierarchy(setLevelInfo, hierInfo.getProjectedHierarchy(0));
        }
        return result;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 2;
    }

    @Override
    public boolean projectsDuplicates() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).projectsDuplicates();
    }

    @Override
    public boolean isHierarchized() {
        this.throwOnInvalidChildCategories();
        if (((AbstractMDXSet)this.getChild(0)).isHierarchized() || ((AbstractMDXSet)this.getChild(0)).projectsAtMostOneTuple()) {
            MDXHierInfo setHierInfo = ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
            int lastHierIndex = -1;
            int numberChildren = this.getNumberChildren();
            for (int i = 1; i < numberChildren; ++i) {
                MDXHierInfo hierInfo = ((AbstractMDXHierarchy)this.getChild(i)).getHierarchyInfo();
                if (hierInfo.getNumProjectedHierarchies() != 1 || !setHierInfo.projectsHierarchy(hierInfo.getProjectedHierarchy(0))) {
                    throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidMDXExtractExpr);
                }
                IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
                int index = setHierInfo.getProjectedHierarchyIndex(hierarchy);
                if (lastHierIndex != -1 && index <= lastHierIndex) {
                    return false;
                }
                lastHierIndex = index;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean projectsAtMostOneTuple() {
        this.throwOnInvalidChildCategories();
        if (((AbstractMDXSet)this.getChild(0)).projectsAtMostOneTuple()) {
            MDXHierInfo setHierInfo = ((AbstractMDXSet)this.getChild(0)).getHierarchyInfo();
            int numberChildren = this.getNumberChildren();
            for (int i = 1; i < numberChildren; ++i) {
                MDXHierInfo hierInfo = ((AbstractMDXHierarchy)this.getChild(i)).getHierarchyInfo();
                if (hierInfo.getNumProjectedHierarchies() == 1 && setHierInfo.projectsHierarchy(hierInfo.getProjectedHierarchy(0))) continue;
                throw new XQERuntimeException(XQEMessageKeys.MDX_InvalidMDXExtractExpr);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).isEmpty();
    }

    @Override
    public boolean couldResolveToEmptySet(boolean ignoreTags, boolean ignoreRaggedUnbalanced, boolean ignoreNonEmpty) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).couldResolveToEmptySet(ignoreTags, ignoreRaggedUnbalanced, ignoreNonEmpty);
    }

    @Override
    public boolean projectsOnlyAscendantsOrDescendantsOfCurrentMember(boolean ignoreCalculatedMembers) {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXSet)this.getChild(0)).projectsOnlyAscendantsOrDescendantsOfCurrentMember(true);
    }

    @Override
    public boolean projectsOnlyExplicitMembers(IHierarchy hierarchy) {
        return this.setChildProjectsOnlyExplicitMembers(0, hierarchy);
    }

    @Override
    public boolean projectsOnlyCalculatedMembers(IHierarchy hierarchy) {
        return this.setChildProjectsOnlyCalculatedMembers(0, hierarchy);
    }

    @Override
    public boolean areIntersectingProjDescendants(AbstractMDXNode node1, AbstractMDXNode node2) {
        return this.areIntersectingProjDescendantsOfFirstChild(node1, node2);
    }

    @Override
    protected void appendProjectedCalculatedMembers(List<MDXCalculatedMemberReference> calcMembers) {
        ((AbstractMDXSet)this.getChild(0)).appendProjectedCalculatedMembers(calcMembers);
    }

    @Override
    public boolean isRaggedUnbalancedCompensationApplicable() {
        this.throwInternalError("Unexpected use of this method.");
        return false;
    }
}

