/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import java.util.SortedMap;

public final class MDXFromCube
extends AbstractMDXNode {
    public static final String CUBE_NAME = "cubeName";
    public static final String EXTERNAL_CUBE_NAME = "externalCubeName";
    public static final String PROP_CUSTOM_ICUBE = "referencedCube";
    public static final String PROP_STRING_MODEL_PATH = "modelPath";
    public static final String PROP_VARIABLES_READ = "variablesRead";
    public static final String PROP_DATASOURCE = "dataSource";

    public MDXFromCube() {
        this.setHaveVariablesBeenRead(false);
    }

    public void bind(ICube cube) {
        this.setPropertyValue(PROP_CUSTOM_ICUBE, cube);
        IPlanningEnvironment planEnv = this.getPlanningEnvironment();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)planEnv.getExecutionEnvironment();
        if (executionEnvironment == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        this.getPlanningEnvironment().setCubeName(cube.getName());
        IDataSource ds = executionEnvironment.getOrAddDataSource(this.getCube());
        String cmDatasourceName = ds.getCMDataSourceName();
        if (MacroExpander.isMacro(cmDatasourceName)) {
            MacroExpander me = new MacroExpander();
            cmDatasourceName = me.expand(null, planEnv, cmDatasourceName);
            ds.setCMDataSourceName(cmDatasourceName);
        }
        this.setPropertyValue(PROP_DATASOURCE, ds);
    }

    public void bind(String modelPath) {
        this.setPropertyValue(PROP_STRING_MODEL_PATH, modelPath);
    }

    @Override
    public int getType() {
        return 1007;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1007) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setHaveVariablesBeenRead(boolean haveVariablesBeenRead) {
        this.setPropertyValue(PROP_VARIABLES_READ, haveVariablesBeenRead);
    }

    public boolean getHaveVariablesBeenRead() {
        return (Boolean)this.getPropertyValue(PROP_VARIABLES_READ);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        ICube cube = this.getCube();
        String cubeName = this.getCubeName(cube);
        boolean appendBrackets = false;
        if (!cubeName.startsWith("[")) {
            appendBrackets = true;
        }
        buffer.append("\n");
        buffer.append("FROM");
        buffer.append(" ");
        if (appendBrackets) {
            buffer.append("[");
        }
        buffer.append(cubeName);
        if (appendBrackets) {
            buffer.append("]");
        }
        buffer.append(" ");
    }

    private String getCubeName(ICube cube) {
        String cubeName = (String)this.getPropertyValue(EXTERNAL_CUBE_NAME);
        if (cubeName == null && cube != null && (cubeName = (String)cube.getProperty(EXTERNAL_CUBE_NAME)) == null) {
            cubeName = cube.getUniqueName();
        }
        if (cubeName == null) {
            cubeName = "ERROR";
        }
        return cubeName;
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        ICube cube = this.getCube();
        String cubeName = "ERROR";
        if (cube != null) {
            cubeName = cube.getName();
        }
        if (cube == null) {
            return;
        }
        if (cube.getModelDataSource().getCube() != null) {
            cubeName = cube.getModelDataSource().getCube().getUniqueName();
        }
        trace.beginElement("ci", -1);
        trace.attribute("type", "qs:cube");
        trace.data(cubeName);
        trace.endElement();
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        boolean status = false;
        if (this.getType() == node.getType() && this.getCube() == ((MDXFromCube)node).getCube()) {
            status = true;
        }
        return status;
    }

    @Override
    public int isValidPlannedQuery() {
        IXQEQueryNode parent;
        int status = this.getId();
        if (this.getNumberChildren() == 0 && (parent = this.getParent()) != null && parent.getType() == 1002) {
            status = -1;
        }
        return status;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[0];
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    public ICube getCube() {
        ICube cube = (ICube)this.getPropertyValue(PROP_CUSTOM_ICUBE);
        return cube;
    }

    public String getModel() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL_PATH);
    }

    public IDataSource getCMDataSource() {
        IDataSource dataSource = (IDataSource)this.getPropertyValue(PROP_DATASOURCE);
        if (dataSource == null) {
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)this.getPlanningEnvironment().getExecutionEnvironment();
            return executionEnvironment.getOrAddDataSource(this.getCube());
        }
        return dataSource;
    }

    public IModelDataSource getCubeDataSource() {
        return this.getCube().getModelDataSource();
    }

    public IMetadata getAlias() {
        return this.getCubeDataSource().getAlias();
    }

    public String getDataSourceType() {
        return this.getCubeDataSource().getInterface();
    }

    public boolean isProviderReturnDivByZeroCell() {
        IDataSource dataSource = this.getCMDataSource();
        return dataSource.getCapabilities().isSupported("result.return.divbyzero");
    }

    public boolean isProviderReturnOverflowCell() {
        IDataSource dataSource = this.getCMDataSource();
        return dataSource.getCapabilities().isSupported("result.return.overflow");
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        ICube cube = this.getCube();
        String cubeName = this.getCubeName(cube);
        propertiesMap.put(CUBE_NAME, cubeName);
        return propertiesMap;
    }
}

