/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.olap.AbstractMDXLevel;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.trace.XQETrace;

public final class MDXLevels
extends AbstractMDXLevel {
    @Override
    public int getType() {
        return 1066;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1066) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        this.getChild(0).writeFormattedText(buffer);
        buffer.append(".");
        buffer.append("LEVELS");
        buffer.append("(");
        this.getChild(1).writeFormattedText(buffer);
        buffer.append(")");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        trace.beginElement("apply", -1);
        trace.beginElement("levels", -1);
        trace.endElement();
        this.getChild(0).dumpFormattedXMLQuery(trace);
        this.getChild(1).dumpFormattedXMLQuery(trace);
        trace.endElement();
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        switch (index) {
            case 0: {
                categories = new int[]{1072};
                break;
            }
            case 1: {
                categories = new int[]{1062};
                break;
            }
            default: {
                categories = new int[]{};
            }
        }
        return categories;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        this.throwOnInvalidChildCategories();
        return ((AbstractMDXNode)this.getChild(0)).getHierarchyInfo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected MDXLevelInfo getLevelInfo(IHierarchy hierarchy) {
        this.throwOnInvalidChildCategories();
        MDXHierInfo mdxHierInfo = ((AbstractMDXNode)this.getChild(0)).getHierarchyInfo();
        IHierarchy projHierarchy = mdxHierInfo.getProjectedHierarchy(0);
        MDXLevelInfo mdxLevelInfo = new MDXLevelInfo();
        if (hierarchy != null && !hierarchy.equals(projHierarchy)) {
            return mdxLevelInfo;
        }
        if (this.getChild(1).getType() == 1064 && ((MDXNumericConstant)this.getChild(1)).getConstantValue() instanceof Integer) {
            int index = (Integer)((MDXNumericConstant)this.getChild(1)).getConstantValue();
            try {
                mdxLevelInfo.addProjectedHierarchy(projHierarchy, index);
                return mdxLevelInfo;
            }
            catch (XQERuntimeException e) {
                String errMsg = String.valueOf(e.getArguments()[0]);
                if (!errMsg.equals("The level index argument is invalid.")) return mdxLevelInfo;
                throw new XQERuntimeException(XQEMessageKeys.PLN_LevelIndexOutOfRange, (Throwable)e, (Object)String.valueOf(index), (Object)"LEVELS");
            }
        } else {
            mdxLevelInfo.addProjectedHierarchy(projHierarchy);
        }
        return mdxLevelInfo;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 2;
    }

    @Override
    public ILevel getLevel() {
        MDXLevelInfo mdxLevelInfo = this.getLevelInfo();
        if (mdxLevelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        IHierarchy hierarchy = mdxLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        return mdxLevelInfo.getHighestProjectedLevel(hierarchy);
    }

    @Override
    public ILevel getLowestReferencedLevel(IHierarchy hierarchy) {
        return this.getLevelInfo(hierarchy).getLowestProjectedLevel(hierarchy);
    }

    @Override
    public ILevel getHighestReferencedLevel(IHierarchy hierarchy) {
        return this.getLevelInfo(hierarchy).getHighestProjectedLevel(hierarchy);
    }
}

