/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.Iterator;
import java.util.List;

public class MDXNumericOperator
extends AbstractMDXNumericValueExpression {
    public static final String CUSTOM_PROPERTY_OPERATOR = "operator";
    public static final int NUM_OP_MINUS = 0;
    public static final int NUM_OP_PLUS = 1;
    public static final int NUM_OP_DIVIDE = 2;
    public static final int NUM_OP_MULTIPLY = 3;
    public static final int NUM_OP_UNARY_PLUS = 4;
    public static final int NUM_OP_UNARY_MINUS = 5;

    @Override
    public int getType() {
        return 1084;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1084) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setOperatorProperty(int value) {
        this.setPropertyValue(CUSTOM_PROPERTY_OPERATOR, XQEIntegerPool.getInteger(value));
    }

    public int getOperatorProperty() {
        return (Integer)this.getPropertyValue(CUSTOM_PROPERTY_OPERATOR);
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        if (this.getNumberChildren() == 2) {
            buffer.append("(");
            this.getChild(0).writeFormattedText(buffer);
            buffer.append(this.getMDXOperatorName());
            if (this.getOperatorProperty() == 2) {
                StringBuilder tempbuf = new StringBuilder();
                this.getChild(1).writeFormattedText(tempbuf);
                if (tempbuf.indexOf("(") == 0) {
                    buffer.append((CharSequence)tempbuf);
                } else {
                    buffer.append("(");
                    buffer.append((CharSequence)tempbuf);
                    buffer.append(")");
                }
            } else {
                this.getChild(1).writeFormattedText(buffer);
            }
            buffer.append(")");
        } else {
            buffer.append(this.getMDXOperatorName());
            this.getChild(0).writeFormattedText(buffer);
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        int operatorType = this.getOperatorProperty();
        trace.beginElement("apply", -1);
        if (operatorType != 4) {
            trace.beginElement(this.getMDOperatorName(), -1);
            trace.endElement();
        }
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            childIterator.next().dumpFormattedXMLQuery(trace);
        }
        trace.endElement();
    }

    public String getMDXOperatorName() {
        String mdxOperatorName = null;
        int operatorType = this.getOperatorProperty();
        switch (operatorType) {
            case 0: {
                mdxOperatorName = "-";
                break;
            }
            case 1: {
                mdxOperatorName = "+";
                break;
            }
            case 3: {
                mdxOperatorName = "*";
                break;
            }
            case 2: {
                mdxOperatorName = "/";
                break;
            }
            case 4: {
                mdxOperatorName = "+";
                break;
            }
            case 5: {
                mdxOperatorName = "-";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdxOperatorName;
    }

    private String getMDOperatorName() {
        String mdOperatorName = null;
        int operatorType = this.getOperatorProperty();
        switch (operatorType) {
            case 0: {
                mdOperatorName = "minus";
                break;
            }
            case 1: {
                mdOperatorName = "plus";
                break;
            }
            case 3: {
                mdOperatorName = "times";
                break;
            }
            case 2: {
                mdOperatorName = "divide";
                break;
            }
            case 4: {
                mdOperatorName = "plus";
                break;
            }
            case 5: {
                mdOperatorName = "minus";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
            }
        }
        return mdOperatorName;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 1;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        int[] categories = null;
        switch (index) {
            case 0: 
            case 1: {
                categories = new int[]{1061, 1089};
                break;
            }
            default: {
                categories = new int[]{};
            }
        }
        return categories;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("operatorName", this.getMDOperatorName());
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{CUSTOM_PROPERTY_OPERATOR};
    }

    @Override
    public AbstractMDXNumericValueExpression distributeCogMDXAggregate(CogMDXAggregate cogMDXAggregate, int aggrSolveOrder, List<AbstractMDXMember> contextMembers, IXQENodeFactory nodeFactory) {
        AbstractMDXNumericValueExpression newNumValExpr = null;
        IXQEQueryNode newOp1 = this.getChild(0);
        if (this.getChild(0).getType() != 1089) {
            newOp1 = ((AbstractMDXNumericValueExpression)this.getChild(0)).distributeCogMDXAggregate(cogMDXAggregate, aggrSolveOrder, contextMembers, nodeFactory);
        }
        IXQEQueryNode newOp2 = null;
        if (this.getOperatorProperty() != 5) {
            newOp2 = this.getChild(1);
            if (this.getChild(1).getType() != 1089) {
                newOp2 = ((AbstractMDXNumericValueExpression)this.getChild(1)).distributeCogMDXAggregate(cogMDXAggregate, aggrSolveOrder, contextMembers, nodeFactory);
            }
        }
        if (newOp1 != this.getChild(0) || newOp2 != null && newOp2 != this.getChild(1)) {
            newNumValExpr = (AbstractMDXNumericValueExpression)nodeFactory.deepCopyNode(this);
            newNumValExpr.exchangeChildNode(newNumValExpr.getChild(0), newOp1);
            if (this.getOperatorProperty() != 5) {
                newNumValExpr.exchangeChildNode(newNumValExpr.getChild(1), newOp2);
            }
        } else {
            newNumValExpr = (AbstractMDXNumericValueExpression)nodeFactory.deepCopyNode(this);
        }
        return newNumValExpr;
    }
}

