/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXStringValueExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQETrace;

public class MDXStringConstant
extends AbstractMDXStringValueExpression {
    public static final String PROPERTY_VALUE = "value";

    @Override
    public int getType() {
        return 1127;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1127) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setConstantValue(String value) {
        this.setPropertyValue(PROPERTY_VALUE, value);
    }

    public String getConstantValue() {
        return (String)this.getPropertyValue(PROPERTY_VALUE);
    }

    @Override
    public int isValidPlannedQuery() {
        int status = this.getId();
        if (this.getNumberChildren() == 0) {
            return -1;
        }
        return status;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[0];
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append("\"");
        String value = this.getPropertyValue(PROPERTY_VALUE).toString();
        value = value.replaceAll("\"", "\\\"\\\"");
        buffer.append(value);
        buffer.append("\"");
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        Object obj = this.getPropertyValue(PROPERTY_VALUE);
        trace.beginElement("cn", -1);
        if (!(obj instanceof String)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        trace.attribute("type", "xsd:string");
        trace.data(obj.toString());
        trace.endElement();
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this.getType() == node.getType() && this.getConstantValue().equals(((MDXStringConstant)node).getConstantValue())) {
            return super.isSameExpression(node, compareCalcDefiniton);
        }
        return false;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_VALUE};
    }

    @Override
    public boolean isLiteral() {
        return true;
    }
}

