/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.olap.IMDXSummaryFunctionTypeEnumConstants;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public enum MDXSummaryFunctionTypeEnum implements IMDXSummaryFunctionTypeEnumConstants
{
    UNDEFINED_SUMMARY_TYPE("undefined_aggregate_type"),
    AGGREGATE("AGGREGATE"),
    SUM("SUM"),
    MINIMUM("MIN"),
    MAXIMUM("MAX"),
    AVERAGE("AVG"),
    MEDIAN("MEDIAN"),
    STANDARD_DEVIATION("STDDEV"),
    STANDARD_DEVIATION_POPULATION("STDDEVP"),
    VARIANCE("VAR"),
    VARIANCE_POPULATION("VARP"),
    UDF("UDF");

    private final String mdxKeyword;

    private MDXSummaryFunctionTypeEnum(String aMdxKeyword) {
        this.mdxKeyword = aMdxKeyword;
    }

    public String getMDXKeyword() {
        return this.mdxKeyword;
    }

    public static MDXSummaryFunctionTypeEnum valueOfMDXKeyword(String name) {
        if (name == null || name.equals("")) {
            return UNDEFINED_SUMMARY_TYPE;
        }
        for (MDXSummaryFunctionTypeEnum e : MDXSummaryFunctionTypeEnum.values()) {
            if (!e.getMDXKeyword().equals(name)) continue;
            return e;
        }
        return UNDEFINED_SUMMARY_TYPE;
    }

    public static MDXSummaryFunctionTypeEnum convertRollupAggregateToMDXSummaryFunctionType(V5RollupAggregateEnum rollupAggregate) {
        MDXSummaryFunctionTypeEnum summaryType = UNDEFINED_SUMMARY_TYPE;
        switch (rollupAggregate) {
            case UNDEFINED: 
            case CALCULATED: {
                summaryType = AGGREGATE;
                break;
            }
            case TOTAL: {
                summaryType = SUM;
                break;
            }
            case NONE: {
                summaryType = MINIMUM;
                break;
            }
            case MINIMUM: {
                summaryType = MINIMUM;
                break;
            }
            case MAXIMUM: {
                summaryType = MAXIMUM;
                break;
            }
            case AVERAGE: {
                summaryType = AVERAGE;
                break;
            }
            case MEDIAN: {
                summaryType = MEDIAN;
                break;
            }
            case STANDARD_DEVIATION: {
                summaryType = STANDARD_DEVIATION;
                break;
            }
            case VARIANCE: {
                summaryType = VARIANCE;
                break;
            }
            case COUNT: {
                summaryType = UNDEFINED_SUMMARY_TYPE;
                break;
            }
            default: {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedRollUpAggregateInMDX, rollupAggregate.getName());
            }
        }
        return summaryType;
    }

    public static MDXSummaryFunctionTypeEnum convertV5SummaryFunctionTypeToMDXSummaryFunctionType(int v5SummaryFnType) {
        MDXSummaryFunctionTypeEnum summaryType = UNDEFINED_SUMMARY_TYPE;
        switch (v5SummaryFnType) {
            case 0: {
                summaryType = AGGREGATE;
                break;
            }
            case 1: {
                summaryType = AVERAGE;
                break;
            }
            case 4: {
                summaryType = MAXIMUM;
                break;
            }
            case 5: {
                summaryType = MEDIAN;
                break;
            }
            case 6: {
                summaryType = MINIMUM;
                break;
            }
            case 7: {
                summaryType = STANDARD_DEVIATION;
                break;
            }
            case 8: {
                summaryType = STANDARD_DEVIATION_POPULATION;
                break;
            }
            case 9: {
                summaryType = SUM;
                break;
            }
            case 10: {
                summaryType = VARIANCE;
                break;
            }
            case 11: {
                summaryType = VARIANCE_POPULATION;
                break;
            }
            case 43: {
                summaryType = UDF;
                break;
            }
            default: {
                summaryType = UNDEFINED_SUMMARY_TYPE;
            }
        }
        return summaryType;
    }

    public static MDXSummaryFunctionTypeEnum getSummaryFunctionType(AggregateTypeEnum aggregate) {
        if (aggregate == AggregateTypeEnum.AVG) {
            return AVERAGE;
        }
        if (aggregate == AggregateTypeEnum.MAX) {
            return MAXIMUM;
        }
        if (aggregate == AggregateTypeEnum.MIN) {
            return MINIMUM;
        }
        if (aggregate == AggregateTypeEnum.MEDIAN) {
            return MEDIAN;
        }
        if (aggregate == AggregateTypeEnum.STDDEV) {
            return STANDARD_DEVIATION;
        }
        if (aggregate == AggregateTypeEnum.SUM) {
            return SUM;
        }
        if (aggregate == AggregateTypeEnum.VAR) {
            return VARIANCE;
        }
        return AGGREGATE;
    }
}

