/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import java.util.List;

public class TNodeHeadCount
extends AbstractMDXNumericValueExpression {
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_CONVERTED = "converted";

    public TNodeHeadCount() {
        this.setConstantValue(1);
    }

    @Override
    public int getType() {
        return 1182;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 1182) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setConstantValue(Integer value) {
        this.setPropertyValue(PROPERTY_VALUE, value);
    }

    public Integer getConstantValue() {
        return (Integer)this.getPropertyValue(PROPERTY_VALUE);
    }

    public void setBeenConverted(boolean isConverted) {
        this.setPropertyValue(PROPERTY_CONVERTED, new Boolean(isConverted));
    }

    public boolean getIsConverted() {
        Boolean bConverted = this.getBooleanPropertyValue(PROPERTY_CONVERTED);
        if (bConverted == null) {
            return false;
        }
        return bConverted;
    }

    @Override
    public int isValidPlannedQuery() {
        int status = this.getId();
        if (this.getNumberChildren() == 0) {
            return -1;
        }
        return status;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[0];
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(this.getPropertyValue(PROPERTY_VALUE).toString());
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        Object obj = this.getPropertyValue(PROPERTY_VALUE);
        String type = null;
        trace.beginElement("cn", -1);
        if (obj instanceof Double) {
            type = "xsd:double";
        } else if (obj instanceof Integer || obj instanceof BigDecimal) {
            type = "xsd:integer";
        } else if (obj instanceof Long) {
            type = "xsd:long";
        } else {
            throw new XQERuntimeException(XQEMessageKeys.PLN_PlanFailed);
        }
        trace.attribute("type", type);
        trace.data(obj.toString());
        trace.endElement();
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this.getType() == node.getType() && this.getConstantValue().equals(((TNodeHeadCount)node).getConstantValue())) {
            return super.isSameExpression(node, compareCalcDefiniton);
        }
        return false;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROPERTY_VALUE};
    }

    @Override
    public boolean couldResolveToZero() {
        return this.getConstantValue() == null || !(this.getConstantValue() instanceof Integer) || this.getConstantValue() <= 0;
    }

    @Override
    public AbstractMDXNumericValueExpression distributeCogMDXAggregate(CogMDXAggregate cogMDXAggregate, int aggrSolveOrder, List<AbstractMDXMember> contextMembers, IXQENodeFactory nodeFactory) {
        return (AbstractMDXNumericValueExpression)nodeFactory.deepCopyNode(this);
    }

    @Override
    public boolean isLiteral() {
        return true;
    }
}

