/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap.util;

import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public final class MDXLevelInfo {
    protected MDXHierInfo hierInfo = new MDXHierInfo();
    protected Map<IHierarchy, List<LevelInfo>> projectedLevels = new HashMap<IHierarchy, List<LevelInfo>>();
    private static final String ERR_MSG_HIER_NOT_PROJ = "The hierarchy is not a projected hierarchy.";
    private static final String ERR_MSG_HIER_NOT_PROJ_BOTH_OBJS = "The hierarchy is not a projected in both MDXLevelInfo objects.";
    private static final String ERR_MSG_INVALID_LEVEL_ARG = "The level argument is invalid.";
    private static final String ERR_MSG_INVALID_LEVEL_LIST_ARG = "The level list argument is invalid.";
    private static final String ERR_MSG_INVALID_HIER_ARG = "The hierarchy argument is invalid.";
    private static final String ERR_MSG_HIER_ALREADY_PROJ = "The hierarchy already belongs to the projected hierarchy list.";
    public static final String ERR_MSG_INVALID_LEVEL_INDEX_ARG = "The level index argument is invalid.";

    public void addProjectedHierarchy(ILevel projectedLevel) {
        IHierarchy hierarchy;
        if (projectedLevel == null) {
            this.throwInternalError(ERR_MSG_INVALID_LEVEL_ARG);
        }
        if (this.projectedLevels.containsKey(hierarchy = projectedLevel.getHierarchy())) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        this.hierInfo.appendProjectedHierarchy(hierarchy);
        LinkedList<LevelInfo> projectedLevelList = new LinkedList<LevelInfo>();
        projectedLevelList.add(this.toLevelInfo(projectedLevel));
        this.projectedLevels.put(hierarchy, projectedLevelList);
    }

    public void addProjectedHierarchy(IHierarchy projectedHierarchy) {
        if (projectedHierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (this.projectedLevels.containsKey(projectedHierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        this.addProjectedHierarchy(projectedHierarchy, projectedHierarchy.getLevels());
    }

    public void addNewProjectedHierarchies(Set<IHierarchy> projectedHierarchies) {
        if (projectedHierarchies == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        for (IHierarchy projectedHierarchy : projectedHierarchies) {
            if (this.projectedLevels.containsKey(projectedHierarchy)) continue;
            this.addProjectedHierarchy(projectedHierarchy, projectedHierarchy.getLevels());
        }
    }

    public void addProjectedHierarchyNoLevels(IHierarchy projectedHierarchy) {
        if (projectedHierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (this.projectedLevels.containsKey(projectedHierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        this.hierInfo.appendProjectedHierarchy(projectedHierarchy);
        LinkedList projectedLevelList = new LinkedList();
        this.projectedLevels.put(projectedHierarchy, projectedLevelList);
    }

    public void addProjectedHierarchy(IHierarchy hierarchy, int index) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        if (index >= 0 && index < hierarchy.getLevels().size()) {
            this.addProjectedHierarchy(hierarchy.getLevels().get(index));
        } else {
            this.throwInternalError(ERR_MSG_INVALID_LEVEL_INDEX_ARG);
        }
    }

    private LevelInfo toLevelInfo(ILevel projectedLevel) {
        if (projectedLevel instanceof LevelInfo) {
            return (LevelInfo)projectedLevel;
        }
        return new LevelInfo(projectedLevel, true, false, false);
    }

    protected void addProjectedHierarchy(IHierarchy hierarchy, List<ILevel> projectedLevelList) {
        if (projectedLevelList == null) {
            this.throwInternalError(ERR_MSG_INVALID_LEVEL_LIST_ARG);
        }
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        this.hierInfo.appendProjectedHierarchy(hierarchy);
        LinkedList<LevelInfo> sortedProjectedLevels = new LinkedList<LevelInfo>();
        this.projectedLevels.put(hierarchy, sortedProjectedLevels);
        Iterator<ILevel> it = projectedLevelList.iterator();
        while (it.hasNext()) {
            this.insertAscendingByLevelNumber(sortedProjectedLevels, it.next());
        }
    }

    protected void addProjectedHierarchy(IHierarchy hierarchy, ILevel[] projectedLevel) {
        if (projectedLevel == null) {
            this.throwInternalError(ERR_MSG_INVALID_LEVEL_LIST_ARG);
        }
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        this.hierInfo.appendProjectedHierarchy(hierarchy);
        LinkedList<LevelInfo> sortedProjectedLevels = new LinkedList<LevelInfo>();
        this.projectedLevels.put(hierarchy, sortedProjectedLevels);
        for (int index = 0; index < projectedLevel.length; ++index) {
            this.insertAscendingByLevelNumber(sortedProjectedLevels, projectedLevel[index]);
        }
    }

    public void addProjectedLevels(List<ILevel> projectedLevelList) {
        IHierarchy hierarchy;
        if (projectedLevelList == null || projectedLevelList.isEmpty()) {
            this.throwInternalError(ERR_MSG_INVALID_LEVEL_LIST_ARG);
        }
        if (this.projectedLevels.containsKey(hierarchy = projectedLevelList.get(0).getHierarchy())) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        this.hierInfo.appendProjectedHierarchy(hierarchy);
        LinkedList<LevelInfo> sortedProjectedLevels = new LinkedList<LevelInfo>();
        this.projectedLevels.put(hierarchy, sortedProjectedLevels);
        for (ILevel level : projectedLevelList) {
            if (!hierarchy.equals(level.getHierarchy())) {
                this.throwInternalError(ERR_MSG_INVALID_LEVEL_LIST_ARG);
            }
            this.insertAscendingByLevelNumber(sortedProjectedLevels, level);
        }
    }

    public void addProjectedLevels(ILevel[] projectedLevelArray) {
        IHierarchy hierarchy;
        if (projectedLevelArray == null || projectedLevelArray.length == 0) {
            this.throwInternalError(ERR_MSG_INVALID_LEVEL_LIST_ARG);
        }
        if (this.projectedLevels.containsKey(hierarchy = projectedLevelArray[0].getHierarchy())) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        this.hierInfo.appendProjectedHierarchy(hierarchy);
        LinkedList<LevelInfo> sortedProjectedLevels = new LinkedList<LevelInfo>();
        this.projectedLevels.put(hierarchy, sortedProjectedLevels);
        for (int index = 0; index < projectedLevelArray.length; ++index) {
            if (!hierarchy.equals(projectedLevelArray[index].getHierarchy())) {
                this.throwInternalError(ERR_MSG_INVALID_LEVEL_LIST_ARG);
            }
            this.insertAscendingByLevelNumber(sortedProjectedLevels, projectedLevelArray[index]);
        }
    }

    public MDXLevelInfo duplicate() {
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        levelInfo.appendProjectedHierarchies(this);
        return levelInfo;
    }

    public void clearProjectedLevels() {
        for (IHierarchy hierarchy : this.projectedLevels.keySet()) {
            this.clearProjectedLevels(hierarchy);
        }
    }

    public void clearProjectedLevels(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ);
        }
        this.projectedLevels.get(hierarchy).clear();
    }

    protected void replaceProjectedLevels(IHierarchy hierarchy, List<LevelInfo> projectedLevelList) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        LinkedList<LevelInfo> newProjectedLevels = new LinkedList<LevelInfo>();
        this.projectedLevels.put(hierarchy, newProjectedLevels);
        for (ILevel iLevel : projectedLevelList) {
            newProjectedLevels.add(this.toLevelInfo(iLevel));
        }
    }

    public MDXHierInfo getHierarchyInfo() {
        return this.hierInfo;
    }

    public boolean isEmpty() {
        return !this.projectsLevels();
    }

    public void appendProjectedHierarchies(MDXLevelInfo mdxLevelInfo) {
        for (IHierarchy hierarchy : mdxLevelInfo.hierInfo.projectedHierarchies) {
            if (this.projectedLevels.containsKey(hierarchy)) {
                this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
            }
            List<ILevel> projectedLevelList = CollectionCast.upcast(mdxLevelInfo.projectedLevels.get(hierarchy), ILevel.class);
            this.addProjectedHierarchy(hierarchy, projectedLevelList);
        }
    }

    public void appendProjectedHierarchy(MDXLevelInfo mdxLevelInfo, IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_ALREADY_PROJ);
        }
        if (!mdxLevelInfo.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ);
        }
        List<ILevel> projectedLevelList = CollectionCast.upcast(mdxLevelInfo.projectedLevels.get(hierarchy), ILevel.class);
        this.addProjectedHierarchy(hierarchy, projectedLevelList);
    }

    public void appendNewProjectedHierarchies(MDXLevelInfo mdxLevelInfo) {
        for (IHierarchy hierarchy : mdxLevelInfo.hierInfo.projectedHierarchies) {
            if (this.projectedLevels.containsKey(hierarchy)) continue;
            this.addProjectedHierarchy(hierarchy, mdxLevelInfo.getProjectedLevels(hierarchy));
        }
    }

    public void unionProjectedLevels(MDXLevelInfo mdxLevelInfo, IHierarchy hierarchy) {
        if (mdxLevelInfo.isEmpty()) {
            return;
        }
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy) || !mdxLevelInfo.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ_BOTH_OBJS);
        }
        List<LevelInfo> projectedLevelList = this.projectedLevels.get(hierarchy);
        Iterator<LevelInfo> it = mdxLevelInfo.projectedLevels.get(hierarchy).iterator();
        while (it.hasNext()) {
            this.insertAscendingByLevelNumber(projectedLevelList, it.next());
        }
    }

    public void unionProjectedHierarchies(MDXLevelInfo mdxLevelInfo) {
        for (IHierarchy refHier : mdxLevelInfo.hierInfo.projectedHierarchies) {
            if (this.projectedLevels.containsKey(refHier)) {
                this.unionProjectedLevels(mdxLevelInfo, refHier);
                continue;
            }
            this.appendProjectedHierarchy(mdxLevelInfo, refHier);
        }
    }

    public void unionProjectedHierarchiesExceptCurrent(MDXLevelInfo mdxLevelInfo, IHierarchy currentHierarchy) {
        for (IHierarchy refHier : mdxLevelInfo.hierInfo.projectedHierarchies) {
            if (refHier == currentHierarchy) continue;
            if (this.projectedLevels.containsKey(refHier)) {
                this.unionProjectedLevels(mdxLevelInfo, refHier);
                continue;
            }
            List<ILevel> projectedLevelList = CollectionCast.upcast(mdxLevelInfo.projectedLevels.get(refHier), ILevel.class);
            this.addProjectedHierarchy(refHier, projectedLevelList);
        }
    }

    public void replaceProjectedLevels(MDXLevelInfo mdxLevelInfo, IHierarchy hierarchy) {
        if (!this.projectedLevels.containsKey(hierarchy) || !mdxLevelInfo.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ_BOTH_OBJS);
        }
        this.replaceProjectedLevels(hierarchy, mdxLevelInfo.projectedLevels.get(hierarchy));
    }

    public void replaceProjectedHierarchies(MDXLevelInfo mdxLevelInfo) {
        for (IHierarchy hierarchy : mdxLevelInfo.hierInfo.projectedHierarchies) {
            this.replaceProjectedHierarchy(mdxLevelInfo, hierarchy);
        }
    }

    public void replaceProjectedHierarchy(MDXLevelInfo mdxLevelInfo, IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            this.appendProjectedHierarchy(mdxLevelInfo, hierarchy);
        } else {
            this.replaceProjectedLevels(mdxLevelInfo, hierarchy);
        }
    }

    public void intersectProjectedLevels(MDXLevelInfo mdxLevelInfo) {
        if (!this.getHierarchyInfo().compareProjectedHierarchies(mdxLevelInfo.getHierarchyInfo())) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ_BOTH_OBJS);
        }
        if (this.isEmpty()) {
            return;
        }
        if (mdxLevelInfo.isEmpty()) {
            this.clearProjectedLevels();
            return;
        }
        for (IHierarchy hierarchy : mdxLevelInfo.hierInfo.projectedHierarchies) {
            this.intersectProjectedLevels(mdxLevelInfo, hierarchy);
        }
    }

    public void intersectProjectedLevels(MDXLevelInfo mdxLevelInfo, IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy) || !mdxLevelInfo.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ_BOTH_OBJS);
        }
        List<LevelInfo> projectedLevelList = this.projectedLevels.get(hierarchy);
        List<LevelInfo> projectedLevelList1 = mdxLevelInfo.projectedLevels.get(hierarchy);
        LinkedList<LevelInfo> intersectLevels = new LinkedList<LevelInfo>();
        for (int i = 0; i < projectedLevelList.size(); ++i) {
            LevelInfo info = projectedLevelList.get(i);
            int idx = projectedLevelList1.indexOf(info);
            if (idx == -1) continue;
            LevelInfo info1 = projectedLevelList1.get(idx);
            info.updateFlags(info1);
            intersectLevels.add(info);
        }
        projectedLevelList.clear();
        projectedLevelList.addAll(intersectLevels);
    }

    public void reduceToProjectedHierarchy(int index) {
        IHierarchy projectedHierarchy = null;
        if (index >= 0 && index < this.hierInfo.getNumProjectedHierarchies()) {
            projectedHierarchy = this.hierInfo.getProjectedHierarchy(index);
        }
        int i = 0;
        while (i < this.hierInfo.projectedHierarchies.size()) {
            IHierarchy hierarchy = this.hierInfo.projectedHierarchies.get(i);
            if (projectedHierarchy == null || !projectedHierarchy.equals(hierarchy)) {
                this.projectedLevels.remove(hierarchy);
                this.hierInfo.projectedHierarchies.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void insertAscendingByLevelNumber(List<LevelInfo> levelList, ILevel level) {
        LevelInfo info = this.toLevelInfo(level);
        int idx = levelList.indexOf(info);
        if (idx != -1) {
            levelList.get(idx).updateFlags(info);
        } else {
            ListIterator<LevelInfo> it = levelList.listIterator();
            while (it.hasNext()) {
                if (it.next().mLevel.getIndex() <= info.mLevel.getIndex()) continue;
                it.previous();
                break;
            }
            it.add(info);
        }
    }

    public int getNumProjectedLevels(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            return 0;
        }
        return this.projectedLevels.get(hierarchy).size();
    }

    public ILevel getProjectedLevel(IHierarchy hierarchy, int index) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy) || this.projectedLevels.get(hierarchy).isEmpty()) {
            return null;
        }
        return this.projectedLevels.get(hierarchy).get(index);
    }

    public List<ILevel> getProjectedLevels(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ);
        }
        return CollectionCast.upcast(Collections.unmodifiableList(this.projectedLevels.get(hierarchy)), ILevel.class);
    }

    public List<ILevel> getProjectedLevelsSkipCalculation(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ);
        }
        LinkedList<LevelInfo> projectedLevelListSkipCalc = new LinkedList<LevelInfo>();
        List<LevelInfo> projectedLevelList = this.projectedLevels.get(hierarchy);
        for (int i = 0; i < projectedLevelList.size(); ++i) {
            if (!projectedLevelList.get(i).hasNonCalculation()) continue;
            projectedLevelListSkipCalc.add(projectedLevelList.get(i));
        }
        return CollectionCast.upcast(projectedLevelListSkipCalc, ILevel.class);
    }

    public ILevel getLowestProjectedLevelsSkipCalculation(IHierarchy hierarchy) {
        List<ILevel> levels = this.getProjectedLevelsSkipCalculation(hierarchy);
        if (levels.isEmpty()) {
            return null;
        }
        return levels.get(levels.size() - 1);
    }

    public void removeCalculationLevels(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            return;
        }
        List<LevelInfo> projectedLevelList = this.projectedLevels.get(hierarchy);
        for (int i = 0; i < projectedLevelList.size(); ++i) {
            if (projectedLevelList.get(i).hasNonCalculation()) continue;
            projectedLevelList.remove(i);
            return;
        }
    }

    public void removeCalculationLevels() {
        for (IHierarchy hierarchy : this.getHierarchyInfo().getProjectedHierarchies()) {
            this.removeCalculationLevels(hierarchy);
        }
    }

    public void removeNoMemberLevels(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            return;
        }
        List<LevelInfo> projectedLevelList = this.projectedLevels.get(hierarchy);
        for (int i = 0; i < projectedLevelList.size(); ++i) {
            if (!projectedLevelList.get(i).isFromNoMember()) continue;
            projectedLevelList.remove(i);
            return;
        }
    }

    public void removeNoMemberLevels() {
        for (IHierarchy hierarchy : this.getHierarchyInfo().getProjectedHierarchies()) {
            this.removeNoMemberLevels(hierarchy);
        }
    }

    public ILevel getHighestProjectedLevel(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            return null;
        }
        List<LevelInfo> projectedLevelList = this.projectedLevels.get(hierarchy);
        if (projectedLevelList.size() > 0) {
            return projectedLevelList.get(0);
        }
        return null;
    }

    public ILevel getLowestProjectedLevel(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            return null;
        }
        List<LevelInfo> projectedLevelList = this.projectedLevels.get(hierarchy);
        if (projectedLevelList.size() > 0) {
            return projectedLevelList.get(projectedLevelList.size() - 1);
        }
        return null;
    }

    public boolean projectsLevel(ILevel level) {
        List<LevelInfo> projectedLevelList;
        IHierarchy hierarchy;
        if (level == null) {
            this.throwInternalError(ERR_MSG_INVALID_LEVEL_ARG);
        }
        if ((hierarchy = level.getHierarchy()) == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        return this.projectedLevels.containsKey(hierarchy) && (projectedLevelList = this.projectedLevels.get(hierarchy)).contains(level);
    }

    public boolean compareProjectedLevels(MDXLevelInfo mdxLevelInfo) {
        Set<IHierarchy> keySet2;
        if (this.projectedLevels.size() != mdxLevelInfo.projectedLevels.size()) {
            return false;
        }
        Set<IHierarchy> keySet1 = this.projectedLevels.keySet();
        if (!keySet1.equals(keySet2 = mdxLevelInfo.projectedLevels.keySet())) {
            return false;
        }
        Iterator<IHierarchy> it = keySet1.iterator();
        while (it.hasNext()) {
            if (this.compareProjectedLevels(mdxLevelInfo, it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean compareProjectedLevels(MDXLevelInfo mdxLevelInfo, IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy) || !mdxLevelInfo.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ_BOTH_OBJS);
        }
        return this.projectedLevels.get(hierarchy).equals(mdxLevelInfo.projectedLevels.get(hierarchy));
    }

    public boolean projectedLevelsOverlap(MDXLevelInfo mdxLevelInfo) {
        Set<IHierarchy> hierarchies = this.projectedLevels.keySet();
        Iterator<IHierarchy> it = hierarchies.iterator();
        while (it.hasNext()) {
            if (!this.projectedLevelsOverlap(mdxLevelInfo, it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean projectedLevelsOverlap(MDXLevelInfo mdxLevelInfo, IHierarchy hierarchy) {
        if (!this.projectedLevels.containsKey(hierarchy) || !mdxLevelInfo.projectedLevels.containsKey(hierarchy)) {
            return false;
        }
        List<LevelInfo> projectedLevelList = this.projectedLevels.get(hierarchy);
        if (projectedLevelList.size() == 0) {
            return false;
        }
        Iterator<LevelInfo> it = this.projectedLevels.get(hierarchy).iterator();
        while (it.hasNext()) {
            if (!mdxLevelInfo.projectsLevel(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isLowestLevelProj(IHierarchy hierarchy) {
        if (this.projectedLevels.containsKey(hierarchy)) {
            int lowestLevelIdx;
            ILevel lowestLevelProj = this.getLowestProjectedLevel(hierarchy);
            if (lowestLevelProj == null) {
                return false;
            }
            int lowestLevelProjIdx = lowestLevelProj.getIndex();
            if (lowestLevelProjIdx == (lowestLevelIdx = hierarchy.getLevelCount() - 1)) {
                return true;
            }
        }
        return false;
    }

    public boolean projectsLevels() {
        boolean foundLevels = false;
        for (IHierarchy hierarchy : this.projectedLevels.keySet()) {
            if (this.projectedLevels.get(hierarchy).size() == 0) {
                return false;
            }
            foundLevels = true;
        }
        return foundLevels;
    }

    public void adjustProjectedLevelsByOffset(IHierarchy hierarchy, int levelOffset) {
        List<LevelInfo> levelList;
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ);
        }
        if ((levelList = this.projectedLevels.get(hierarchy)).size() == 0) {
            return;
        }
        if (hierarchy.isRagged()) {
            this.adjustProjectedLevelsByOffsetRagged(hierarchy, levelOffset);
        } else if (levelOffset != 0) {
            LinkedList<LevelInfo> newLevelList = new LinkedList<LevelInfo>();
            for (LevelInfo levelInfo : levelList) {
                int newLevelIndex = levelInfo.getIndex() + levelOffset;
                if (newLevelIndex < 0 || newLevelIndex >= hierarchy.getLevelCount()) continue;
                LevelInfo newLevelInfo = this.toLevelInfo(hierarchy.getLevel(newLevelIndex));
                newLevelList.add(newLevelInfo);
            }
            this.replaceProjectedLevels(hierarchy, newLevelList);
        }
    }

    private void adjustProjectedLevelsByOffsetRagged(IHierarchy hierarchy, int levelOffset) {
        List<LevelInfo> levelList = this.projectedLevels.get(hierarchy);
        LinkedList<LevelInfo> newLevelList = new LinkedList<LevelInfo>();
        if (levelOffset >= 0) {
            int levelIndex = levelList.get(0).getIndex();
            for (ILevel level : hierarchy.getLevels()) {
                if (level.getIndex() < levelIndex + levelOffset) continue;
                newLevelList.add(this.toLevelInfo(level));
            }
        } else {
            int levelIndex = levelList.get(levelList.size() - 1).getIndex();
            for (ILevel level : hierarchy.getLevels()) {
                if (level.getIndex() > levelIndex + levelOffset) continue;
                newLevelList.add(this.toLevelInfo(level));
            }
        }
        this.replaceProjectedLevels(hierarchy, newLevelList);
    }

    public void adjustProjectedLevelsToAscendants(IHierarchy hierarchy) {
        if (hierarchy == null) {
            this.throwInternalError(ERR_MSG_INVALID_HIER_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy)) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ);
        }
        if (this.getNumProjectedLevels(hierarchy) == 0) {
            return;
        }
        ILevel lowestLevel = this.getLowestProjectedLevel(hierarchy);
        LinkedList<LevelInfo> newLevelList = new LinkedList<LevelInfo>();
        for (ILevel level : hierarchy.getLevels()) {
            if (level.getIndex() > lowestLevel.getIndex()) continue;
            newLevelList.add(this.toLevelInfo(level));
        }
        this.replaceProjectedLevels(hierarchy, newLevelList);
    }

    public void adjustProjectedLevelsToLevel(ILevel level) {
        IHierarchy hierarchy;
        if (level == null) {
            this.throwInternalError(ERR_MSG_INVALID_LEVEL_ARG);
        }
        if (!this.projectedLevels.containsKey(hierarchy = level.getHierarchy())) {
            this.throwInternalError(ERR_MSG_HIER_NOT_PROJ);
        }
        if (this.getNumProjectedLevels(hierarchy) == 0) {
            return;
        }
        LevelInfo levelInfo = null;
        for (LevelInfo projectedLevelInfo : this.projectedLevels.get(hierarchy)) {
            if (projectedLevelInfo.compareTo(level) != 0) continue;
            levelInfo = projectedLevelInfo;
            break;
        }
        boolean returnLevel = false;
        ILevel lowestLevel = this.getLowestProjectedLevel(hierarchy);
        if (lowestLevel.getIndex() >= level.getIndex()) {
            returnLevel = true;
        }
        this.clearProjectedLevels(hierarchy);
        if (returnLevel) {
            if (levelInfo == null) {
                levelInfo = this.toLevelInfo(level);
            }
            this.projectedLevels.get(hierarchy).add(levelInfo);
        }
    }

    public void throwInternalError(String errMsg) {
        throw new XQERuntimeException(XQEMessageKeys.PLN_MDXLevelInfoInternalError_INTERNAL, errMsg);
    }

    public final class LevelInfo
    implements ILevel {
        private ILevel mLevel;
        private boolean mbCubeMember = true;
        private boolean mbCalculatedMember = false;
        private boolean mbNoMember = false;

        @Override
        public String getName() {
            return this.mLevel.getName();
        }

        @Override
        public String getUniqueName() {
            return this.mLevel.getUniqueName();
        }

        @Override
        public Set<String> getAvailableProperties() {
            return this.mLevel.getAvailableProperties();
        }

        @Override
        public Object getProperty(String propertyName) {
            return this.mLevel.getProperty(propertyName);
        }

        @Override
        public IDataType getDataType() {
            return this.mLevel.getDataType();
        }

        @Override
        public MetadataConnection getConnection() {
            return this.mLevel.getConnection();
        }

        @Override
        public IMetadata getParentObject() {
            return this.mLevel.getParentObject();
        }

        @Override
        public List<IMetadata> getChildMetadataObjects() {
            return this.mLevel.getChildMetadataObjects();
        }

        @Override
        public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
            return this.mLevel.getDescendantMetadataObjectsSkipFolders();
        }

        @Override
        public MetadataType getObjectType() {
            return this.mLevel.getObjectType();
        }

        @Override
        public String getV5UniqueName() {
            return this.mLevel.getV5UniqueName();
        }

        @Override
        public String getID() {
            return this.mLevel.getID();
        }

        @Override
        public boolean hasChildMetadataObjects() {
            return this.mLevel.hasChildMetadataObjects();
        }

        @Override
        public String getDescription() {
            return this.mLevel.getDescription();
        }

        @Override
        public String getScreenTip() {
            return this.mLevel.getScreenTip();
        }

        @Override
        public String getUniqueID() {
            return this.mLevel.getUniqueID();
        }

        @Override
        public String getCaption() {
            return this.mLevel.getCaption();
        }

        @Override
        public BeanPropertySupport getBeanPropertySupport() {
            return this.mLevel.getBeanPropertySupport();
        }

        @Override
        public int compareTo(Object other) {
            if (other instanceof LevelInfo) {
                return this.mLevel.compareTo(((LevelInfo)other).mLevel);
            }
            return this.mLevel.compareTo(other);
        }

        @Override
        public IMember getMember(String memberUniqueName) {
            return this.mLevel.getMember(memberUniqueName);
        }

        @Override
        public List<IMember> getMembers() {
            return this.mLevel.getMembers();
        }

        @Override
        public List<IMember> getMembers(int startIndex, int count) {
            return this.mLevel.getMembers(startIndex, count);
        }

        @Override
        public IHierarchy getHierarchy() {
            return this.mLevel.getHierarchy();
        }

        @Override
        public ILevel getPreviousLevel() {
            return this.mLevel.getPreviousLevel();
        }

        @Override
        public ILevel getNextLevel() {
            return this.mLevel.getNextLevel();
        }

        @Override
        public boolean isLeafLevel() {
            return this.mLevel.isLeafLevel();
        }

        @Override
        public boolean isRootLevel() {
            return this.mLevel.isRootLevel();
        }

        @Override
        public int getCardinality() {
            return this.mLevel.getCardinality();
        }

        @Override
        public List<IProperty> getMemberProperties() {
            return this.mLevel.getMemberProperties();
        }

        @Override
        public int getIndex() {
            return this.mLevel.getIndex();
        }

        @Override
        public IDimension getDimension() {
            return this.mLevel.getDimension();
        }

        @Override
        public IProperty getMemberProperty(String name) {
            return this.mLevel.getMemberProperty(name);
        }

        @Override
        public boolean isUnique() {
            return this.mLevel.isUnique();
        }

        @Override
        public double getOrderOfMagnitude() {
            return this.mLevel.getOrderOfMagnitude();
        }

        @Override
        public boolean isAutoGenerated() {
            return this.mLevel.isAutoGenerated();
        }

        public LevelInfo(ILevel level, boolean isCube, boolean isCalc, boolean isNoMember) {
            this.mLevel = level;
            this.mbCubeMember = isCube;
            this.mbCalculatedMember = isCalc;
            this.mbNoMember = isNoMember;
        }

        public ILevel getLevel() {
            return this.mLevel;
        }

        public boolean isFromCube() {
            return this.mbCubeMember;
        }

        public boolean isFromCalculation() {
            return this.mbCalculatedMember;
        }

        public boolean isFromNoMember() {
            return this.mbNoMember;
        }

        public boolean hasNonCalculation() {
            boolean result = this.isFromCube();
            if (!result && this.isFromNoMember()) {
                result = true;
            }
            return result;
        }

        public boolean equals(Object other) {
            if (other instanceof LevelInfo) {
                return this.mLevel.equals(((LevelInfo)other).mLevel);
            }
            return this.mLevel.equals(other);
        }

        public int hashCode() {
            return this.mLevel.hashCode();
        }

        protected void updateFlags(LevelInfo other) {
            if (!this.isFromCube() && other.isFromCube()) {
                this.mbCubeMember = true;
            }
            if (!this.isFromCalculation() && other.isFromCalculation()) {
                this.mbCalculatedMember = true;
            }
            if (!this.isFromNoMember() && other.isFromNoMember()) {
                this.mbNoMember = true;
            }
        }

        public String toString() {
            return this.mLevel.toString();
        }

        @Override
        public ISortItem[] getSortItems() {
            return this.mLevel.getSortItems();
        }

        @Override
        public boolean isDMR() {
            return false;
        }

        @Override
        public boolean isMFW() {
            return false;
        }

        @Override
        public IMetadata getParentObjectSkipFolders() {
            return null;
        }

        @Override
        public boolean isAccessible() {
            return false;
        }

        @Override
        public void setParentMetadataObject(IMetadata parent) {
        }

        @Override
        public IMultiRequestHandle[] getHandles() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public boolean isVisible(boolean inShortcut) {
            return false;
        }
    }
}

