/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap.util;

import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MDXLevelInfoCache {
    private Map<Integer, Map<IHierarchy, MDXLevelInfo>> levelInfoCache = new HashMap<Integer, Map<IHierarchy, MDXLevelInfo>>();
    private Map<Integer, Map<IHierarchy, MDXLevelInfo>> contextLevelInfoCache = new HashMap<Integer, Map<IHierarchy, MDXLevelInfo>>();
    private Map<Integer, Map<IHierarchy, Set<MDXLevelInfo>>> valueExpLevelInfoCache = new HashMap<Integer, Map<IHierarchy, Set<MDXLevelInfo>>>();
    private int lastNodeIDGenerated = 0;
    private Map<Integer, List<IHierarchy>> nestedCalcs = new HashMap<Integer, List<IHierarchy>>();
    private Set<MDXCalculatedMemberDefinition> nestedCalcNodes = new HashSet<MDXCalculatedMemberDefinition>();
    private PlanningEnvironment env = null;

    public MDXLevelInfoCache(PlanningEnvironment environment) {
        this.env = environment;
    }

    public void reset() {
        this.levelInfoCache.clear();
        this.valueExpLevelInfoCache.clear();
        this.contextLevelInfoCache.clear();
        this.lastNodeIDGenerated = this.env.getNodeFactory().getLastNodeIDGenerated();
        this.nestedCalcs.clear();
        this.nestedCalcNodes.clear();
    }

    public boolean treeModified() {
        return this.lastNodeIDGenerated < this.env.getNodeFactory().getLastNodeIDGenerated();
    }

    public MDXLevelInfo getLevelInfoCache(AbstractMDXNode node, IHierarchy hierarchy) {
        Map<IHierarchy, MDXLevelInfo> hierToLevelInfo;
        if (this.treeModified()) {
            this.reset();
        }
        if ((hierToLevelInfo = this.levelInfoCache.get(node.getId())) != null) {
            MDXLevelInfo levelInfo = hierToLevelInfo.get(hierarchy);
            if (levelInfo != null) {
                return levelInfo.duplicate();
            }
            if (hierToLevelInfo.containsKey(hierarchy)) {
                return new MDXLevelInfo();
            }
        }
        return null;
    }

    public void addLevelInfoCache(AbstractMDXNode node, IHierarchy hierarchy, MDXLevelInfo levelInfo) {
        Map<IHierarchy, MDXLevelInfo> hierToLevelInfo = this.levelInfoCache.get(node.getId());
        if (hierToLevelInfo == null) {
            hierToLevelInfo = new HashMap<IHierarchy, MDXLevelInfo>();
            this.levelInfoCache.put(node.getId(), hierToLevelInfo);
        }
        if (levelInfo == null) {
            hierToLevelInfo.put(hierarchy, null);
        } else {
            hierToLevelInfo.put(hierarchy, levelInfo.duplicate());
        }
    }

    public Set<MDXLevelInfo> getVELevelInfoCache(AbstractMDXNode node, IHierarchy hierarchy) {
        Set<MDXLevelInfo> levelInfo;
        Map<IHierarchy, Set<MDXLevelInfo>> hierToLevelInfo;
        if (this.treeModified()) {
            this.reset();
        }
        if ((hierToLevelInfo = this.valueExpLevelInfoCache.get(node.getId())) != null && (levelInfo = hierToLevelInfo.get(hierarchy)) != null) {
            LinkedHashSet<MDXLevelInfo> dupLevelInfo = new LinkedHashSet<MDXLevelInfo>();
            Iterator<MDXLevelInfo> it = levelInfo.iterator();
            while (it.hasNext()) {
                dupLevelInfo.add(it.next().duplicate());
            }
            return dupLevelInfo;
        }
        return null;
    }

    public void addVELevelInfoCache(AbstractMDXNode node, IHierarchy hierarchy, Set<MDXLevelInfo> levelInfo) {
        if (node == null || levelInfo == null) {
            throw new IllegalArgumentException();
        }
        Map<IHierarchy, Set<MDXLevelInfo>> hierToLevelInfo = this.valueExpLevelInfoCache.get(node.getId());
        if (hierToLevelInfo == null) {
            hierToLevelInfo = new HashMap<IHierarchy, Set<MDXLevelInfo>>();
            this.valueExpLevelInfoCache.put(node.getId(), hierToLevelInfo);
        }
        LinkedHashSet<MDXLevelInfo> dupLevelInfo = new LinkedHashSet<MDXLevelInfo>();
        Iterator<MDXLevelInfo> it = levelInfo.iterator();
        while (it.hasNext()) {
            dupLevelInfo.add(it.next().duplicate());
        }
        hierToLevelInfo.put(hierarchy, dupLevelInfo);
    }

    public MDXLevelInfo getCalcMemContextLevelInfoCache(AbstractMDXNode node, IHierarchy hierarchy) {
        MDXLevelInfo levelInfo;
        Integer nodeId;
        Map<IHierarchy, MDXLevelInfo> hierToLevelInfo;
        if (this.treeModified()) {
            this.reset();
        }
        if ((hierToLevelInfo = this.contextLevelInfoCache.get(nodeId = node.getId())) != null && (levelInfo = hierToLevelInfo.get(hierarchy)) != null) {
            return levelInfo.duplicate();
        }
        if (this.nestedCalcs.containsKey(nodeId) && this.nestedCalcs.get(nodeId).contains(hierarchy)) {
            return new MDXLevelInfo();
        }
        return null;
    }

    public void addCalcMemContextLevelInfoCache(AbstractMDXNode node, IHierarchy hierarchy, MDXLevelInfo levelInfo) {
        Map<IHierarchy, MDXLevelInfo> hierToLevelInfo = this.contextLevelInfoCache.get(node.getId());
        if (hierToLevelInfo == null) {
            hierToLevelInfo = new HashMap<IHierarchy, MDXLevelInfo>();
            this.contextLevelInfoCache.put(node.getId(), hierToLevelInfo);
        }
        if (levelInfo == null) {
            hierToLevelInfo.put(hierarchy, null);
        } else {
            hierToLevelInfo.put(hierarchy, levelInfo.duplicate());
        }
    }

    public void addNestedCalculation(MDXCalculatedMemberDefinition calc, IHierarchy hierarchy) {
        List<IHierarchy> hierarchies = this.nestedCalcs.get(calc.getId());
        if (hierarchies == null) {
            hierarchies = new ArrayList<IHierarchy>();
        }
        hierarchies.add(hierarchy);
        this.nestedCalcs.put(calc.getId(), hierarchies);
        this.nestedCalcNodes.add(calc);
    }

    public void removeNestedCalculation(MDXCalculatedMemberDefinition calc, IHierarchy hierarchy) {
        List<IHierarchy> hierarchies = this.nestedCalcs.get(calc.getId());
        hierarchies.remove(hierarchy);
        if (hierarchies.isEmpty()) {
            this.nestedCalcs.remove(calc.getId());
            this.nestedCalcNodes.remove(calc);
        }
    }

    public final Set<MDXCalculatedMemberDefinition> getNestedCalculation() {
        return this.nestedCalcNodes;
    }

    public void clearNestedCalcNodes() {
        this.nestedCalcNodes.clear();
    }
}

