/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap.util;

import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MDXOOMInfo {
    protected static final int NUMBER_TEN = 10;
    protected final double numberOfMembers;
    protected final Map<ILevel, Double> numberOfMembersPerLevel;

    public Double getOOM() {
        return (double)MDXOOMInfo.getOOMFromNumber(this.numberOfMembers);
    }

    public Map<ILevel, Double> getNumberOfMembersPerLevel() {
        return this.numberOfMembersPerLevel;
    }

    protected MDXOOMInfo(double n, Map<ILevel, Double> mp) {
        this.numberOfMembers = n;
        this.numberOfMembersPerLevel = mp;
    }

    public static MDXOOMInfo unkownOOM() {
        return new MDXOOMInfo(0.0, null);
    }

    public static MDXOOMInfo oneMemberFromLevel(ILevel lvl) {
        HashMap<ILevel, Double> mp = null;
        if (lvl != null) {
            mp = new HashMap<ILevel, Double>();
            mp.put(lvl, 1.0);
        }
        return new MDXOOMInfo(1.0, mp);
    }

    public static MDXOOMInfo createOOMInfo(double n, Map<ILevel, Double> mp) {
        return new MDXOOMInfo(n, mp);
    }

    public static MDXOOMInfo crossjoinSet(MDXOOMInfo oom1, MDXOOMInfo oom2, boolean isGenerate) {
        if (Double.compare(oom1.numberOfMembers, 0.0) == 0) {
            return oom2;
        }
        if (Double.compare(oom2.numberOfMembers, 0.0) == 0) {
            return oom1;
        }
        double n = oom1.numberOfMembers * oom2.numberOfMembers;
        HashMap<ILevel, Double> mp = null;
        if (isGenerate && oom2.numberOfMembersPerLevel != null) {
            mp = new HashMap<ILevel, Double>();
            for (Map.Entry<ILevel, Double> e : oom2.numberOfMembersPerLevel.entrySet()) {
                mp.put(e.getKey(), oom1.numberOfMembers * e.getValue());
            }
        }
        return new MDXOOMInfo(n, mp);
    }

    public static MDXOOMInfo unionSet(MDXOOMInfo oom1, MDXOOMInfo oom2) {
        double nl;
        if (Double.compare(oom1.numberOfMembers, 0.0) == 0) {
            return oom2;
        }
        if (Double.compare(oom2.numberOfMembers, 0.0) == 0) {
            return oom1;
        }
        double n = oom1.numberOfMembers + oom2.numberOfMembers;
        HashMap<ILevel, Double> mp = null;
        if (oom1.numberOfMembersPerLevel != null) {
            mp = new HashMap<ILevel, Double>();
            for (Map.Entry<ILevel, Double> e : oom1.numberOfMembersPerLevel.entrySet()) {
                nl = e.getValue();
                if (mp.containsKey(e.getKey())) {
                    nl += mp.get(e.getKey()).doubleValue();
                }
                mp.put(e.getKey(), nl);
            }
        }
        if (oom2.numberOfMembersPerLevel != null) {
            if (mp == null) {
                mp = new HashMap();
            }
            for (Map.Entry<ILevel, Double> e : oom2.numberOfMembersPerLevel.entrySet()) {
                nl = e.getValue();
                if (mp.containsKey(e.getKey())) {
                    nl += mp.get(e.getKey()).doubleValue();
                }
                mp.put(e.getKey(), nl);
            }
        }
        return new MDXOOMInfo(n, mp);
    }

    public static double getNumberFromOOM(Double oom) {
        return Math.pow(10.0, oom);
    }

    public static Double getOOMFromNumber(double n) {
        return Math.log10(n);
    }

    public static MDXOOMInfo createOOMInfoDescendants(MDXOOMContext context, MDXLevelInfo levelInfo, MDXOOMInfo oom1) {
        if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            return MDXOOMInfo.unkownOOM();
        }
        Map<ILevel, Double> mpContext = oom1.getNumberOfMembersPerLevel();
        if (mpContext == null) {
            return MDXOOMInfo.unkownOOM();
        }
        HashMap<ILevel, Double> mp = new HashMap<ILevel, Double>();
        IHierarchy hier = levelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        List<ILevel> levels = levelInfo.getProjectedLevels(hier);
        double n = 0.0;
        for (Map.Entry<ILevel, Double> e : mpContext.entrySet()) {
            ILevel cl = e.getKey();
            if (!hier.equals(cl.getHierarchy())) {
                return MDXOOMInfo.unkownOOM();
            }
            for (ILevel level : levels) {
                if (!MDXOOMInfo.isHigherLevel(cl, level)) continue;
                double numOfMembers = MDXOOMInfo.computeNumberOfMembersFromParentLevelToTheLevel(e.getValue(), cl, level);
                n += numOfMembers;
                if (mp.containsKey(level)) {
                    numOfMembers += mp.get(level).doubleValue();
                }
                mp.put(level, numOfMembers);
            }
        }
        return MDXOOMInfo.createOOMInfo(n, mp);
    }

    protected static boolean isHigherLevel(ILevel cl, ILevel level) {
        for (ILevel pre = level.getPreviousLevel(); pre != null; pre = pre.getPreviousLevel()) {
            if (!pre.equals(cl)) continue;
            return true;
        }
        return false;
    }

    protected static double computeNumberOfMembersFromParentLevelToTheLevel(double n, ILevel cl, ILevel level) {
        double ratio = MDXOOMInfo.getNumberFromOOM(level.getOrderOfMagnitude()) / MDXOOMInfo.getNumberFromOOM(cl.getOrderOfMagnitude());
        return n * ratio;
    }
}

