/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.olap.util;

import com.cognos.xqe.ast.mdx.parser.MDXParser;
import com.cognos.xqe.ast.mdx.parser.MDXParserVisitorBase;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.ast.mdx.parser.ParseException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public abstract class MDXParserUtility {
    public static MDXQueryNode parseMDX(String mdxText, PlanningEnvironment environment, ParseType parseType) {
        try {
            String utf8 = "UTF-8";
            MDXParser parser = new MDXParser(new ByteArrayInputStream(mdxText.getBytes(utf8)), utf8);
            parser.setNodeFactory(environment.getNodeFactory());
            switch (parseType) {
                case VALUE_EXPRESSION: {
                    ParseException e = parser.ValueExpression();
                    if (e == null) break;
                    throw e;
                }
                case STATEMENT: {
                    parser.MDXStatement();
                    break;
                }
                case SET: {
                    parser.Set();
                    break;
                }
                default: {
                    throw new MetadataException("X01499");
                }
            }
            MDXParserVisitor v = new MDXParserVisitor(parser);
            return v.getMDXRootNode();
        }
        catch (ParseException e) {
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.ERROR);
            logger.log(mdxText);
            throw new MetadataException("X01499", new String[]{e.toString()}, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MetadataException("X01499", e);
        }
    }

    private static class MDXParserVisitor
    extends MDXParserVisitorBase {
        MDXParserVisitor(MDXParser p) {
            super(p);
        }

        public MDXQueryNode getMDXRootNode() {
            return (MDXQueryNode)this.getRootNode();
        }
    }

    public static enum ParseType {
        VALUE_EXPRESSION,
        STATEMENT,
        SET;

    }
}

