/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.qep;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.qep.QEPAbstractPlan;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;

public abstract class QEPPlan
extends QEPAbstractPlan
implements ISQLQueryNode {
    private static final String PROP_DOUBLE_CPU_COST = "cpuCost";
    private static final String PROP_DOUBLE_IO_COST = "ioCost";
    private static final String PROP_DOUBLE_NROWS = "nRows";
    private static final String PROP_OBJECT_FACTORS = "factors";
    private static final String PROP_INTEGER_SOURCENO = "sourceNo";
    private static final String PROP_OBJECT_INCIDENCE = "incidence";
    private static final String PROP_INTEGER_NCOLUMNS = "nColumns";
    public static final String PROP_BOOLEAN_ISLATERAL = "isLateral";

    @Override
    public void initialize() {
        this.setSourceNo(-1);
        this.setNumberColumns(-1);
        this.setCPUCost(0.0);
        this.setIOCost(0.0);
    }

    @Override
    public IDataType getDataType() {
        throw new UnsupportedOperationException();
    }

    public void setCPUCost(double cost) {
        this.setPropertyValue(PROP_DOUBLE_CPU_COST, cost);
    }

    public double getCPUCost() {
        return (Double)this.getPropertyValue(PROP_DOUBLE_CPU_COST);
    }

    public void setIOCost(double cost) {
        this.setPropertyValue(PROP_DOUBLE_IO_COST, cost);
    }

    public double getIOCost() {
        return (Double)this.getPropertyValue(PROP_DOUBLE_IO_COST);
    }

    public double getCost() {
        return this.getCPUCost() + this.getIOCost();
    }

    public int getSourceNo() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_SOURCENO);
    }

    public void setSourceNo(int sourceNo) {
        this.setPropertyValue(PROP_INTEGER_SOURCENO, sourceNo);
    }

    public BitMask getIncidence() {
        return (BitMask)this.getPropertyValue(PROP_OBJECT_INCIDENCE);
    }

    public void setIncidence(BitMask incidence) {
        this.setPropertyValue(PROP_OBJECT_INCIDENCE, new BitMask(incidence));
    }

    public BitMask getFactors() {
        return (BitMask)this.getPropertyValue(PROP_OBJECT_FACTORS);
    }

    public void setFactors(BitMask factors) {
        this.setPropertyValue(PROP_OBJECT_FACTORS, new BitMask(factors));
    }

    @Override
    public double getCardinality() {
        return (Double)this.getPropertyValue(PROP_DOUBLE_NROWS);
    }

    public void setCardinalityEstimate(double nRows) {
        this.setPropertyValue(PROP_DOUBLE_NROWS, nRows);
    }

    @Override
    public int getNumberColumns() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_NCOLUMNS);
    }

    public void setNumberColumns(int nColumns) {
        this.setPropertyValue(PROP_INTEGER_NCOLUMNS, nColumns);
    }

    public void computeCosts() {
        this.setCPUCost(0.0);
        this.setIOCost(0.0);
    }

    public void setLateral(boolean isLateral) {
        this.setPropertyValue(PROP_BOOLEAN_ISLATERAL, isLateral);
    }

    @Override
    public boolean isLateralDerivedTable() {
        return this.getPropertyValue(PROP_BOOLEAN_ISLATERAL) == Boolean.TRUE;
    }

    @Override
    public boolean hasParameters() {
        SQLQueryItemList qItemList = this.getQueryItemList();
        return qItemList != null && qItemList.hasParameters();
    }

    @Override
    public SQLQueryItemList getQueryItemList() {
        return ((ISQLQueryNode)this.getChild(0)).getQueryItemList();
    }
}

