/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilter;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.ISecurityFilterBasedOn;
import com.cognos.xqe.metadata.ISecurityObject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.ConvertSecurityFiltersForQSToDetail;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqemoser.MoserEmbeddedFilter;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.ArrayList;
import java.util.List;

public class RMEmbeddedFilterList
extends RQPNode {
    public static final String ALWAYS = "always";
    public static final String ASNEEDED = "asNeeded";
    public static final String DESIGNMODE = "designMode";
    private static final String PROP_OBJ_QUERY_SUBJECT = "querySubject";
    public static final String PROP_SQS_FILTER_PAA = "SQSFilterPAA";

    RMEmbeddedFilterList() {
    }

    @Override
    public int getType() {
        return 801036;
    }

    public void deployRMEmbeddedFilterList(IQuerySubject querySubject, PlanningEnvironment environment) {
        if (!this.hasChildOfType(801035)) {
            this.createRMEmbeddedFilters(querySubject, environment);
        }
    }

    private void createRMEmbeddedFilters(IQuerySubject querySubject, PlanningEnvironment environment) {
        boolean securityFilterAdded;
        boolean isSQSFilter = (IQuerySubject)this.getParent().getPropertyValue("sqsOwner") != null;
        this.createRMEmbeddedFiltersForRegular(environment, querySubject, querySubject.getFilters(), isSQSFilter);
        if (this.getGovernors() != null) {
            if (this.getGovernors().getDesignMode().booleanValue()) {
                this.createRMEmbeddedFiltersForPreview(environment, querySubject.getPreviewFilters(), isSQSFilter);
            }
        } else {
            this.createRMEmbeddedFiltersForPreview(environment, querySubject.getPreviewFilters(), isSQSFilter);
        }
        if (securityFilterAdded = RMEmbeddedFilterList.createRMEmbeddedFiltersForSecurity(environment, querySubject.getSecurityFilters(), this)) {
            ConvertSecurityFiltersForQSToDetail transformation = new ConvertSecurityFiltersForQSToDetail(new int[0]);
            transformation.apply((IXQEQueryNode)this, environment);
        }
    }

    private void createRMEmbeddedFiltersForRegular(PlanningEnvironment environment, IQuerySubject theQS, List<IEmbeddedFilter> filters, boolean isSQSFilter) {
        for (IEmbeddedFilter filter : filters) {
            MoserEmbeddedFilter moserFilter;
            RMEmbeddedFilter rmEmbeddedFilter = RMEmbeddedFilterList.createRMEmbeddedFilter(environment, "filterDefinition", filter.getApplyAttribute());
            this.addChild(rmEmbeddedFilter);
            IXQEQueryNode v5ValueExpression = null;
            if (filter instanceof MoserEmbeddedFilter && (moserFilter = (MoserEmbeddedFilter)filter).getFilterExpression() != null) {
                v5ValueExpression = environment.getNodeFactory().deepCopyNode((IXQEQueryNode)moserFilter.getFilterExpression());
            }
            if (v5ValueExpression == null) {
                v5ValueExpression = RQPUtilities.createV5ExpressionFromFilter(environment, filter, this.getParent(), rmEmbeddedFilter);
            }
            if ((v5ValueExpression = this.convertHierarchyFilterToRelFilter(v5ValueExpression, environment, theQS)) == null) {
                rmEmbeddedFilter.extract();
                continue;
            }
            MetadataContext.flagMetadataObjectIfRequired(theQS, v5ValueExpression);
            rmEmbeddedFilter.addChild(v5ValueExpression);
            rmEmbeddedFilter.setPropertyValue("originalExpression", filter.getExpression());
            if (!isSQSFilter || !SummaryQuerySubjectUtilities.getPostAutoAggregate(filter)) continue;
            rmEmbeddedFilter.setPropertyValue(PROP_SQS_FILTER_PAA, true);
        }
    }

    private IXQEQueryNode convertHierarchyFilterToRelFilter(IXQEQueryNode v5ValueExpression, PlanningEnvironment environment, IQuerySubject theQS) {
        MetadataConnection connection = environment.getMetadataConnection();
        if (!(connection instanceof MoserMetadataConnection) || !(theQS instanceof MoserQuerySubject)) {
            return v5ValueExpression;
        }
        IXQEQueryNode inClause = null;
        if (v5ValueExpression.getType() == 201003) {
            V5LogicalExpression n = (V5LogicalExpression)v5ValueExpression;
            if (n.getSubType() == 2) {
                inClause = n.getChild(0);
            }
        } else {
            inClause = v5ValueExpression;
        }
        if (inClause == null || inClause.getType() != 201011 || inClause.getNumberChildren() < 2) {
            return v5ValueExpression;
        }
        IXQEQueryNode[] children = inClause.getChildren();
        if (children[0].getType() != 201030) {
            return v5ValueExpression;
        }
        String hierName = ((V5MultiPartIdentifier)children[0]).getIdentifier();
        MoserQuerySubject qs = (MoserQuerySubject)theQS;
        ArrayList<List<MoserQueryItem>> queryItemsMuns = new ArrayList<List<MoserQueryItem>>();
        ArrayList<String[]> literalMuns = new ArrayList<String[]>();
        int i = 1;
        for (i = 1; i < children.length; ++i) {
            if (children[i].getType() != 201028) {
                return v5ValueExpression;
            }
            V5MemberUniqueName mun = (V5MemberUniqueName)children[i];
            if (!hierName.equals(mun.getModel())) {
                return v5ValueExpression;
            }
            String logical = mun.getLogical();
            if (logical == null) {
                return v5ValueExpression;
            }
            if ("all".equals(logical)) continue;
            String[] parts = UniqueNameParser.parseNoThrow(logical);
            if (parts == null || parts.length == 0) {
                return v5ValueExpression;
            }
            List<MoserQueryItem> qis = qs.getHierarchyQueryItems(hierName, parts.length);
            if (qis == null || qis.isEmpty()) {
                return v5ValueExpression;
            }
            queryItemsMuns.add(qis);
            literalMuns.add(parts);
        }
        if (queryItemsMuns.isEmpty()) {
            return null;
        }
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode filterExpr = null;
        for (i = 0; i < queryItemsMuns.size(); ++i) {
            List qis = (List)queryItemsMuns.get(i);
            String[] parts = (String[])literalMuns.get(i);
            IXQEQueryNode munExpr = this.createMUNExpression(factory, qis, parts);
            if (filterExpr == null) {
                filterExpr = munExpr;
                continue;
            }
            V5LogicalExpression or = (V5LogicalExpression)factory.createNode(201003);
            or.setSubType(1);
            or.addChild(filterExpr);
            or.addChild(munExpr);
            filterExpr = or;
        }
        if (inClause != v5ValueExpression) {
            v5ValueExpression.exchangeChildNode(inClause, filterExpr);
            return v5ValueExpression;
        }
        return filterExpr;
    }

    private IXQEQueryNode createMUNExpression(XQENodeFactory factory, List<MoserQueryItem> qis, String[] parts) {
        AbstractV5BooleanExpression munExpr = null;
        for (int i = 0; i < qis.size(); ++i) {
            MoserQueryItem qi = qis.get(i);
            String literal = parts[i];
            V5ComparisonExpression compExpr = (V5ComparisonExpression)factory.createNode(201013);
            compExpr.setSubType(2);
            V5BoundModelIdentifier meta = (V5BoundModelIdentifier)factory.createNode(201116);
            meta.setMetadata(qi);
            compExpr.addChild(meta);
            V5LiteralValue literalValue = (V5LiteralValue)factory.createNode(201026);
            literalValue.setNativeName(literal);
            literalValue.setDataType(qi.getDataType());
            literalValue.setValue(literal);
            compExpr.addChild(literalValue);
            if (munExpr == null) {
                munExpr = compExpr;
                continue;
            }
            V5LogicalExpression andExpr = (V5LogicalExpression)factory.createNode(201003);
            andExpr.setSubType(0);
            andExpr.addChild(munExpr);
            andExpr.addChild(compExpr);
            munExpr = andExpr;
        }
        return munExpr;
    }

    private void createRMEmbeddedFiltersForPreview(PlanningEnvironment environment, List<IEmbeddedFilter> filters, boolean isSQSFilter) {
        for (IEmbeddedFilter filter : filters) {
            IXQEQueryNode v5ValueExpression = RQPUtilities.createV5ExpressionFromFilter(environment, filter, this.getParent());
            RMEmbeddedFilter rmEmbeddedFilter = RMEmbeddedFilterList.createRMEmbeddedFilter(environment, v5ValueExpression, "previewFilter", ASNEEDED);
            this.addChild(rmEmbeddedFilter);
            rmEmbeddedFilter.setPropertyValue("originalExpression", filter.getExpression());
            if (!isSQSFilter || !SummaryQuerySubjectUtilities.getPostAutoAggregate(filter)) continue;
            rmEmbeddedFilter.setPropertyValue(PROP_SQS_FILTER_PAA, true);
        }
    }

    public static boolean createRMEmbeddedFiltersForSecurity(PlanningEnvironment environment, List<IEmbeddedFilter> filters, RMEmbeddedFilterList list) {
        boolean filterAdded = false;
        for (IEmbeddedFilter filter : filters) {
            IMetadata standAloneFilter;
            IXQEQueryNode v5ValueExpression = RQPUtilities.createV5ExpressionFromFilter(environment, filter, list.getParent());
            if (v5ValueExpression == null) continue;
            RMEmbeddedFilter rmEmbeddedFilter = RMEmbeddedFilterList.createRMEmbeddedFilter(environment, v5ValueExpression, "securityFilterDefinition", ALWAYS);
            String expression = filter.getExpression();
            if (expression == null && (standAloneFilter = filter.getRefObject()) instanceof IFilter) {
                expression = ((IFilter)standAloneFilter).getExpression();
            }
            rmEmbeddedFilter.setPropertyValue("originalExpression", expression);
            List<ISecurityObject> securityObjects = filter.getSecurityObject();
            if (securityObjects != null && securityObjects.size() > 0) {
                for (ISecurityObject iSecurityObject : securityObjects) {
                    rmEmbeddedFilter.setIdentitySearchPath(iSecurityObject.getSecurityObjectSearchPath());
                }
            } else {
                rmEmbeddedFilter.setModelViewReference(filter.getModelViewReference());
            }
            for (ISecurityFilterBasedOn iSecurityFilterBasedOn : filter.getSecurityFilterBasedOn()) {
                rmEmbeddedFilter.setBasedOnSearchPath(iSecurityFilterBasedOn.getSecurityBasedOnSearchPath());
            }
            list.addChild(rmEmbeddedFilter);
            filterAdded = true;
        }
        return filterAdded;
    }

    public static RMEmbeddedFilter createRMEmbeddedFilter(PlanningEnvironment environment, String type, String apply) {
        RMEmbeddedFilter rmEmbeddedFilter = (RMEmbeddedFilter)environment.getNodeFactory().createNode(801035);
        rmEmbeddedFilter.setFilterType(type);
        rmEmbeddedFilter.setApply(apply);
        return rmEmbeddedFilter;
    }

    public static RMEmbeddedFilter createRMEmbeddedFilter(PlanningEnvironment environment, IXQEQueryNode v5ValueExpression, String type, String apply) {
        RMEmbeddedFilter rmEmbeddedFilter = RMEmbeddedFilterList.createRMEmbeddedFilter(environment, type, apply);
        rmEmbeddedFilter.addChild(v5ValueExpression);
        return rmEmbeddedFilter;
    }

    public IQuerySubject getQuerySubject() {
        return (IQuerySubject)this.getPropertyValue(PROP_OBJ_QUERY_SUBJECT);
    }

    public void setQuerySubject(IQuerySubject querySubject) {
        this.setPropertyValue(PROP_OBJ_QUERY_SUBJECT, querySubject);
    }
}

