/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.rqp.RMEmbeddedFilterList;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryItemList;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.CreateUniqueValidSqlIdentifierForSqlRangeVar;
import com.cognos.xqe.transformation.v5tocogsql.util.QuerySubjectSQLGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import java.util.List;

public class RMQuery
extends RQPNode {
    public static final String PROP_AGGREGATE_QS = "aggregateQuerySubject";
    public static final String PROP_OBJECT_QUERYSUBJECT = "querySubject";
    public static final String PROP_OBJECT_QUERYSUBJECT_WRAPPER = "querySubjectWrapper";
    public static final String PROP_COMPUTEDJOINPLAN = "computedJoinPlan";
    public static final String HAS_DETERMINANT = "hasDeterminant";
    public static final String PROP_STRING_CORRELATION_NAME = "correlationName";
    public static final String PROP_STRINGARRAY_NAMEPARTS = "nameParts";
    public static final String IS_ALIAS = "isAlias";
    private static final String PROPERTY_SQL = "sql";
    private static final String MACRO_MARKER = "#";
    private static final String DBHINT_KW = "DBHINT={";
    public static final String PROP_SELECTCONTROL = "selectControl";

    RMQuery() {
    }

    @Override
    public int getType() {
        return 801026;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 801026) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setQuerySubject(IQuerySubject querySubject, PlanningEnvironment environment) {
        String s;
        int idx;
        this.setPropertyValue(PROP_OBJECT_QUERYSUBJECT, querySubject);
        String desc = querySubject.getDescription();
        if (desc != null && !desc.isEmpty() && (idx = desc.indexOf(DBHINT_KW)) != -1 && (idx = (s = desc.substring(idx + DBHINT_KW.length())).indexOf("}")) != -1 && !(s = s.substring(0, idx)).isEmpty()) {
            if (s.contains(MACRO_MARKER)) {
                MacroExpander expander = new MacroExpander();
                expander.setLocalParameters(MetadataContext.getLocalParameters(querySubject));
                s = expander.expand(null, environment, s);
            }
            this.setPropertyValue("dbHint", s);
        }
    }

    public IQuerySubject getQuerySubject() {
        return (IQuerySubject)this.getPropertyValue(PROP_OBJECT_QUERYSUBJECT);
    }

    public void setComputedJoinPlan(boolean setUnsetValue) {
        this.setPropertyValue(PROP_COMPUTEDJOINPLAN, setUnsetValue);
    }

    public boolean getComputedJoinPlan() {
        Boolean computedJoinPlan = (Boolean)this.getPropertyValue(PROP_COMPUTEDJOINPLAN);
        if (computedJoinPlan == null) {
            return false;
        }
        return computedJoinPlan;
    }

    public void populate(PlanningEnvironment environment) {
        this.populateSQLAST(environment);
        this.populateQueryItemList(environment);
        this.populateFilterList(environment);
    }

    public RMQueryItemList getRMQueryItemList(PlanningEnvironment environment) {
        IXQEQueryNode[] childOfType = this.getChildrenOfType(801034);
        RMQueryItemList rmQueryItemList = null;
        if (childOfType.length == 1) {
            rmQueryItemList = (RMQueryItemList)childOfType[0];
        } else {
            rmQueryItemList = (RMQueryItemList)environment.getNodeFactory().createNode(801034);
            this.addChild(rmQueryItemList);
        }
        return rmQueryItemList;
    }

    private void populateQueryItemList(PlanningEnvironment environment) {
        IQuerySubject querySubject = this.getQuerySubject();
        RMQueryItemList rmQueryItemList = this.getRMQueryItemList(environment);
        rmQueryItemList.deployRMQueryItemList(querySubject, environment);
    }

    public RMQueryItem getRMQueryItem(V5BoundModelIdentifier v5Identifier) {
        IXQEQueryNode childOfType = this.getFirstChildByType(801034);
        if (childOfType == null) {
            return null;
        }
        RMQueryItemList rmQueryItemList = (RMQueryItemList)childOfType;
        return rmQueryItemList.getRMQueryItem(v5Identifier);
    }

    public IXQEQueryNode getSQLForQuerySubject(IXQENodeFactory nodeFactory) {
        IXQEQueryNode[] childrenList = this.getChildrenOfType(301007);
        if (childrenList.length == 1) {
            return nodeFactory.deepCopyNode(childrenList[0]);
        }
        return null;
    }

    public void populateSQLAST(PlanningEnvironment environment) {
    }

    public void parseQuerySQL(PlanningEnvironment environment) {
        IQuerySubject querySubject;
        block9: {
            if (this.getType() != 801027 && this.getType() != 801028) {
                return;
            }
            querySubject = this.getQuerySubject();
            if (MacroExpander.getXQETracingEnabledForMX()) {
                this.setUnexpandedSQLProperty(this, querySubject);
            }
            try {
                IXQEQueryNode sourceAST = querySubject.generateSQLAST(environment, this, null);
                sourceAST.setPropertyValue("fullQSName", this.getName());
                if (sourceAST.getDescendantsOfType(301006, false).length == 1 && !QuerySubjectSQLGenerator.isTrivialSql((SQLRangeVar)sourceAST)) {
                    IXQEQueryNode[] sqlRelations;
                    IXQEQueryNode[] iXQEQueryNodeArray = sqlRelations = sourceAST.getDescendantsOfType(301016, false);
                    int n = iXQEQueryNodeArray.length;
                    for (int i = 0; i < n; ++i) {
                        IXQEQueryNode sqlRelation = iXQEQueryNodeArray[i];
                        if (sqlRelation.getParent().getType() == 301007) continue;
                        SQLRangeVar sqlRangeVar = (SQLRangeVar)environment.getNodeFactory().createNode(301007);
                        sqlRangeVar.setName(((SQLRelation)sqlRelation).getName());
                        sqlRelation.insertParent(sqlRangeVar);
                    }
                }
                for (IXQEQueryNode rangeVar : sourceAST.getDescendantsOfType(301007, false)) {
                    if (rangeVar.getNumberChildren() == 1 && rangeVar.getChild(0).getType() == 301016) continue;
                    rangeVar.setPropertyValue("derivedTableOfDBQS", true);
                }
                this.addChild(sourceAST);
                List<IXQEQueryNode> children = sourceAST.getDescendantsOfTypesOrdered(new int[]{301016, 301007}, true);
                for (IXQEQueryNode child : children) {
                    IDataSource dataSource = CreateUniqueValidSqlIdentifierForSqlRangeVar.getDataSource(child, environment);
                    if (dataSource == null || !dataSource.isRelational()) continue;
                    environment.addDataSource(dataSource);
                }
            }
            catch (ParseException e) {
                RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
                Parameters parameters = requestEnvironment.getRequestParameters();
                if (parameters.hasUnresolvedParameters()) break block9;
                throw new XQERuntimeException(e);
            }
        }
        if (MacroExpander.getXQETracingEnabledForMX()) {
            this.setExpandedSQLProperty(environment, querySubject);
        }
    }

    private void setUnexpandedSQLProperty(RMQuery query, IQuerySubject querySubject) {
        if (querySubject.getSql().contains(MACRO_MARKER)) {
            QuerySubjectSQLGenerator qsGenerator = new QuerySubjectSQLGenerator();
            String sql = qsGenerator.getUnexpandedSQL(querySubject);
            this.setPropertyValue(PROPERTY_SQL, sql);
        }
    }

    private void setExpandedSQLProperty(PlanningEnvironment environment, IQuerySubject querySubject) {
        if (querySubject.getSql().contains(MACRO_MARKER)) {
            QuerySubjectSQLGenerator qsGenerator = new QuerySubjectSQLGenerator(this);
            String unexpandedSQL = qsGenerator.getUnexpandedSQL(querySubject);
            this.setPropertyValue(PROPERTY_SQL, qsGenerator.getMacroExpandedSQL(environment, unexpandedSQL, qsGenerator.getSqlType(), querySubject));
        }
    }

    public RMEmbeddedFilterList getRMEmbeddedFilterList(PlanningEnvironment environment) {
        return this.getOrCreateEmbeddedFilterList(environment, this.getQuerySubject());
    }

    public void populateFilterList(PlanningEnvironment environment) {
        IQuerySubject querySubject = this.getQuerySubject();
        RMEmbeddedFilterList rmEmbeddedFilterList = this.getRMEmbeddedFilterList(environment);
        rmEmbeddedFilterList.deployRMEmbeddedFilterList(querySubject, environment);
    }

    public String getCorrelationName() {
        return (String)this.getPropertyValue(PROP_STRING_CORRELATION_NAME);
    }

    public void setCorrelationName(String name) {
        this.setPropertyValue(PROP_STRING_CORRELATION_NAME, name);
    }

    public String getNameFromNameParts() {
        String[] nameParts = this.getNameParts();
        return nameParts[nameParts.length - 1];
    }

    public void setNameParts(String[] nameParts) {
        this.setPropertyValue(PROP_STRINGARRAY_NAMEPARTS, nameParts);
    }

    public String[] getNameParts() {
        return (String[])this.getPropertyValue(PROP_STRINGARRAY_NAMEPARTS);
    }

    public void setWrapperQuerySubject(IQuerySubject querySubject) {
        this.setPropertyValue(PROP_OBJECT_QUERYSUBJECT_WRAPPER, querySubject);
        this.setCorrelationName(querySubject.getName());
    }

    public IQuerySubject getWrapperQuerySubject() {
        return (IQuerySubject)this.getPropertyValue(PROP_OBJECT_QUERYSUBJECT_WRAPPER);
    }
}

