/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IDbDimension;
import com.cognos.xqe.metadata.IDbMeasureDimension;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.HashSet;

public class RMQueryList
extends RQPNode {
    public static final String PROP_BOOLEAN_EXPLICIT_SHORTCUT_PROCESSING = "explicitShortcutProcessing";
    public static final String PROP_OBJECT_QS_WRAPPER = "wrapperQuerySubjects";

    RMQueryList() {
    }

    public void setExplicitShortcutProcessing(boolean value) {
        this.setPropertyValue(PROP_BOOLEAN_EXPLICIT_SHORTCUT_PROCESSING, value);
    }

    public boolean getExplicitShortcutProcessing() {
        if (this.getPropertyValue(PROP_BOOLEAN_EXPLICIT_SHORTCUT_PROCESSING) == null) {
            return false;
        }
        return this.getPropertyValue(PROP_BOOLEAN_EXPLICIT_SHORTCUT_PROCESSING) == Boolean.TRUE;
    }

    @Override
    public int getType() {
        return 801032;
    }

    public RMQuery getRMQuery(String name) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            RMQuery rmQuery = (RMQuery)this.getChild(i);
            String qsName = (String)rmQuery.getPropertyValue("name");
            if (qsName.compareTo(name) != 0) continue;
            return rmQuery;
        }
        return null;
    }

    private String getQuerySubjectName(V5BoundModelIdentifier v5Identifier, IMetadata qs) {
        boolean treatedAsAlias;
        IAccessedViaShortcut asc;
        if (v5Identifier != null && v5Identifier.getResolvedQSName() != null) {
            return v5Identifier.getResolvedQSName();
        }
        IMetadata querySubject = qs;
        if ((querySubject instanceof IDbMeasureDimension || querySubject instanceof IDbDimension) && querySubject instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)querySubject).isAccessedViaShortcut()) {
            IShortcut sc = ((IAccessedViaShortcut)querySubject).getShortcut();
            querySubject = sc.getTarget();
        }
        String qsName = this.getV5UniqueName(querySubject);
        IMetadata shortcut = querySubject;
        if (querySubject instanceof IAccessedViaShortcut && (asc = (IAccessedViaShortcut)querySubject).isAccessedViaShortcut()) {
            shortcut = asc.getShortcut();
        }
        if ((treatedAsAlias = RQPUtilities.isShortcutTreatedAsAlias(shortcut, this.getExplicitShortcutProcessing())) && ((IShortcut)shortcut).getTarget() instanceof IQuerySubject) {
            qsName = this.getV5UniqueName(shortcut);
        }
        if (v5Identifier != null) {
            v5Identifier.setResolvedQSName(qsName);
        }
        return qsName;
    }

    public RMQuery getRMQuery(IMetadata qs) {
        if (qs != null) {
            String qsName = this.getQuerySubjectName(null, qs);
            if (null == qsName) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "RMQueryList.getRMQuery from metadata requires qsName");
            }
            RMQuery ret = this.getRMQuery(qsName);
            if (ret != null) {
                return ret;
            }
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            RMQuery rmQuery = (RMQuery)this.getChild(i);
            IMetadata mObj = (IMetadata)rmQuery.getPropertyValue("querySubjectWrapper");
            if (qs != mObj) continue;
            return rmQuery;
        }
        return null;
    }

    public RMQuery getRMQuery(V5BoundModelIdentifier v5Identifier) {
        IQuerySubject qs = v5Identifier.getQuerySubject();
        if (qs != null) {
            String qsName = this.getQuerySubjectName(v5Identifier, qs);
            return this.getRMQuery(qsName);
        }
        return null;
    }

    public RMQuery getRMQuery(RMQueryItemRef rmQueryItemRef) {
        return this.getRMQuery(rmQueryItemRef.getRMQueryName());
    }

    public RMQuery getRMQuery(IXQEQueryNode node) {
        switch (node.getType()) {
            case 201116: {
                return this.getRMQuery((V5BoundModelIdentifier)node);
            }
            case 801047: {
                return this.getRMQuery((RMQueryItemRef)node);
            }
        }
        return null;
    }

    public RMQuery createRMQuery(V5BoundModelIdentifier v5Identifier, PlanningEnvironment environment) {
        IQuerySubject qs = v5Identifier.getQuerySubject();
        return this.createRMQuery(v5Identifier, qs, environment);
    }

    public RMQuery createRMQuery(V5BoundModelIdentifier v5Identifier, IQuerySubject qs, PlanningEnvironment environment) {
        String[] parts;
        String qsName = this.getQuerySubjectName(v5Identifier, qs);
        RMQuery rmQuery = null;
        boolean isSQSQuerySubject = false;
        if (SummaryQuerySubjectUtilities.isSummaryQuerySubject(qs)) {
            isSQSQuerySubject = true;
            IQuerySubject.QuerySubjectTypeEnum qsType = qs.getQuerySubjectType();
            if (qsType == IQuerySubject.QuerySubjectTypeEnum.QUERYOPERATION) {
                rmQuery = (RMQuery)environment.getNodeFactory().createNode(801031);
            } else if (qsType == IQuerySubject.QuerySubjectTypeEnum.MODELQUERYSUBJECT) {
                rmQuery = (RMQuery)environment.getNodeFactory().createNode(801029);
            } else {
                throw new XQERuntimeException(XQEMessageKeys.PLN_SummaryQuerySubjectIsNotModelQS, qs.getID());
            }
            rmQuery.setPropertyValue("sqsOwner", qs);
        } else {
            rmQuery = (RMQuery)environment.getNodeFactory().createNode(this.getRMQueryType(qs));
        }
        if (this.hasDeterminants(qs)) {
            if (isSQSQuerySubject) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_SummaryQuerySubjectDeterminantNotSupported, qs.getID());
            }
            rmQuery.setPropertyValue("hasDeterminant", "true");
        }
        this.addChild(rmQuery);
        try {
            parts = UniqueNameParser.parse(qsName, -1);
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        if (!qsName.equals(this.getV5UniqueName(qs))) {
            rmQuery.setPropertyValue("isAlias", "True");
        }
        rmQuery.setNameParts(parts);
        rmQuery.setName(qsName);
        rmQuery.setQuerySubject(qs, environment);
        rmQuery.populate(environment);
        return rmQuery;
    }

    private String getV5UniqueName(IMetadata qs) {
        PlanningEnvironment environment = (PlanningEnvironment)this.getPlanningEnvironment();
        if (environment == null) {
            return qs.getV5UniqueName();
        }
        MetadataConnection mdConn = environment.getMetadataConnection();
        if (mdConn == null) {
            return qs.getV5UniqueName();
        }
        return mdConn.getV5UniqueName(qs);
    }

    private int getRMQueryType(IQuerySubject qs) {
        switch (qs.getQuerySubjectType()) {
            case STOREDPROCEDURE: {
                return 801030;
            }
            case QUERYOPERATION: {
                return 801031;
            }
            case MODELQUERYSUBJECT: {
                return 801029;
            }
            case DBQSASVIEW: {
                return 801028;
            }
            case DBQSWITHCALCULATIONFILTER: {
                return 801027;
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "Undefined query subject type");
    }

    private boolean hasDeterminants(IQuerySubject qs) {
        return qs.getDeterminants() != null && !qs.getDeterminants().isEmpty();
    }

    public void addWrapperQuerySubject(IQuerySubject qs) {
        HashSet<IQuerySubject> st = (HashSet<IQuerySubject>)this.getPropertyValue(PROP_OBJECT_QS_WRAPPER);
        if (st == null) {
            st = new HashSet<IQuerySubject>();
            this.setPropertyValue(PROP_OBJECT_QS_WRAPPER, st);
        }
        st.add(qs);
    }
}

