/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IProcParameter;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryToSQL.CreateUniqueValidSqlIdentifierForSqlRangeVar;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RMQueryStoredProcedure
extends RMQuery {
    RMQueryStoredProcedure() {
    }

    @Override
    public void populateSQLAST(PlanningEnvironment environment) {
        ICatalog catalog;
        String schemaName;
        String cmDatabaseName;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IQuerySubject qs = this.getQuerySubject();
        String procName = (String)qs.getProperty("canonicalName");
        SQLRangeVar sqlRangeVar = (SQLRangeVar)nodeFactory.createNode(301007);
        sqlRangeVar.setPropertyValue("fullQSName", this.getName());
        sqlRangeVar.setName(procName);
        this.addChild(sqlRangeVar);
        SQLCall sqlCall = (SQLCall)nodeFactory.createNode(301061);
        sqlCall.setName(procName);
        sqlCall.setPropertyValue("querySubject", qs);
        IModelDataSource datasource = RQPUtilities.getModelDataSource(qs);
        String modelDatasourceName = datasource.getName();
        if (modelDatasourceName != null) {
            sqlCall.setModelDatasourceName(modelDatasourceName);
            this.setQueryAsNotReusable(environment, procName, datasource);
        }
        if ((cmDatabaseName = datasource.getCMDataSourceName()) != null) {
            if (MacroExpander.isMacro(cmDatabaseName)) {
                sqlCall.setRawCmDatabaseName(cmDatabaseName);
                MacroExpander expander = new MacroExpander();
                cmDatabaseName = expander.expand(null, environment, cmDatabaseName);
            }
            sqlCall.setDatabaseName(cmDatabaseName);
        }
        if ((schemaName = datasource.getSchema()) != null) {
            if (MacroExpander.isMacro(schemaName)) {
                sqlCall.setRawSchemaName(schemaName);
                MacroExpander expander = new MacroExpander();
                schemaName = expander.expand(null, environment, schemaName);
            }
            sqlCall.setSchemaName(schemaName);
        }
        if ((catalog = datasource.getCatalog()) != null) {
            String catalogName = catalog.getUniqueName();
            if (MacroExpander.isMacro(catalogName)) {
                sqlCall.setRawCatalogName(catalogName);
                MacroExpander expander = new MacroExpander();
                catalogName = expander.expand(null, environment, catalogName);
            }
            sqlCall.setCatalogName(catalogName);
        }
        sqlRangeVar.addChild(sqlCall);
        IDataSource dataSource = CreateUniqueValidSqlIdentifierForSqlRangeVar.getDataSource(this, environment);
        if (dataSource != null && dataSource.isRelational()) {
            environment.addDataSource(dataSource);
            sqlCall.setDataSource(dataSource);
        }
        List<IProcParameter> args = qs.getStoredProcArgs();
        for (IProcParameter procParameter : args) {
            String paramValue = procParameter.getValue();
            String paramMode = procParameter.getMode();
            if (MacroExpander.isMacro(paramValue)) {
                MacroExpander expander = new MacroExpander();
                paramValue = expander.expand(this, environment, paramValue);
            }
            String questionMark = "?";
            if (paramValue != null && paramValue.length() > 2 && paramValue.startsWith("?") && paramValue.endsWith("?")) {
                String promptName = paramValue.substring(1, paramValue.length() - 1);
                Parameters params = ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters();
                Parameter param = (Parameter)params.get(promptName);
                if (param != null) {
                    IDataType dataType = param.getDataType();
                    if (dataType == null) {
                        dataType = procParameter.getDataType();
                        param.setDataType(dataType);
                    }
                    String inValue = null;
                    IValue[] values = param.getParameterValues();
                    if (values.length > 0 && values[0] != null) {
                        inValue = ((Value)values[0]).getString();
                        dataType = RQPUtilities.promoteDataType(dataType, inValue);
                    }
                    V5BoundParameter prompt = RMQueryStoredProcedure.createV5BoundParameterForProcParam(environment, procParameter, dataType, null);
                    prompt.setParameterName(promptName);
                    sqlCall.addChild(prompt);
                    continue;
                }
                V5Parameter v5Param = (V5Parameter)nodeFactory.createNode(201024);
                v5Param.setDataType(procParameter.getDataType());
                v5Param.setValue(paramValue);
                sqlCall.addChild(v5Param);
                continue;
            }
            if ("IN".equalsIgnoreCase(paramMode) && paramValue == null) {
                V5LiteralValue valueNode = (V5LiteralValue)nodeFactory.createNode(201026);
                valueNode.setDataType(procParameter.getDataType());
                valueNode.setValue(paramValue);
                sqlCall.addChild(valueNode);
                continue;
            }
            IDataType dataType = procParameter.getDataType();
            dataType = RQPUtilities.promoteDataType(dataType, paramValue);
            Value dataValue = (Value)dataType.createValue();
            dataValue.set(paramValue);
            V5BoundParameter prompt = RMQueryStoredProcedure.createV5BoundParameterForProcParam(environment, procParameter, dataType, dataValue.getString());
            sqlCall.addChild(prompt);
        }
    }

    private void setQueryAsNotReusable(PlanningEnvironment pEnvironment, String spName, IModelDataSource mDatasource) {
        IXQEQueryNode ancestor;
        String transaction;
        Map<String, Object> dsMetadataProperties = mDatasource.getMetadataProperties();
        Object property = dsMetadataProperties.get("transactionAccessMode");
        if (property != null && (transaction = (String)property).equals("write") && (ancestor = this.getAncestorOfType(801041)) != null) {
            RQPSql rqpSQL = (RQPSql)ancestor;
            rqpSQL.setQueryReusable(false);
            RSAPIDataset dataset = (RSAPIDataset)rqpSQL.getAncestorOfType(401005);
            String reportQuery = dataset.getRefQueryName();
            IMessageKey.Param4 messageKey = XQEMessageKeys.PLN_QueryReuseOffForWriteStoredProcedure;
            Locale locale = XQEMessages.getCurrProductLocale();
            String qsV5Name = this.getQuerySubject().getV5UniqueName();
            String dsName = mDatasource.getName();
            String message = XQEMessages.getMessage(messageKey, locale, reportQuery, qsV5Name, spName, dsName);
            rqpSQL.addQueryReuseOFFReason(message);
        }
    }

    @Override
    public int getType() {
        return 801030;
    }

    @Override
    public void populateFilterList(PlanningEnvironment environment) {
    }

    private static V5BoundParameter createV5BoundParameterForProcParam(PlanningEnvironment environment, IProcParameter procParameter, IDataType dataType, String inValue) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundParameter prompt = (V5BoundParameter)nodeFactory.createNode(201127);
        prompt.setDataType(dataType);
        prompt.setMode(procParameter.getMode());
        prompt.setInValue(inValue);
        prompt.setPropertyValue("isStoredProcedureParam", true);
        return prompt;
    }
}

