/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.metadata.IProcParameter;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;

public class RMSqlQuery
extends RMQuery {
    public static final String PROP_PARAMETER_FORMAT = "format";
    public static final String PROP_FORMAT_SAP = "sap";

    @Override
    public void populateSQLAST(PlanningEnvironment environment) {
        this.parseQuerySQL(environment);
        IQuerySubject qs = this.getQuerySubject();
        List<IProcParameter> args = qs.getStoredProcArgs();
        if (args == null || args.size() == 0) {
            return;
        }
        IXQEQueryNode[] relations = this.getDescendantsOfType(301016, false);
        if (relations.length != 1) {
            return;
        }
        SQLRelation relation = (SQLRelation)relations[0];
        for (IProcParameter procParameter : args) {
            String paramValue = procParameter.getValue();
            if (MacroExpander.isMacro(paramValue)) {
                MacroExpander expander = new MacroExpander();
                IXQEQueryNode pp = environment.getNodeFactory().createNode(101076);
                pp.setPropertyValue(PROP_PARAMETER_FORMAT, PROP_FORMAT_SAP);
                this.addChild(pp);
                paramValue = expander.expand(pp, environment, paramValue);
                pp.extract();
                if (pp.getBooleanPropertyValue("dropFilterDueToNilMacroPromptValue") != null) continue;
            }
            String questionMark = "?";
            if (paramValue != null && paramValue.length() > 2 && paramValue.startsWith("?") && paramValue.endsWith("?")) {
                throw new RuntimeException("? style prompts not allowed in view parameters.");
            }
            V5BoundParameter prompt = (V5BoundParameter)environment.getNodeFactory().createNode(201127);
            prompt.setParameterName(procParameter.getParameterName());
            prompt.setDataType(procParameter.getDataType());
            prompt.setMode("IN");
            if (paramValue == null) {
                prompt.setInValue(null);
            } else {
                prompt.setInValue(paramValue);
            }
            relation.addChild(prompt);
        }
    }
}

