/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPBridgeTabularQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPDetailFilterList;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPFooterQuery;
import com.cognos.xqe.ast.rqp.RQPGroupByList;
import com.cognos.xqe.ast.rqp.RQPJoinInfo;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPSortList;
import com.cognos.xqe.ast.rqp.RQPSubqueryList;
import com.cognos.xqe.ast.rqp.RQPSummaryFilterList;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.rqp.RQPTabularQuery;
import com.cognos.xqe.ast.sql.IOutputList;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RQPQuery
extends RQPNode {
    public static final String PROP_STRING_NAME = "name";
    public static final String DEFAULT_TABULAR_QUERY_NAME = "TQ0";
    public static final String PROP_COMPUTEDJOINPLAN = "computedJoinPlan";
    public static final String PROP_ASVIEW_SUBQUERY_GENERATION = "asViewSubqueryGeneration";
    public static final String PROP_STRING_NUM_TIMES_REFERENCED = "numTimesReferenced";
    public static final String PROP_STRING_IS_FOR_ASVIEW_MODELQUERY = "isForAsViewModelQueryWithDeterminants";
    private static final String PROP_LOWEST_LEVEL_SUMMARYQUERY = "lowestLevelSummaryQuery";
    private static final String PROP_AVOID_DOUBLECOUNTING_SUMMARYQUERY = "avoidDoubleCountingSummaryQuery";
    private static final String PROP_CANREWRITEASWINDOWEDAGGREGATES = "canRewriteAsWindowedAggregates";
    public static final String PROP_QUERY_SUBJECTS = "querySubjects";
    private static final String PROP_SUBQUERY_FOR_SUMMARYFILTERS = "isSubqueryForSummaryFilters";
    private static final String PROP_SUBQUERY_TO_AVOID_DOUBLE_COUNTING = "isSubqueryToAvoidDoubleCounting";
    public static final String PROP_STRING_IS_FOR_DETERMINANT_QUERYSUBJECT = "ISFORDETQS";
    public static final String PROP_STRING_QUERYSUBJECT_NAME = "QSNAME";
    public static final String PROP_FILTER_ON_UNPROJECTEDITEM = "filterOnUnProjectedItem";
    public static final String PROP_ISFACTQUERY = "isFactQuery";
    public static final String PROP_ISBRIDGEQUERY = "isBridgeQuery";
    public static final String PROP_ISBRIDGEDATASTREAM = "isBridgeDataStream";
    public static final String PROP_ISBRIDGETABULARQUERY = "isBridgeTabularQuery";
    public static final String PROP_ISBRIDGESUMMARYFILTERQUERY = "isBridgeSummaryFilterQuery";
    public static final String PROP_BOOL_HASSUMMARYFILTER_AFTER_STITCH = "hasSummaryFilterAfterStitch";
    public static final String PROP_FOR_IN_EXPRESSION = "forINExpression";
    public static final String PROP_QUERY_REF_IN_IN_EXPRESSION = "queryRefInINExpression";
    public static final String PROP_OBJECT_REF_RMOPERATIONQUERY = "RmOperationQuery";
    public static final String PROP_OBJECT_REF_V5QUERY = "v5ref";
    public static final String PROP_JOINSELECTIONISCONTEXTSENSITIVE = "joinSelectionIsContextSensitive";
    public static final String PROP_ASVIEW_MODEL_QUERY = "asViewModelQuery";
    public static final String PROP_MERGED_QUERY = "mergedQuery";
    public static final String PROP_BOOL_IS_LEAF_SUBQUERY = "leafSubQuery";
    public static final String PROP_BOOL_HAS_UDF_FUNCTION = "hasUDFFunction";
    public static final String PROP_BOOL_FROM_SPLIT = "createdFromSplit";
    public static final String PROP_JOINS_FOR_FACT_STREAM = "joinsForFactStream";
    public static final String PROP_JOINS_FOR_BRIDGE = "joinsForBridge";
    public static final String STR_NEW_PROJECTION_NAME = "dataItem";
    private static final int[] QUERY_TYPES = new int[]{801017, 801024, 801012, 801025};
    public static final String PROP_IS_REFERENCED_BY_QRD = "isReferencedByQRD";
    public static final String PROP_SQS_OWNER = "sqsOwner";
    public static final String PROP_BOOL_COMPLEX_SQS = "complexSQS";
    private static final String RECREATE_LLSQ = "recreateLLSQ";
    private static final String CANREWRITEFROMLLSQ = "canRewriteInTermsOfLLSQ";
    private static final String REFERENCED_QUERIES = "referencedQueries";
    private static final String PROJECTIONS = "projections";
    public static final String PROP_EVALUATE_MODULE_LOCAL_CACHE = "evaluateModuleLocalCache";
    public static final String PROP_ANALYTIC_SUBQUERY = "analyticSubquery";
    private static final int MAXPROJ = 50;
    private static final String PROP_BOOL_ISSUBQUERY_FOR_CALCS = "subqueryForCalcs";
    private static final String PROP_BOOL_ISSUBQUERY_FOR_CALCS_QS = "subqueryForCalcsQS";
    private Set<IMetadata> originalFolders = null;
    private List<IMetadata> allJoinsForOuterMostQuery = null;

    @Override
    public int getType() {
        return 801017;
    }

    public void setComputedJoinPlan(boolean setUnsetValue) {
        this.setPropertyValue(PROP_COMPUTEDJOINPLAN, setUnsetValue);
    }

    public boolean getComputedJoinPlan() {
        Boolean computedJoinPlan = (Boolean)this.getPropertyValue(PROP_COMPUTEDJOINPLAN);
        if (computedJoinPlan == null) {
            return false;
        }
        return computedJoinPlan;
    }

    public void setAsViewSubqueryGeneration(boolean setUnsetValue) {
        this.setPropertyValue(PROP_ASVIEW_SUBQUERY_GENERATION, setUnsetValue);
    }

    public boolean getAsViewSubqueryGeneration() {
        Boolean asViewSubqueryGeneration = (Boolean)this.getPropertyValue(PROP_ASVIEW_SUBQUERY_GENERATION);
        if (asViewSubqueryGeneration == null) {
            return false;
        }
        return asViewSubqueryGeneration;
    }

    public void setAsViewModelQuery(boolean setUnsetValue) {
        this.setPropertyValue(PROP_ASVIEW_MODEL_QUERY, setUnsetValue);
    }

    public boolean isAsViewModelQuery() {
        Boolean asViewModelQuery = (Boolean)this.getPropertyValue(PROP_ASVIEW_MODEL_QUERY);
        if (asViewModelQuery == null) {
            return false;
        }
        return asViewModelQuery;
    }

    public void addToProjectionList(PlanningEnvironment environment, RQPDataItem node) {
        this.addToListOfType(environment, 801016, node);
        Map projections = (Map)this.getPropertyValue(PROJECTIONS);
        if (projections != null) {
            projections.put(node.getName(), node);
        }
    }

    public void addToGroupByList(PlanningEnvironment environment, IXQEQueryNode node) {
        this.addToListOfType(environment, 801013, node);
    }

    public void addToSortList(PlanningEnvironment environment, IXQEQueryNode node) {
        if (null == node.getPropertyValue("explicitSort")) {
            this.addToListOfType(environment, 801020, node);
            return;
        }
        IXQEQueryNode listNode = this.getOrCreateList(environment, 801020);
        ((RQPSortList)listNode).addChildOfExplicitSort(node);
    }

    private void addToListOfType(PlanningEnvironment environment, int listID, IXQEQueryNode node) {
        IXQEQueryNode listNode = this.getOrCreateList(environment, listID);
        listNode.addChild(node);
    }

    public IXQEQueryNode getOrCreateList(PlanningEnvironment environment, int listType) {
        IXQEQueryNode listNode = this.getFirstChildByType(listType);
        if (listNode == null) {
            listNode = environment.getNodeFactory().createNode(listType);
            this.addChild(listNode);
        }
        return listNode;
    }

    public V5Query getRefV5Query() {
        V5QuerySet v5QuerySet;
        String refquery = (String)this.getPropertyValue("refQuery");
        if (refquery != null && !refquery.equals("") && (v5QuerySet = (V5QuerySet)this.getAncestorOfType(101002)) != null) {
            return v5QuerySet.getV5Query(refquery);
        }
        return null;
    }

    public boolean isAutoSummaryTRUE() {
        Boolean autoSummary = (Boolean)this.getPropertyValue("autoSummary");
        if (autoSummary == null) {
            return true;
        }
        return autoSummary;
    }

    public boolean isAutoSummaryFALSE() {
        return !this.isAutoSummaryTRUE();
    }

    public RQPTabularQuery createDefaultTabularQuery(PlanningEnvironment env) {
        return (RQPTabularQuery)this.createQueryAndAddToSubqueryList(env, 801025, true);
    }

    public RQPSummaryQuery createDefaultSummaryQuery(PlanningEnvironment env) {
        return (RQPSummaryQuery)this.createQueryAndAddToSubqueryList(env, 801024, true);
    }

    public RQPBridgeTabularQuery createDefaultBridgeTabularQuery(PlanningEnvironment env) {
        return (RQPBridgeTabularQuery)this.createQueryAndAddToSubqueryList(env, 801051, true);
    }

    public IXQEQueryNode createQueryAndAddToSubqueryList(PlanningEnvironment env, int queryType, boolean addAtBeginning) {
        IXQEQueryNode subquery = env.getNodeFactory().createNode(queryType);
        ((RQPQuery)subquery).setName(this.generateQueryName(subquery.getType()));
        this.addToSubqueryList(env, subquery, addAtBeginning);
        return subquery;
    }

    public void addToSubqueryList(PlanningEnvironment env, IXQEQueryNode subquery, boolean addAtBeginning) {
        RQPSubqueryList subqueryList = (RQPSubqueryList)this.getFirstChildByType(801022);
        if (subqueryList == null) {
            subqueryList = (RQPSubqueryList)env.getNodeFactory().createNode(801022);
            this.addChild(subqueryList);
        }
        if (addAtBeginning) {
            subqueryList.addChild(subquery, 0);
        } else {
            subqueryList.addChild(subquery);
        }
    }

    public void addToSubqueryList(PlanningEnvironment env, IXQEQueryNode subquery, boolean addAtBeginning, String suggestedName) {
        String queryName = this.generateUniqueQueryName(suggestedName);
        ((RQPQuery)subquery).setName(queryName);
        this.addToSubqueryList(env, subquery, addAtBeginning);
    }

    private String generateUniqueQueryName(String suggestedName) {
        RQPSubqueryList subqueryList = (RQPSubqueryList)this.getFirstChildByType(801022);
        if (subqueryList == null || subqueryList.getNumberChildren() == 0) {
            return suggestedName;
        }
        HashSet<String> names = new HashSet<String>();
        for (IXQEQueryNode sq : subqueryList.getChildren()) {
            RQPQuery query = (RQPQuery)sq;
            names.add(query.getName());
        }
        String queryName = suggestedName;
        int i = 0;
        while (names.contains(queryName)) {
            queryName = suggestedName + ++i;
        }
        return queryName;
    }

    public void setNeedToRecreateLLSQ(boolean b) {
        this.setPropertyValue(RECREATE_LLSQ, b);
    }

    public boolean getNeedToRecreateLLSQ() {
        Boolean b = (Boolean)this.getPropertyValue(RECREATE_LLSQ);
        if (b == null) {
            return false;
        }
        return b;
    }

    public String generateQueryName(int queryType) {
        String prefix = null;
        switch (queryType) {
            case 801025: {
                prefix = "TQ";
                break;
            }
            case 801024: {
                prefix = "SQ";
                break;
            }
            case 801051: {
                prefix = "BQ";
                break;
            }
            case 801012: {
                prefix = "FQ";
                break;
            }
            case 801017: {
                prefix = "RQ";
                break;
            }
            default: {
                prefix = "NOQUERYNAME";
            }
        }
        int queryCountByType = 0;
        if (this.getSubqueryList() != null) {
            queryCountByType = this.getSubqueryList().getNumberChildrenOfType(queryType);
        }
        StringBuilder sb = new StringBuilder(this.getGeneratedName(this.getSubqueryList(), prefix, queryCountByType));
        sb.append("_");
        sb.append(this.getName());
        return sb.toString();
    }

    public IXQEQueryNode getSubqueryList() {
        return this.getFirstChildByType(801022);
    }

    public RQPTabularQuery getDefaultTabularQuery() {
        return (RQPTabularQuery)this.getFirstSubqueryByType(801025);
    }

    public RQPSummaryQuery getDefaultSummaryQuery() {
        return (RQPSummaryQuery)this.getFirstSubqueryByType(801024);
    }

    public RQPBridgeTabularQuery getDefaultBridgeTabularQuery() {
        return (RQPBridgeTabularQuery)this.getFirstSubqueryByType(801051);
    }

    public RQPFactManager getFactManager() {
        return (RQPFactManager)this.getFirstChildByType(801042);
    }

    public IXQEQueryNode getFirstSubqueryByType(int queryType) {
        RQPSubqueryList subqueryList = (RQPSubqueryList)this.getFirstChildByType(801022);
        if (subqueryList == null) {
            return null;
        }
        return subqueryList.getFirstChildByType(queryType);
    }

    public RQPQuery getSubquery(String queryName) {
        SQLFromClause sqlFromClause;
        RQPSubqueryList subqueryList = (RQPSubqueryList)this.getSubqueryList();
        if (subqueryList != null) {
            RQPQuery subquery;
            int i;
            int numSubqueries = subqueryList.getNumberChildren();
            for (i = 0; i < numSubqueries; ++i) {
                subquery = (RQPQuery)subqueryList.getChild(i);
                if (!subquery.getName().equals(queryName)) continue;
                return subquery;
            }
            for (i = 0; i < numSubqueries; ++i) {
                subquery = (RQPQuery)subqueryList.getChild(i);
                if (subquery.getNodeType() != 801017 || (subquery = subquery.getSubquery(queryName)) == null) continue;
                return subquery;
            }
        }
        if ((sqlFromClause = (SQLFromClause)this.getFirstChildByType(301043)) != null) {
            List<IXQEQueryNode> allRangeVars = sqlFromClause.getDescendantsOfTypeOrdered(301007, false, 301059);
            for (IXQEQueryNode r : allRangeVars) {
                IXQEQueryNode[] query;
                SQLRangeVar sqlRangeVar = (SQLRangeVar)r;
                if (!sqlRangeVar.getName().equals(queryName) || (query = sqlRangeVar.getChildrenOfTypes(QUERY_TYPES)).length == 0) continue;
                return (RQPQuery)query[0];
            }
        }
        return null;
    }

    public RQPSortList getOrCreateRQPSortList(PlanningEnvironment environment) {
        RQPSortList rqpSortList = (RQPSortList)this.getFirstChildByType(801020);
        if (rqpSortList == null) {
            rqpSortList = RQPSortList.create(environment);
            this.addChild(rqpSortList);
        }
        return rqpSortList;
    }

    public RQPSummaryQuery getOrCreateDefaultSummaryQuery(PlanningEnvironment environment) {
        RQPSummaryQuery rqpSummaryQuery = this.getDefaultSummaryQuery();
        if (rqpSummaryQuery == null) {
            rqpSummaryQuery = this.createDefaultSummaryQuery(environment);
        }
        return rqpSummaryQuery;
    }

    public RQPQuery getOrCreateAnalyticSubquery(PlanningEnvironment environment) {
        IXQEQueryNode[] subQueries;
        for (IXQEQueryNode subQuery : subQueries = this.getSubqueryList().getChildren()) {
            RQPQuery rqpSubQuery = (RQPQuery)subQuery;
            if (rqpSubQuery.getBooleanPropertyValue(PROP_ANALYTIC_SUBQUERY) == null) continue;
            return rqpSubQuery;
        }
        RQPSummaryQuery rqpSubQuery = this.createSummaryQuery(environment);
        rqpSubQuery.setPropertyValue(PROP_ANALYTIC_SUBQUERY, true);
        return rqpSubQuery;
    }

    public boolean isAnalyticSubquery() {
        return this.getBooleanPropertyValue(PROP_ANALYTIC_SUBQUERY) != null;
    }

    public RQPBridgeTabularQuery getOrCreateDefaultBridgeTabularQuery(PlanningEnvironment environment) {
        RQPBridgeTabularQuery rqpBridgeTabularQuery = this.getDefaultBridgeTabularQuery();
        if (rqpBridgeTabularQuery == null) {
            rqpBridgeTabularQuery = this.createDefaultBridgeTabularQuery(environment);
        }
        return rqpBridgeTabularQuery;
    }

    public void incrementNumReferences() {
        int numReferences = this.getNumReferences();
        this.setNumReferences(++numReferences);
    }

    public void setNumReferences(int numReferences) {
        this.setPropertyValue(PROP_STRING_NUM_TIMES_REFERENCED, numReferences);
    }

    public int getNumReferences() {
        Integer numReferences = this.getIntegerPropertyValue(PROP_STRING_NUM_TIMES_REFERENCED);
        if (numReferences == null) {
            return 0;
        }
        return numReferences;
    }

    public void removeSubqueryList() {
        this.detachChild(this.getSubqueryList());
    }

    public RQPDataItem findProjection(String name) {
        RQPDataItem proj;
        IXQEQueryNode projectionList = this.getFirstChildByType(801016);
        if (projectionList == null) {
            return null;
        }
        HashMap<String, RQPDataItem> projections = (HashMap<String, RQPDataItem>)this.getPropertyValue(PROJECTIONS);
        if (projections != null && (proj = (RQPDataItem)projections.get(name)) != null) {
            if (proj.getParent() == projectionList) {
                return proj;
            }
            projections.remove(name);
        }
        int numProj = projectionList.getNumberChildren();
        RQPDataItem foundProjection = null;
        for (int i = 0; i < numProj; ++i) {
            IXQEQueryNode child = projectionList.getChild(i);
            if (child.getType() == 301028) {
                child = child.getChild(0);
            }
            if (child.getType() != 801008) continue;
            RQPDataItem projection = (RQPDataItem)child;
            if (numProj > 50) {
                if (projections == null) {
                    projections = new HashMap<String, RQPDataItem>();
                    this.setPropertyValue(PROJECTIONS, projections);
                    projections.put(projection.getName(), projection);
                } else {
                    projections.put(projection.getName(), projection);
                }
            }
            if (!projection.getName().equals(name)) continue;
            foundProjection = projection;
            if (numProj > 50) continue;
            return projection;
        }
        return foundProjection;
    }

    public RQPDataItem findDetailProjection(String name) {
        IXQEQueryNode projectionList = this.getFirstChildByType(801016);
        if (projectionList == null) {
            return null;
        }
        for (int i = 0; i < projectionList.getNumberChildren(); ++i) {
            RQPDataItem projection;
            IXQEQueryNode child = projectionList.getChild(i);
            if (child.getType() == 301028) {
                child = child.getChild(0);
            }
            if (child.getType() != 801008 || (projection = (RQPDataItem)child).isFooterHeaderItem() || !projection.getOriginalName().equals(name)) continue;
            return projection;
        }
        return null;
    }

    public IXQEQueryNode[] getGroupingItems() {
        IXQEQueryNode groupByList = this.getFirstChildByType(801013);
        if (groupByList == null) {
            return null;
        }
        return groupByList.getChildren();
    }

    public boolean isSummarizedQuery() {
        return this.getType() == 801024 || this.getType() == 801012;
    }

    public boolean isTabularQuery() {
        return this.getType() == 801025;
    }

    public boolean containsJoins() {
        IXQEQueryNode joinList = this.getFirstChildByType(801014);
        return joinList != null && joinList.getNumberChildren() > 0;
    }

    public RQPSummaryQuery createSummaryQuery(PlanningEnvironment env) {
        return (RQPSummaryQuery)this.createQueryAndAddToSubqueryList(env, 801024, false);
    }

    public RQPDataItem getRQPDataItemWithSameExpression(IXQEQueryNode expression, V5ValueSet valueSet) {
        IXQEQueryNode projectionListNode = this.getFirstChildByType(801016);
        if (projectionListNode == null) {
            return null;
        }
        IXQEQueryNode[] children = projectionListNode.getChildren();
        for (int i = 0; i < children.length; ++i) {
            RQPDataItem dataItem = children[i].getType() == 301028 ? (RQPDataItem)children[i].getChild(0) : (RQPDataItem)children[i];
            IXQEQueryNode rqpDataItemExpr = dataItem.getChild(0);
            if (!rqpDataItemExpr.isSameExpression(expression, false)) continue;
            if (valueSet != null) {
                V5ValueSet diValueSet = dataItem.getValueSet();
                if (valueSet != diValueSet) continue;
                return dataItem;
            }
            return dataItem;
        }
        return null;
    }

    public RQPDataItem getRQPDataItemWithSameExpression(IXQEQueryNode expression) {
        V5ValueSet valueSet = null;
        return this.getRQPDataItemWithSameExpression(expression, valueSet);
    }

    public RQPProjectionList getProjectionList() {
        return (RQPProjectionList)this.getFirstChildByType(801016);
    }

    public RQPSummaryFilterList getRQPSummaryFilterList() {
        return (RQPSummaryFilterList)this.getFirstChildByType(801023);
    }

    public RQPDataItem getRQPDataItem(PlanningEnvironment environment, IXQEQueryNode dataItemExpr, String dataItemName) {
        RQPDataItem rqpDataItem = this.getRQPDataItemWithSameExpression(dataItemExpr);
        if (rqpDataItem == null) {
            rqpDataItem = this.createProjectionWithUniqueName(environment, dataItemExpr, dataItemName);
        }
        return rqpDataItem;
    }

    public RQPDataItem createProjectionWithUniqueName(PlanningEnvironment environment, IXQEQueryNode projExpr, String suggestedName) {
        String rqpDataItemName = projExpr.getType() == 201116 ? ((V5BoundModelIdentifier)projExpr).getMetadata().getName() : (suggestedName != null ? suggestedName : STR_NEW_PROJECTION_NAME);
        RQPDataItem rqpDataItem = RQPDataItem.create(environment, RQPNameGenerator.generateUniqueRQPDataItemName(this, rqpDataItemName));
        rqpDataItem.copyPropertiesFrom(projExpr);
        IXQEQueryNode dataItemExprCloned = environment.getNodeFactory().deepCopyNode(projExpr);
        rqpDataItem.addChild(dataItemExprCloned);
        this.addToProjectionList(environment, rqpDataItem);
        return rqpDataItem;
    }

    public RQPDataItem getRQPDataItem(PlanningEnvironment environment, IXQEQueryNode dataItemExpr, RQPDataItem template) {
        RQPDataItem dataItem = this.getRQPDataItemWithSameExpression(dataItemExpr);
        if (dataItem == null) {
            dataItem = this.createRQPDataItem(environment, template.getName());
            dataItem.copyPropertiesFrom(template);
            dataItem.addChild(environment.getNodeFactory().deepCopyNode(dataItemExpr));
        }
        return dataItem;
    }

    public RQPProjectionList getOrCreateProjectionList(PlanningEnvironment environment) {
        return (RQPProjectionList)this.getOrCreateList(environment, 801016);
    }

    public RMQueryList createRMQueryList(PlanningEnvironment environment) {
        RMQueryList rmQueryList = (RMQueryList)this.getFirstChildByType(801032);
        if (rmQueryList == null) {
            rmQueryList = (RMQueryList)environment.getNodeFactory().createNode(801032);
            this.addChild(rmQueryList);
        }
        boolean explicitShortcutProcessing = RQPUtilities.getShortcutProcessing(environment);
        rmQueryList.setExplicitShortcutProcessing(explicitShortcutProcessing);
        return rmQueryList;
    }

    public void createFactManager(PlanningEnvironment environment) {
        RQPFactManager factManager = (RQPFactManager)this.getFirstChildByType(801042);
        if (factManager == null) {
            factManager = (RQPFactManager)environment.getNodeFactory().createNode(801042);
            factManager.create(environment);
            this.addChild(factManager);
        }
    }

    public RMQueryList getRMQueryList() {
        RMQueryList rmQueryList = (RMQueryList)this.getFirstChildByType(801032);
        return rmQueryList;
    }

    public RQPGroupByList getOrCreateGroupbyList(PlanningEnvironment environment) {
        return (RQPGroupByList)this.getOrCreateList(environment, 801013);
    }

    public RQPQuery getLowestLevelSummaryQuery() {
        RQPQuery lowestLevelSQ = this.getParentRQPQuery().getLowestLevelSummaryQueryProperty();
        if (lowestLevelSQ != null) {
            return lowestLevelSQ;
        }
        return this.findExistingLowestLevelSummaryQuery();
    }

    private RQPSummaryQuery findExistingLowestLevelSummaryQuery() {
        IXQEQueryNode subqueryList = this.getParentRQPQuery().getSubqueryList();
        for (int i = 0; i < subqueryList.getNumberChildren(); ++i) {
            RQPProjectionList projList;
            RQPQuery subquery = (RQPQuery)subqueryList.getChild(i);
            if (!subquery.isSummarizedQuery() || (projList = subquery.getProjectionList()) == null || projList.getNumberChildren() == 0 || !this.allOtherSummaryQueriesGroupByListSubsetOf((RQPSummaryQuery)subquery)) continue;
            return (RQPSummaryQuery)subquery;
        }
        return null;
    }

    private boolean allOtherSummaryQueriesGroupByListSubsetOf(RQPSummaryQuery summaryQuery) {
        RQPQuery rootQuery = summaryQuery.getParentRQPQuery();
        IXQEQueryNode subqueryList = rootQuery.getSubqueryList();
        ArrayList<RQPQuery> subQueries = new ArrayList<RQPQuery>();
        for (int i = 0; i < subqueryList.getNumberChildren(); ++i) {
            RQPQuery subquery = (RQPQuery)subqueryList.getChild(i);
            subQueries.add(subquery);
        }
        return RQPQuery.allOtherSummaryQueriesGroupByListSubsetOf(summaryQuery, subQueries);
    }

    public static boolean allOtherSummaryQueriesGroupByListSubsetOf(RQPSummaryQuery summaryQuery, List<RQPQuery> subQueriesToJoin) {
        for (RQPQuery subquery : subQueriesToJoin) {
            if (!subquery.isSummarizedQuery() || subquery == summaryQuery || ((RQPSummaryQuery)subquery).groupingColumnsAreSubsetOf(summaryQuery)) continue;
            return false;
        }
        return true;
    }

    public RQPQuery getLowestLevelSummaryQueryProperty() {
        String lowestLevelSQName = (String)this.getParentRQPQuery().getPropertyValue(PROP_LOWEST_LEVEL_SUMMARYQUERY);
        if (lowestLevelSQName != null) {
            return this.getParentRQPQuery().getSubquery(lowestLevelSQName);
        }
        return null;
    }

    public void setLowestLevelSummaryQueryProperty(RQPQuery lowestLevelSummaryQuery) {
        if (lowestLevelSummaryQuery == null) {
            this.getParentRQPQuery().removeProperty(PROP_LOWEST_LEVEL_SUMMARYQUERY);
        } else {
            this.getParentRQPQuery().setPropertyValue(PROP_LOWEST_LEVEL_SUMMARYQUERY, lowestLevelSummaryQuery.getName());
        }
    }

    public IXQEQueryNode addToDetailFilterList(PlanningEnvironment environment, IXQEQueryNode filterExpression) {
        IXQEQueryNode detailFilterList = this.getOrCreateList(environment, 801011);
        detailFilterList.addChild(filterExpression);
        return detailFilterList;
    }

    public void addToSummaryFilterList(PlanningEnvironment environment, IXQEQueryNode filterExpression) {
        IXQEQueryNode summaryFilterList = this.getOrCreateList(environment, 801023);
        summaryFilterList.addChild(filterExpression);
    }

    public List<RQPQuery> getSubqueriesToJoin() {
        List<RQPQuery> subquerySources = this.getSubquerySources();
        ArrayList<RQPQuery> subqueriesToJoin = new ArrayList<RQPQuery>();
        for (RQPQuery rqpQuery : subquerySources) {
            if (rqpQuery.getType() == 801024 || rqpQuery.getType() == 801012) {
                RQPSummaryQuery summaryQuery = (RQPSummaryQuery)rqpQuery;
                if (!summaryQuery.hasGroupBy() && !summaryQuery.isAnalyticSubquery()) continue;
                subqueriesToJoin.add(rqpQuery);
                continue;
            }
            subqueriesToJoin.add(rqpQuery);
        }
        return subqueriesToJoin;
    }

    public List<RQPQuery> getSubquerySources() {
        int[] listsToCheck = new int[]{801016, 801011, 801023};
        TreeSet<String> queryNames = new TreeSet<String>();
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode listChild = this.getFirstChildByType(listsToCheck[i]);
            if (listChild == null) continue;
            List<IXQEQueryNode> dataItemRefs = listChild.getDescendantsOfTypeOrdered(801009, 801017);
            for (int j = 0; j < dataItemRefs.size(); ++j) {
                RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs.get(j);
                queryNames.add(dataItemRef.getQueryName());
            }
        }
        RQPQuery rootQuery = this.getParentRQPQuery();
        ArrayList<RQPQuery> subquerySources = new ArrayList<RQPQuery>();
        Iterator it = queryNames.iterator();
        while (it.hasNext()) {
            subquerySources.add(rootQuery.getSubquery((String)it.next()));
        }
        IXQEQueryNode subqList = this.getSubqueryList();
        if (subqList != null) {
            IXQEQueryNode[] subqs;
            for (IXQEQueryNode sub : subqs = subqList.getChildrenOfTypes(new int[]{801012, 801024})) {
                IXQEQueryNode summaryFilterList;
                if (subquerySources.contains(sub) || (summaryFilterList = sub.getFirstChildByType(801023)) == null || null == sub.getFirstChildByType(801013)) continue;
                subquerySources.add((RQPQuery)sub);
            }
        }
        return subquerySources;
    }

    public RQPDataItem createRQPDataItem(PlanningEnvironment environment, String preferredName) {
        RQPDataItem rqpDataItem = RQPDataItem.create(environment, RQPNameGenerator.generateUniqueRQPDataItemName(this, preferredName));
        rqpDataItem.setOriginalName(preferredName);
        this.addToProjectionList(environment, rqpDataItem);
        return rqpDataItem;
    }

    public RQPDataItem createRQPDataItemFromV5DataItem(PlanningEnvironment environment, V5DataItem v5DataItem) {
        RQPDataItem rqpDataItem = RQPDataItem.create(environment, RQPNameGenerator.generateUniqueRQPDataItemName(this, v5DataItem.getNameProperty()), v5DataItem);
        rqpDataItem.setOriginalName(v5DataItem.getNameProperty());
        this.addToProjectionList(environment, rqpDataItem);
        return rqpDataItem;
    }

    public RQPFooterQuery createFooterQuery(PlanningEnvironment environment) {
        return (RQPFooterQuery)this.createQueryAndAddToSubqueryList(environment, 801012, false);
    }

    public boolean isSummaryQueryToAvoidDoubleCounting() {
        String avoidDoubleCountingSQName = (String)this.getParentRQPQuery().getPropertyValue(PROP_AVOID_DOUBLECOUNTING_SUMMARYQUERY);
        if (avoidDoubleCountingSQName != null) {
            return (RQPSummaryQuery)this.getParentRQPQuery().getSubquery(avoidDoubleCountingSQName) == this;
        }
        return false;
    }

    public void setCanRewriteAsWindowedAggregates(boolean value) {
        this.setPropertyValue(PROP_CANREWRITEASWINDOWEDAGGREGATES, value);
    }

    public boolean getCanRewriteAsWindowedAggregates() {
        Boolean propValue = this.getBooleanPropertyValue(PROP_CANREWRITEASWINDOWEDAGGREGATES);
        return propValue != null && propValue != false;
    }

    public boolean hasPropertyCanRewriteAsWindowedAggregates() {
        return this.getBooleanPropertyValue(PROP_CANREWRITEASWINDOWEDAGGREGATES) != null;
    }

    public RQPQuery getOnlySubquerySourceOfParentQuery() {
        int[] listsToCheck = new int[]{801016, 801011, 801023};
        RQPQuery rootQuery = this.getParentRQPQuery();
        RQPNode subquery = null;
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode listChild = this.getFirstChildByType(listsToCheck[i]);
            if (listChild == null) continue;
            IXQEQueryNode filter = (IXQEQueryNode)listChild.getPropertyValue("convertedFromJoinExpr");
            IXQEQueryNode[] modelIds = listChild.getDescendantsOfType(201116, false);
            if (modelIds.length > 0) {
                if (filter != null && listsToCheck[i] == 801011) {
                    for (IXQEQueryNode modelId : modelIds) {
                        if (modelId.isAncestor(filter)) continue;
                        return null;
                    }
                } else {
                    return null;
                }
            }
            IXQEQueryNode[] dataItemRefs = listChild.getDescendantsOfType(801009, false);
            for (int j = 0; j < dataItemRefs.length; ++j) {
                RQPDataItemRef dataItemRef = (RQPDataItemRef)dataItemRefs[j];
                if (subquery == null) {
                    subquery = rootQuery.getSubquery(dataItemRef.getQueryName());
                    continue;
                }
                if (dataItemRef.getQueryName().equals(subquery.getName())) continue;
                return null;
            }
        }
        return subquery;
    }

    public void registerRowsetNameAndColumnName(PlanningEnvironment environment, String rowsetName, String columnName) {
        RQPProjectionList rootQueryProjectionList = (RQPProjectionList)this.getOrCreateList(environment, 801016);
        rootQueryProjectionList.registerRowsetNameAndColumnName(rootQueryProjectionList.getNumberChildren() - 1, rowsetName, columnName);
    }

    public RQPDataItem getRQPDataItemByName(String name) {
        RQPProjectionList projectionList = this.getProjectionList();
        if (projectionList == null) {
            return null;
        }
        IXQEQueryNode[] iXQEQueryNodeArray = projectionList.getChildren();
        int n = iXQEQueryNodeArray.length;
        for (int i = 0; i < n; ++i) {
            IXQEQueryNode child;
            IXQEQueryNode rqpDi = child = iXQEQueryNodeArray[i];
            while (rqpDi != null && rqpDi.getType() != 801008) {
                if (rqpDi.getNumberChildren() > 0) {
                    rqpDi = rqpDi.getChild(0);
                    continue;
                }
                rqpDi = null;
            }
            if (rqpDi == null || !((RQPDataItem)rqpDi).getName().equals(name)) continue;
            return (RQPDataItem)rqpDi;
        }
        return null;
    }

    public RQPDataItem createProjection(PlanningEnvironment environment, String preferredName, IXQEQueryNode projExpr) {
        RQPDataItem projRQPDataItem = RQPDataItem.create(environment, preferredName);
        projRQPDataItem.addChild(projExpr);
        this.addToProjectionList(environment, projRQPDataItem);
        return projRQPDataItem;
    }

    public boolean v5ProjectionHasMovingOrRunning() {
        RQPProjectionList projList = this.getProjectionList();
        Boolean hasMRProp = projList.getHasMovingRunningProperty();
        if (hasMRProp != null) {
            return hasMRProp;
        }
        HashSet<V5DataItem> v5DataItems = RQPUtilities.getV5ProjectionItems(this);
        Iterator<V5DataItem> it = v5DataItems.iterator();
        while (it.hasNext()) {
            if (!RQPUtilities.hasMovingRunningInExpression(it.next())) continue;
            projList.setHasMovingRunningProperty(Boolean.TRUE);
            return true;
        }
        projList.setHasMovingRunningProperty(Boolean.FALSE);
        return false;
    }

    public boolean hasReferencesToQuery(RQPQuery queryOfAggregate) {
        HashMap<RQPQuery, String> refQueries = (HashMap<RQPQuery, String>)this.getPropertyValue(REFERENCED_QUERIES);
        if (refQueries == null) {
            refQueries = new HashMap<RQPQuery, String>();
            this.setPropertyValue(REFERENCED_QUERIES, refQueries);
        }
        String referenced = "isTrue";
        String value = (String)refQueries.get(queryOfAggregate);
        if (value == null) {
            if (this.hasReferencesToQuery(queryOfAggregate, new HashSet<RQPQuery>())) {
                refQueries.put(queryOfAggregate, referenced);
                return true;
            }
            refQueries.put(queryOfAggregate, "isFalse");
            return false;
        }
        return referenced.equals(value);
    }

    private boolean hasReferencesToQuery(RQPQuery queryOfAggregate, Set<RQPQuery> seenQueries) {
        if (seenQueries.contains(this)) {
            return false;
        }
        seenQueries.add(this);
        HashSet<RQPQuery> queries = new HashSet<RQPQuery>();
        RQPProjectionList projection = this.getProjectionList();
        if (this.hasReferencesToQuery(queryOfAggregate, queries, projection)) {
            return true;
        }
        RQPDetailFilterList detailFilter = this.getDetailFilterList();
        if (detailFilter != null && this.hasReferencesToQuery(queryOfAggregate, queries, detailFilter)) {
            return true;
        }
        RQPSummaryFilterList summaryFilter = this.getSummaryFilterList();
        if (summaryFilter != null && this.hasReferencesToQuery(queryOfAggregate, queries, summaryFilter)) {
            return true;
        }
        for (RQPQuery query : queries) {
            if (!query.hasReferencesToQuery(queryOfAggregate, seenQueries)) continue;
            return true;
        }
        return false;
    }

    private boolean hasReferencesToQuery(RQPQuery queryOfAggregate, Set<RQPQuery> queries, RQPNode parent) {
        IXQEQueryNode[] nodes;
        for (IXQEQueryNode node : nodes = parent.getDescendantsOfType(801009, false)) {
            RQPQuery refQuery = ((RQPDataItemRef)node).getQuery();
            if (refQuery == queryOfAggregate) {
                return true;
            }
            queries.add(refQuery);
        }
        return false;
    }

    public void createJoinInfo(PlanningEnvironment environment) {
        RQPJoinInfo joinInfo = (RQPJoinInfo)environment.getNodeFactory().createNode(801046);
        this.addChild(joinInfo);
        joinInfo.createRepositoryInfo(environment.getMetadataConnection());
    }

    public boolean isMultiFactQuery() {
        RQPFactManager factManager = this.getFactManager();
        if (factManager == null) {
            return false;
        }
        return factManager.isMultiFact();
    }

    public boolean isUsingBridge() {
        RQPFactManager factManager = this.getFactManager();
        if (factManager == null) {
            return false;
        }
        return factManager.isUsingBridge();
    }

    public boolean isSubqueryForSummaryFilters() {
        return this.getPropertyValue(PROP_SUBQUERY_FOR_SUMMARYFILTERS) != null;
    }

    public void setIsSubqueryForSummaryFilters() {
        this.setPropertyValue(PROP_SUBQUERY_FOR_SUMMARYFILTERS, true);
    }

    public List<IXQEQueryNode> getDataItemRefs() {
        int[] listsToCheck = new int[]{801016, 801011, 801023, 801022};
        ArrayList<IXQEQueryNode> refs = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode listChild = this.getFirstChildByType(listsToCheck[i]);
            if (listChild == null) continue;
            IXQEQueryNode[] dataItemRefs = listChild.getDescendantsOfType(801009, false);
            refs.addAll(Arrays.asList(dataItemRefs));
        }
        return refs;
    }

    public RQPDataItemRef[] getDataItemRefsTo(RQPDataItem projection) {
        int[] listsToCheck = new int[]{801016, 801011, 801023, 801022};
        ArrayList<RQPDataItemRef> refs = new ArrayList<RQPDataItemRef>();
        for (int i = 0; i < listsToCheck.length; ++i) {
            IXQEQueryNode[] dataItemRefs;
            IXQEQueryNode listChild = this.getFirstChildByType(listsToCheck[i]);
            if (listChild == null) continue;
            for (IXQEQueryNode r : dataItemRefs = listChild.getDescendantsOfType(801009, false)) {
                RQPDataItemRef ref = (RQPDataItemRef)r;
                if (!ref.isReferenceTo(projection)) continue;
                refs.add(ref);
            }
        }
        if (refs.size() > 0) {
            return refs.toArray(new RQPDataItemRef[refs.size()]);
        }
        return null;
    }

    public RQPQuery getSubqueryForSummaryFilters() {
        RQPSubqueryList subqueryList = (RQPSubqueryList)this.getSubqueryList();
        for (int i = 0; i < subqueryList.getNumberChildren(); ++i) {
            RQPQuery subq = (RQPQuery)subqueryList.getChild(i);
            if (!subq.isSubqueryForSummaryFilters()) continue;
            return subq;
        }
        return null;
    }

    public RQPQuery createQueryWrapper(PlanningEnvironment environment, String subQueryName) {
        IXQEQueryNode[] alias;
        RQPQuery rqpQuery = (RQPQuery)environment.getNodeFactory().createNode(801017);
        rqpQuery.setName(this.getName());
        IXQEQueryNode rqpProjectionList = environment.getNodeFactory().createNode(801016);
        IXQEQueryNode sqlFromClause = environment.getNodeFactory().createNode(301043);
        rqpQuery.addChild(rqpProjectionList);
        rqpQuery.addChild(sqlFromClause);
        SQLRangeVar rangeVar = (SQLRangeVar)environment.getNodeFactory().createNode(301007);
        rangeVar.setName(subQueryName);
        sqlFromClause.addChild(rangeVar);
        this.setName(subQueryName);
        this.move(rangeVar);
        for (IXQEQueryNode a : alias = this.getProjectionList().getChildren()) {
            SQLAlias sqlAlias = (SQLAlias)a;
            String aliasName = sqlAlias.getName();
            SQLAlias aliasCopy = (SQLAlias)environment.getNodeFactory().createNode(301028);
            RQPDataItem srcDI = (RQPDataItem)sqlAlias.getChild(0);
            RQPDataItem di = RQPDataItem.create(environment, srcDI.getName());
            SQLColumn columnCopy = (SQLColumn)environment.getNodeFactory().createNode(301005);
            di.addChild(columnCopy);
            aliasCopy.addChild(di);
            rqpProjectionList.addChild(aliasCopy);
            aliasCopy.setName(aliasName);
            columnCopy.setName(aliasName);
            columnCopy.setTableName(subQueryName);
        }
        return rqpQuery;
    }

    public List<IXQEQueryNode> getFilterOnUnProjectedItem() {
        ArrayList filters = (ArrayList)this.getPropertyValue(PROP_FILTER_ON_UNPROJECTEDITEM);
        if (filters == null) {
            filters = new ArrayList();
            this.setPropertyValue(PROP_FILTER_ON_UNPROJECTEDITEM, filters);
        }
        return filters;
    }

    public void setIsFactQuery() {
        this.setPropertyValue(PROP_ISFACTQUERY, true);
    }

    public boolean isFactQuery() {
        return this.getPropertyValue(PROP_ISFACTQUERY) != null;
    }

    public void setIsBridgeQuery() {
        this.setPropertyValue(PROP_ISBRIDGEQUERY, true);
    }

    public boolean isBridgeQuery() {
        return this.getPropertyValue(PROP_ISBRIDGEQUERY) == Boolean.TRUE;
    }

    public void setIsBridgeDataStream() {
        this.setPropertyValue(PROP_ISBRIDGEDATASTREAM, true);
    }

    public boolean isBridgeDataStream() {
        return this.getPropertyValue(PROP_ISBRIDGEDATASTREAM) == Boolean.TRUE;
    }

    public void setIsBridgeTabularQuery() {
        this.setPropertyValue(PROP_ISBRIDGETABULARQUERY, true);
    }

    public boolean isBridgeTabularQuery() {
        return this.getPropertyValue(PROP_ISBRIDGETABULARQUERY) == Boolean.TRUE;
    }

    public void setIsBridgeSummaryFilterQuery() {
        this.setPropertyValue(PROP_ISBRIDGESUMMARYFILTERQUERY, true);
    }

    public boolean isBridgeSummaryFilterQuery() {
        return this.getPropertyValue(PROP_ISBRIDGESUMMARYFILTERQUERY) == Boolean.TRUE;
    }

    public boolean isBridgeWrapperQuery() {
        if (this.isBridgeSummaryFilterQuery()) {
            return false;
        }
        IXQEQueryNode subQueryList = this.getSubqueryList();
        if (subQueryList == null) {
            return false;
        }
        IXQEQueryNode bridgeTabularQuery = subQueryList.getFirstChildByType(801051);
        if (bridgeTabularQuery != null) {
            return true;
        }
        for (IXQEQueryNode subQuery : subQueryList.getChildren()) {
            RQPQuery query = (RQPQuery)subQuery;
            if (!query.isBridgeTabularQuery()) continue;
            return true;
        }
        return false;
    }

    public void addNonProjectedDataItemsFromLowestLevelSQ(PlanningEnvironment environment) {
        RQPQuery lowestLevelSQ = this.getLowestLevelSummaryQueryProperty();
        if (lowestLevelSQ == null) {
            return;
        }
        RQPProjectionList projListLLSQ = lowestLevelSQ.getProjectionList();
        if (projListLLSQ == null) {
            return;
        }
        RQPProjectionList projListNewRQPQuery = this.getProjectionList();
        if (projListNewRQPQuery == null) {
            return;
        }
        for (int i = 0; i < projListLLSQ.getNumberChildren(); ++i) {
            boolean found = false;
            RQPDataItem projLLSQ = (RQPDataItem)projListLLSQ.getChild(i);
            for (int j = 0; j < projListNewRQPQuery.getNumberChildren(); ++j) {
                if (!projLLSQ.isSameExpression(projListNewRQPQuery.getChild(j), false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            RQPDataItem newProj = this.createRQPDataItem(environment, projLLSQ.getName());
            RQPDataItemRef ref = RQPDataItemRef.create(environment, lowestLevelSQ.getName(), projLLSQ.getName());
            newProj.addChild(ref);
        }
    }

    public List<RQPDataItem> getProjectionsMarkedAsGroupingColumns() {
        ArrayList<RQPDataItem> groupingItems = new ArrayList<RQPDataItem>();
        RQPProjectionList projectionList = this.getProjectionList();
        for (IXQEQueryNode projection : projectionList.getChildren()) {
            RQPDataItem rqpDataItem = (RQPDataItem)projection;
            if (!rqpDataItem.isGroupingItem()) continue;
            groupingItems.add(rqpDataItem);
        }
        return groupingItems;
    }

    public boolean isLowestLevelSummaryQuery() {
        RQPQuery parentRQPQuery = this.getParentRQPQuery();
        return parentRQPQuery != null && parentRQPQuery.getLowestLevelSummaryQueryProperty() == this;
    }

    public RQPJoinPath getJoinPath() {
        return (RQPJoinPath)this.getFirstChildByType(801039);
    }

    public RQPDetailFilterList getDetailFilterList() {
        return (RQPDetailFilterList)this.getFirstChildByType(801011);
    }

    public RQPSummaryFilterList getSummaryFilterList() {
        return (RQPSummaryFilterList)this.getFirstChildByType(801023);
    }

    public RQPGroupByList getGroupByList() {
        return (RQPGroupByList)this.getFirstChildByType(801013);
    }

    public RQPDataItem getProjectionWithSameExprAsTheGroupingExpression(IXQEQueryNode groupingExpression) {
        RQPProjectionList projList = this.getProjectionList();
        for (int i = 0; i < projList.getNumberChildren(); ++i) {
            RQPDataItem projItem = (RQPDataItem)projList.getChild(i);
            if (!RQPSummaryQuery.isSameGroupingColumnExpression(groupingExpression, projItem.getExpression())) continue;
            return projItem;
        }
        return null;
    }

    public boolean hasNoProjections() {
        RQPProjectionList projectionList = this.getProjectionList();
        if (projectionList == null) {
            return true;
        }
        return projectionList.getNumberChildren() == 0;
    }

    public static RQPSummaryQuery createSummaryQueryWithSameScope(PlanningEnvironment environment, RQPQuery originalSummaryQuery) {
        RQPQuery parentRQPQuery = originalSummaryQuery.getParentRQPQuery();
        RQPSummaryQuery newSumQuery = parentRQPQuery.createSummaryQuery(environment);
        List<RQPDataItem> groupingColumns = originalSummaryQuery.getProjectionsMarkedAsGroupingColumns();
        for (RQPDataItem item : groupingColumns) {
            RQPDataItem newItem = newSumQuery.createRQPDataItem(environment, item.getName());
            newItem.copyPropertiesFrom(item);
            newItem.addChild(environment.getNodeFactory().deepCopyNode(item.getExpression()));
            RQPDataItemSelfRef selfRef = RQPDataItemSelfRef.create(environment, newItem.getName());
            newSumQuery.addToGroupByList(environment, selfRef);
        }
        return newSumQuery;
    }

    public boolean isSubqueryToAvoidDoubleCounting() {
        return this.getPropertyValue(PROP_SUBQUERY_TO_AVOID_DOUBLE_COUNTING) != null;
    }

    public void setIsSubqueryToAvoidDoubleCounting() {
        this.setPropertyValue(PROP_SUBQUERY_TO_AVOID_DOUBLE_COUNTING, true);
    }

    public boolean hasAncestorRQPQueryToAvoidDoubleCounting() {
        for (RQPQuery parentRQPQuery = this.getParentRQPQuery(); parentRQPQuery != null; parentRQPQuery = (RQPQuery)parentRQPQuery.getAncestorOfType(801017)) {
            if (!parentRQPQuery.isSubqueryToAvoidDoubleCounting()) continue;
            return true;
        }
        return false;
    }

    public void setDistinct(boolean distinct) {
        this.setPropertyValue("distinct", distinct);
    }

    public boolean getDistinct() {
        Boolean bool = (Boolean)this.getPropertyValue("distinct");
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public RQPDetailFilterList getOrCreateDetailFilters(PlanningEnvironment environment) {
        return (RQPDetailFilterList)this.getOrCreateList(environment, 801011);
    }

    public void setJoinSelectionIsContextSensitive(boolean setUnsetValue) {
        this.setPropertyValue(PROP_JOINSELECTIONISCONTEXTSENSITIVE, setUnsetValue);
    }

    public boolean getJoinSelectionIsContextSensitive() {
        Boolean joinSelectionIsContextSensitive = (Boolean)this.getPropertyValue(PROP_JOINSELECTIONISCONTEXTSENSITIVE);
        if (joinSelectionIsContextSensitive == null) {
            return true;
        }
        return joinSelectionIsContextSensitive;
    }

    public void addToOriginalFolders(IMetadata folder) {
        if (this.originalFolders == null) {
            this.originalFolders = new HashSet<IMetadata>();
        }
        this.originalFolders.add(folder);
    }

    public void setAllJoinsForOuterMostQuery(List<IMetadata> allJoins) {
        this.allJoinsForOuterMostQuery = allJoins;
    }

    public List<IMetadata> getAllJoinsForOuterMostQuery() {
        return this.allJoinsForOuterMostQuery;
    }

    public void setJoinsForFactStream(List<IMetadata> joins) {
        this.setPropertyValue(PROP_JOINS_FOR_FACT_STREAM, joins);
    }

    public List<IMetadata> getJoinsForFactStream() {
        return (List)this.getPropertyValue(PROP_JOINS_FOR_FACT_STREAM);
    }

    public void setJoinsForBridge(List<IMetadata> joins) {
        this.setPropertyValue(PROP_JOINS_FOR_BRIDGE, joins);
    }

    public List<IMetadata> getJoinsForBridge() {
        return (List)this.getPropertyValue(PROP_JOINS_FOR_BRIDGE);
    }

    public Set<IMetadata> getOriginalFolders() {
        return this.originalFolders;
    }

    public boolean getsDataFromSubquery(RQPQuery subquery) {
        List<RQPQuery> subqueries = this.getSubquerySources();
        for (RQPQuery sq : subqueries) {
            if (sq != subquery) continue;
            return true;
        }
        return false;
    }

    public boolean hasSameGroupByList(RQPQuery otherQuery) {
        IXQEQueryNode[] groupingItems = this.getGroupingItems();
        IXQEQueryNode[] otherGroupingItems = otherQuery.getGroupingItems();
        if (groupingItems == null && otherGroupingItems == null) {
            return true;
        }
        if (groupingItems == null && otherGroupingItems.length == 0 || otherGroupingItems == null && groupingItems.length == 0) {
            return true;
        }
        return groupingItems != null && otherGroupingItems != null && groupingItems.length == otherGroupingItems.length && RQPSummaryQuery.groupingItemsAreSubsetOf(groupingItems, otherGroupingItems);
    }

    public void setIsMergedQuery() {
        this.setPropertyValue(PROP_MERGED_QUERY, "true");
    }

    public boolean getIsMergedQuery() {
        return null != this.getPropertyValue(PROP_MERGED_QUERY);
    }

    public boolean isSubQueryForInExpression() {
        return null != this.getPropertyValue(PROP_FOR_IN_EXPRESSION);
    }

    public String getQueryRefInINExpression() {
        return (String)this.getPropertyValue(PROP_QUERY_REF_IN_IN_EXPRESSION);
    }

    public static IXQEQueryNode[] getAllDescendantsOfTypeRQPQueryAndItsSubTypes(IXQEQueryNode node, boolean includeSelf) {
        return node.getDescendantsOfTypes(new int[]{801017, 801025, 801024, 801012}, includeSelf);
    }

    public RQPSummaryQuery findSumQueryCreatedFromSplitAndWithSameScope() {
        RQPQuery parentQuery = this.getParentRQPQuery();
        RQPSubqueryList subQueryList = (RQPSubqueryList)parentQuery.getSubqueryList();
        int numChildren = subQueryList.getNumberChildren();
        for (int i = 0; i < numChildren; ++i) {
            RQPQuery query = (RQPQuery)subQueryList.getChild(i);
            if (query == this || query.getPropertyValue(PROP_BOOL_FROM_SPLIT) == null || !this.hasSameGroupByList(query)) continue;
            return (RQPSummaryQuery)query;
        }
        return null;
    }

    @Override
    public SQLValueList getOutputList() {
        if (this.getNumberChildren() == 0) {
            return null;
        }
        return ((IOutputList)((Object)this.getChild(0))).getOutputList();
    }

    public boolean isSQSQuery() {
        return this.getPropertyValue(PROP_SQS_OWNER) != null;
    }

    public IQuerySubject getSQSOwner() {
        return (IQuerySubject)this.getPropertyValue(PROP_SQS_OWNER);
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 801017) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public void setCanRewriteInTermsOfLLSQ(boolean b) {
        this.setPropertyValue(CANREWRITEFROMLLSQ, b);
    }

    public boolean getCanRewriteInTermsOfLLSQ() {
        Boolean b = (Boolean)this.getPropertyValue(CANREWRITEFROMLLSQ);
        if (b == null) {
            return true;
        }
        return b;
    }

    public boolean isFooterHeaderInProjectionList() {
        IXQEQueryNode[] projs;
        RQPProjectionList projList = (RQPProjectionList)this.getFirstChildByType(801016);
        for (IXQEQueryNode proj : projs = projList.getChildrenOfType(801008)) {
            if (!((RQPDataItem)proj).isFooterHeaderItem()) continue;
            return true;
        }
        return false;
    }

    public boolean isRelalionalSubqueryForFirstAndLast() {
        V5Query query = this.getRefV5Query();
        if (query != null && query.isRelationalSubquery()) {
            RQPProjectionList projectionList = this.getProjectionList();
            if (projectionList == null) {
                return false;
            }
            for (IXQEQueryNode child : projectionList.getChildren()) {
                V5ValueAnalyticFunction af;
                if (child.getType() != 801008 || child.getChild(0) == null || child.getChild(0).getType() != 201033 || (af = (V5ValueAnalyticFunction)child.getChild(0)) == null || af.getSubType() != 12 && af.getSubType() != 13) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSubqueryForSelfRefCalcs() {
        Boolean bVal = this.getBooleanPropertyValue(PROP_BOOL_ISSUBQUERY_FOR_CALCS);
        if (bVal == null) {
            return false;
        }
        return bVal;
    }

    public void setIsSubqueryForCalcs(boolean b) {
        this.setPropertyValue(PROP_BOOL_ISSUBQUERY_FOR_CALCS, b);
    }

    public boolean isSubqueryForCalcsInQS() {
        return RQPQuery.isSubqueryForCalcsInQS(this);
    }

    public void setSubqueryForCalcsInQS(boolean b) {
        this.setPropertyValue(PROP_BOOL_ISSUBQUERY_FOR_CALCS_QS, b);
    }

    public static void setSubqueryForCalcsInQS(IXQEQueryNode node, boolean b) {
        node.setPropertyValue(PROP_BOOL_ISSUBQUERY_FOR_CALCS_QS, b);
    }

    public static boolean isSubqueryForCalcsInQS(IXQEQueryNode node) {
        Boolean bVal = node.getBooleanPropertyValue(PROP_BOOL_ISSUBQUERY_FOR_CALCS_QS);
        if (bVal == null) {
            return false;
        }
        return bVal;
    }

    private String getGeneratedName(IXQEQueryNode subqueryList, String prefix, int adjustedQueryCountByType) {
        String generatedName = prefix + adjustedQueryCountByType;
        if (subqueryList != null) {
            for (int i = 0; i < subqueryList.getNumberChildren(); ++i) {
                RQPQuery subquery = (RQPQuery)subqueryList.getChild(i);
                if (subquery.getName().indexOf(generatedName) == -1) continue;
                return this.getGeneratedName(subqueryList, prefix, adjustedQueryCountByType + 1);
            }
        }
        return generatedName;
    }
}

