/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.rqp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ScalarFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.MoveGroupingItemsToSubQuery;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.PushDetailExpressionToTabularQuery;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.List;

public class RQPTabularQuery
extends RQPQuery {
    public static final String PROP_BOOL_CANNOTBECOLLAPSED = "canNotBeCollapsed";
    public static final String PROP_SUMMARYFILTERLIST_TOBECONVERTED = "summaryFilterListToBeConvertedToDetailFilter";

    RQPTabularQuery() {
    }

    @Override
    public int getType() {
        return 801025;
    }

    public static void pushDetailExpressionsToTabularQuery(IXQEQueryNode node, PlanningEnvironment environment) {
        RQPTabularQuery tabularQuery;
        RQPQuery parentRQPQuery = (RQPQuery)node.getAncestorOfType(801044);
        if (parentRQPQuery == null) {
            parentRQPQuery = (RQPQuery)node.getAncestorOfType(801017);
        }
        if (RQPTabularQuery.pushWholeExpressionToTabularQuery(environment, tabularQuery = parentRQPQuery.getDefaultTabularQuery(), node)) {
            return;
        }
        if (node.getType() == 201040) {
            MoveGroupingItemsToSubQuery.createRQPDataItemInSubQueryAndRefInParentQuery(environment, tabularQuery, node, ((V5ScalarFunction)node).getName(), true);
            return;
        }
        List<IXQEQueryNode> identifiers = node.getDescendantsOfCategory(201115, true);
        for (IXQEQueryNode identifier : identifiers) {
            if (identifier.getType() == 201127) continue;
            String columnName = ((V5BoundMultiPartIdentifier)identifier).getColumnName();
            RQPDataItem tabularItem = tabularQuery.getRQPDataItem(environment, identifier, columnName);
            RQPDataItemRef rqpDataItemRef = RQPDataItemRef.create(environment, tabularQuery.getName(), tabularItem.getName());
            identifier.exchange(rqpDataItemRef);
            RQPDataItem parentItem = (RQPDataItem)rqpDataItemRef.getAncestorOfType(801008);
            if (parentItem == null || parentItem.getPropertyValue("lookup") == null) continue;
            tabularItem.setPropertyValue("lookup", parentItem.getPropertyValue("lookup"));
        }
    }

    private static boolean pushWholeExpressionToTabularQuery(PlanningEnvironment environment, RQPTabularQuery tabularQuery, IXQEQueryNode expression) {
        IXQEQueryNode itemAncestor = expression.getAncestorOfType(801008);
        String preferredName = null;
        if (itemAncestor != null) {
            expression = ((RQPDataItem)itemAncestor).getExpression();
            preferredName = ((RQPDataItem)itemAncestor).getName();
        }
        if (preferredName == null) {
            preferredName = RQPSummaryQuery.getDataItemName(tabularQuery, expression);
        }
        List<RQPDataItem> groupingItems = RQPNode.getRQPQuery(expression).getProjectionsMarkedAsGroupingColumns();
        if (itemAncestor != null && groupingItems != null) {
            boolean found = false;
            for (IXQEQueryNode iXQEQueryNode : groupingItems) {
                List sameExps = (List)iXQEQueryNode.getPropertyValue("sameExps");
                if (sameExps == null) continue;
                for (IXQEQueryNode sameExp : sameExps) {
                    if (!sameExp.isAncestor(itemAncestor)) continue;
                    expression = sameExp;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        if (PushDetailExpressionToTabularQuery.shouldStayInOuterQuery(expression)) {
            return false;
        }
        if (RQPUtilities.hasAggregateInExpression(expression)) {
            return false;
        }
        if (expression.getType() == 201116) {
            return false;
        }
        if (expression.getDescendantsOfType(801009, true).length > 0) {
            return false;
        }
        RQPDataItem tabularItem = tabularQuery.getRQPDataItem(environment, expression, preferredName);
        RQPDataItemRef rqpDataItemRef = RQPDataItemRef.create(environment, tabularQuery.getName(), tabularItem.getName());
        expression.exchange(rqpDataItemRef);
        return true;
    }
}

