/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.List;

public class SQLBetween
extends SQLAbstractBooleanFunction {
    private static final String FUNCTION_NAME = "Between";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLBetween.create(p, jjtid, 301045);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301045;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    protected String getKey() {
        return "predicates." + this.getFunctionName();
    }

    @Override
    protected String getCapabilityPrefix() {
        return this.getKey();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    protected void analyzeJoinCondition(BitMask bitMask) {
        bitMask.set(11);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        IDataType dType = ((ISQLQueryNode)this.getChild(0)).getDataType();
        boolean bl = vectorizable = DataTypeComparator.isComparableTo(dType, ((ISQLQueryNode)this.getChild(1)).getDataType()) && DataTypeComparator.isComparableTo(dType, ((ISQLQueryNode)this.getChild(2)).getDataType());
        if (!vectorizable) {
            SQLBetween.addUnsupportedReasonForVQE(ul, "BETWEEN predicate contains imcomparable data type");
        }
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        String className = this.getVectorClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }

    public String getVectorClassName() {
        IValueExpression child = (IValueExpression)this.getChild(0);
        String typeName = this.getTypeName(child);
        boolean negated = false;
        String template = "XVector";
        IXQEQueryNode parent = this.getParent();
        if (parent.getType() == 301027 && ((SQLLogical)parent).getSubType() == SQLLogical.SubType.NOT) {
            negated = true;
        }
        if (ASTUtil.isInFilterContext(this)) {
            template = template + "Filter";
        }
        template = negated ? template + "%sColumnNotBetween" : template + "%sColumnBetween";
        template = "com.cognos.xqe.runtree.relational.vectorization.expressions.generated." + template;
        return String.format(template, typeName);
    }
}

