/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractBooleanFunction;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class SQLComparison
extends SQLAbstractBooleanFunction {
    public static final String PROP_ENUM_SUBTYPE = "subType";
    public static final String PROP_MASTERDETAIL_LINK_NAME = "masterDetailLinkName";
    public static final String PROP_ALWAYS_FALSE = "alwayFalse";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLComparison.create(p, jjtid, 301026);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301026;
    }

    public SubType getSubType() {
        return (SubType)((Object)this.getPropertyValue(PROP_ENUM_SUBTYPE));
    }

    public void setSubType(SubType subType) {
        this.setPropertyValue(PROP_ENUM_SUBTYPE, (Object)subType);
    }

    public void invertSubType() {
        SubType newSubType = null;
        switch (this.getSubType()) {
            case LESS: {
                newSubType = SubType.GREATEREQUAL;
                break;
            }
            case LESSEQUAL: {
                newSubType = SubType.GREATER;
                break;
            }
            case EQUAL: {
                newSubType = SubType.NOTEQUAL;
                break;
            }
            case NOTEQUAL: {
                newSubType = SubType.EQUAL;
                break;
            }
            case GREATEREQUAL: {
                newSubType = SubType.LESS;
                break;
            }
            case GREATER: {
                newSubType = SubType.LESSEQUAL;
                break;
            }
            default: {
                newSubType = null;
            }
        }
        this.setSubType(newSubType);
    }

    @Override
    public String getFunctionName() {
        return this.getSubType().key();
    }

    public boolean isRelational() {
        return true;
    }

    @Override
    protected String getKey() {
        return "predicates.comparison." + this.getFunctionName();
    }

    @Override
    protected String getCapabilityPrefix() {
        return this.getKey();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    protected void analyzeJoinCondition(BitMask bitMask) {
        if (this.getSubType() == SubType.EQUAL) {
            if (this.getParent().getType() == 301027 && ((SQLLogical)this.getParent()).getSubType() == SQLLogical.SubType.NOT) {
                bitMask.set(4);
            }
            bitMask.set(5);
        } else {
            bitMask.set(4);
        }
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            if (this.getChild(i).getType() == 301051 || this.getChild(i).getType() == 301031) {
                if (this.getSubType() == SubType.EQUAL) {
                    bitMask.set(21);
                    continue;
                }
                bitMask.set(22);
                continue;
            }
            if (!(this.getChild(i) instanceof SQLAbstractFunction)) continue;
            ((SQLAbstractFunction)this.getChild(i)).analyzeJoinCondition(bitMask);
        }
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result = super.isSupportedImpl(dataSource, ul);
        if (result) {
            BitMask incidence = this.incidence(new BitMask());
            IDataSourceCapabilities capabilities = dataSource.getCapabilities();
            if (incidence.cardinality() == 0) {
                result = !capabilities.isSupported("supports.columnFiltersOnly");
            } else if (incidence.cardinality() > 1) {
                result = this.getSubType() == SubType.EQUAL ? capabilities.isSupported("supports.equiJoins") : capabilities.isSupported("supports.thetaJoins");
            }
        }
        if (!result) {
            SQLComparison.addUnsupportedReason(ul, "Unsupported comparison.", this);
        }
        return result;
    }

    public String getMasterDetailLinkName() {
        return (String)this.getPropertyValue(PROP_MASTERDETAIL_LINK_NAME);
    }

    public void setAlwaysFalse(boolean isAlwaysFalse) {
        this.setPropertyValue(PROP_ALWAYS_FALSE, isAlwaysFalse);
    }

    public boolean isAlwaysFalse() {
        return this.getBooleanPropertyValue(PROP_ALWAYS_FALSE, false);
    }

    @Override
    public boolean needAdjustDataType() {
        return false;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        ISQLQueryNode lChild = (ISQLQueryNode)this.getChild(0);
        ISQLQueryNode rChild = (ISQLQueryNode)this.getChild(1);
        boolean bl = vectorizable = lChild.isVectorizable(ul) && rChild.isVectorizable(ul) && DataTypeComparator.isComparableTo(lChild.getDataType(), rChild.getDataType());
        if (!vectorizable) {
            SQLComparison.addUnsupportedReasonForVQE(ul, "Unsupported comparison between " + lChild.getDataType().getTypeName() + " and " + rChild.getDataType().getTypeName());
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        IValueExpression leftChild = (IValueExpression)this.getChild(0);
        IValueExpression rightChild = (IValueExpression)this.getChild(1);
        String lTypeName = this.getTypeName(leftChild);
        String rTypeName = this.getTypeName(rightChild);
        String template = "XVector";
        if (this.getAncestorOfTypeWithAnchor(301009, 301030) != null || this.getAncestorOfTypeWithAnchor(901013, 301030) != null) {
            template = template + "Filter";
        }
        template = leftChild.getType() != 301031 ? (rightChild.getType() != 301031 ? template + "%sColumn%s%sColumn" : template + "%sColumn%s%sScalar") : template + "%sScalar%s%sColumn";
        template = "com.cognos.xqe.runtree.relational.vectorization.expressions.generated." + template;
        String className = String.format(template, lTypeName, this.getFunctionName(), rTypeName);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    protected boolean isSimpleType(XQEPersistContext ctx, Object value) {
        return super.isSimpleType(ctx, value) || value instanceof SubType;
    }

    @Override
    protected void persistAttributeProperty(XQEPersistContext ctx, String key, Object value) {
        if (value instanceof SubType) {
            ctx.property(key, ((SubType)((Object)value)).name(), "sub:");
        } else {
            super.persistAttributeProperty(ctx, key, value);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        Namespace ns = att.getNamespace();
        if (ns.getURI().equals("http://developer.cognos.com/Types/SubType")) {
            for (SubType val : SubType.values()) {
                if (!val.name().equals(att.getValue())) continue;
                this.setPropertyValue(att.getName(), (Object)val);
                break;
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public static enum SubType {
        LESS("LessThan"),
        LESSEQUAL("LessThanOrEquals"),
        EQUAL("Equals"),
        NOTEQUAL("NotEquals"),
        GREATEREQUAL("GreaterThanOrEquals"),
        GREATER("GreaterThan");

        private String key;

        private SubType(String theKey) {
            this.key = theKey;
        }

        public String key() {
            return this.key;
        }
    }
}

