/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.ISQLQueryNode;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtractDay;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtractEpoch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtractHour;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtractMinute;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtractMonth;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtractSecond;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtractYear;
import java.util.List;

public class SQLExtract
extends SQLAbstractFunction {
    private static final int FRACTION_SECOND_PRECISION = 11;
    private static final int FRACTION_SECOND_SCALE = 9;
    public static final String PROP_OBJECT_FIELD = "field";
    private static final String FUNCTION_NAME = "Extract";
    private static final String FUNCTION_NAME_SECONDS = "ExtractSecond";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLExtract.create(p, jjtid, 301063);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301063;
    }

    @Override
    public String getFunctionName() {
        if (this.getField().value == 6) {
            return FUNCTION_NAME_SECONDS;
        }
        return FUNCTION_NAME;
    }

    public void setField(ExtractField field) {
        this.setPropertyValue(PROP_OBJECT_FIELD, (Object)field);
    }

    public ExtractField getField() {
        return (ExtractField)((Object)this.getPropertyValue(PROP_OBJECT_FIELD));
    }

    @Override
    public boolean isProjectable() {
        return true;
    }

    @Override
    protected String getCapabilityPrefix() {
        return "expressions.Extract." + this.getField().key();
    }

    @Override
    public String getPattern(IDataSourceCapabilities capabilities) {
        return super.getOverloadedPattern(capabilities);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (!super.isSameExpression(node, compareCalcDefiniton)) {
            return false;
        }
        return this.getField().equals((Object)((SQLExtract)node).getField());
    }

    @Override
    public IDataType getDataType() {
        int field = this.getField().value;
        if (field == 6) {
            return DataTypeFactory.getDecimalType(11, 9);
        }
        if (field == 9) {
            return DataTypeFactory.getLongType();
        }
        return DataTypeFactory.getIntegerType();
    }

    @Override
    public IValue getParameter(XDataContext context, int index) {
        if (this.getNumberChildren() == 1) {
            if (index == 0) {
                return DataValueFactory.createIntegerValue(this.getField().value());
            }
            --index;
        }
        return ((SQLExpression)this.getChild(index)).execute(context);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable;
        boolean bl = vectorizable = this.getField().vectorClass() != null;
        if (!vectorizable) {
            SQLExtract.addUnsupportedReasonForVQE(ul, "Unsupported EXTRACT with field: " + this.getField().key());
        }
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = ((ISQLQueryNode)this.getChild(i)).isVectorizable(ul);
        }
        return vectorizable;
    }

    @Override
    public Class<?> getVectorClass() {
        return this.getField().vectorClass();
    }

    public static enum ExtractField {
        YEAR("YEAR", 1, XVectorExtractYear.class),
        MONTH("MONTH", 2, XVectorExtractMonth.class),
        DAY("DAY", 3, XVectorExtractDay.class),
        HOUR("HOUR", 4, XVectorExtractHour.class),
        MINUTE("MINUTE", 5, XVectorExtractMinute.class),
        SECOND("SECOND", 6, XVectorExtractSecond.class),
        TIMEZONE_HOUR("TIMEZONE_HOUR", 7),
        TIMEZONE_MINUTE("TIMEZONE_MINUTE", 8),
        EPOCH("EPOCH", 9, XVectorExtractEpoch.class);

        private String key;
        private int value;
        private Class<?> vClass;

        private ExtractField(String theKey, int theValue) {
            this.key = theKey;
            this.value = theValue;
        }

        private ExtractField(String theKey, int theValue, Class<?> vectorClass) {
            this.key = theKey;
            this.value = theValue;
            this.vClass = vectorClass;
        }

        public String key() {
            return this.key;
        }

        public int value() {
            return this.value;
        }

        public Class<?> vectorClass() {
            return this.vClass;
        }
    }
}

