/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.INodeCondition;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.transformation.relational.optimization.util.BitMask;
import java.util.BitSet;
import java.util.List;

public class SQLFid
extends SQLIdentifier {
    private static final String SUPPORTS_FIELDS_OF_COMPLEX_TYPE_IN_SELECT_LIST = "supports.fieldsOfComplexTypeInSelectList";
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String PROP_INTEGER_CONTEXTNO = "contextNo";
    public static final String PROP_INTEGER_SOURCENO = "sourceNo";
    public static final String PROP_INTEGER_COLUMNNO = "columnNo";
    public static final String PROP_INTEGER_VCOLUMNNO = "vColumnNo";
    public static final String PROP_BOOLEAN_ISNULLABLE = "isNullable";
    public static final String PROP_BOOLEAN_ISUNIQUE = "isUnique";

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    @Override
    public IDataType getBaseDataType() {
        return this.getDataType().getBaseDataType();
    }

    @Override
    public int getContextNo() {
        return (Integer)this.getPropertyValue(PROP_INTEGER_CONTEXTNO);
    }

    @Override
    public void setContextNo(int contextNo) {
        this.setPropertyValue(PROP_INTEGER_CONTEXTNO, contextNo);
    }

    public void setSourceNo(int sourceNo) {
        this.setPropertyValue(PROP_INTEGER_SOURCENO, sourceNo);
    }

    public int getSourceNo() {
        SQLFid fid = this;
        while (fid.isFieldRef()) {
            fid = (SQLFid)fid.getChild(0);
        }
        return (Integer)fid.getPropertyValue(PROP_INTEGER_SOURCENO);
    }

    public void setColumnNo(int columnNo) {
        this.setPropertyValue(PROP_INTEGER_COLUMNNO, columnNo);
    }

    public int getColumnNo() {
        SQLFid fid = this;
        while (fid.isFieldRef()) {
            fid = (SQLFid)fid.getChild(0);
        }
        Integer pValue = (Integer)fid.getPropertyValue(PROP_INTEGER_COLUMNNO);
        if (pValue != null) {
            return pValue;
        }
        return -1;
    }

    public void setVirtualColumnNo(int columnNo) {
        SQLFid fid = this;
        while (fid.isFieldRef()) {
            fid = (SQLFid)fid.getChild(0);
        }
        fid.setPropertyValue(PROP_INTEGER_VCOLUMNNO, columnNo);
    }

    public int getVirtualColumnNo() {
        Integer pValue = (Integer)this.getPropertyValue(PROP_INTEGER_VCOLUMNNO);
        if (pValue != null) {
            return pValue;
        }
        return -1;
    }

    @Override
    public boolean isNullable() {
        Object isNullable = this.getPropertyValue(PROP_BOOLEAN_ISNULLABLE);
        if (null == isNullable) {
            return true;
        }
        return (Boolean)isNullable;
    }

    public void setIsNullable(boolean isNullable) {
        this.setPropertyValue(PROP_BOOLEAN_ISNULLABLE, isNullable);
    }

    public boolean isUnique() {
        Object isUnique = this.getPropertyValue(PROP_BOOLEAN_ISUNIQUE);
        if (null == isUnique) {
            return false;
        }
        return (Boolean)isUnique;
    }

    public void setIsUnique(boolean isUnique) {
        this.setPropertyValue(PROP_BOOLEAN_ISUNIQUE, isUnique);
    }

    @Override
    public int getType() {
        return 301032;
    }

    @Override
    public boolean isProjectable() {
        return true;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        IXQEQueryNode parent;
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        return !this.isFieldRef() || (parent = this.getParent()).getType() != 301030 || parent.getParent().getType() != 301015 || capabilities.getBooleanValue(SUPPORTS_FIELDS_OF_COMPLEX_TYPE_IN_SELECT_LIST);
    }

    @Override
    public boolean isSupported(IDataSource dataSource, SQLJoin.SubType jType, int sourceNo) {
        return true;
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    public void getProjectableExpressions(IDataSourceCapabilities capabilities, List<SQLQueryNode> exprNodeList) {
        exprNodeList.add(this);
    }

    protected void getProjectableExpressions(IDataSourceCapabilities capabilities, List<IXQEQueryNode> exprNodeList, IXQEQueryNode anchorNode, int sourceNo) {
        if (sourceNo == this.getSourceNo()) {
            exprNodeList.add(this);
        }
    }

    protected void getFieldIdentifiers(List<SQLFid> fidList) {
        fidList.add(this);
    }

    @Override
    protected void getFieldIdentifiers(List<SQLFid> fidList, IXQEQueryNode anchorNode, BitSet mask) {
        if (mask.get(this.getSourceNo())) {
            fidList.add(this);
        }
    }

    @Override
    protected void getFieldIdentifiers(List<SQLFid> fidList, int[] anchorTypes) {
        fidList.add(this);
    }

    @Override
    protected void getFieldIdentifiers(List<SQLFid> fidList, INodeCondition anchorCondition) {
        fidList.add(this);
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this == node) {
            return true;
        }
        if (node instanceof SQLFid) {
            SQLFid fid = (SQLFid)node;
            if (this.getNumberChildren() != fid.getNumberChildren()) {
                return false;
            }
            for (int i = 0; i < this.getNumberChildren(); ++i) {
                if (this.getChild(i).isSameExpression(fid.getChild(i), compareCalcDefiniton)) continue;
                return false;
            }
            if (this.getVirtualColumnNo() == fid.getVirtualColumnNo()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public BitMask incidence(BitMask mask) {
        SQLFid fid = this;
        while (fid.isFieldRef()) {
            fid = (SQLFid)fid.getChild(0);
        }
        mask.set(fid.getSourceNo());
        return mask;
    }

    public boolean isFieldRef() {
        return this.getNumberChildren() > 0;
    }

    public String getJSONPathExpression() {
        StringBuilder b = new StringBuilder(this.getName());
        if (this.isFieldRef()) {
            SQLFid child = this;
            do {
                child = (SQLFid)child.getChild(0);
                b.insert(0, ".").insert(0, child.getName());
            } while (child.getNumberChildren() > 0);
        }
        b.insert(0, "$.");
        return b.toString();
    }

    @Override
    protected void addNodeToList(IXQEQueryNode node, IDataSourceCapabilities capabilities, List<IXQEQueryNode> exprNodeList) {
        SQLFid fid = this;
        if (this.isFieldRef() && !capabilities.getBooleanValue(SUPPORTS_FIELDS_OF_COMPLEX_TYPE_IN_SELECT_LIST)) {
            while (fid.isFieldRef()) {
                fid = (SQLFid)fid.getChild(0);
            }
        }
        exprNodeList.add(fid);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean result;
        IDataType dType = this.getDataType();
        boolean bl = result = !dType.isBlob() && !dType.isClob() && dType.getCCLTypeCode() != 22 && dType.getCCLTypeCode() != 23 && dType.getCCLTypeCode() != 102;
        if (!result) {
            SQLFid.addUnsupportedReasonForVQE(ul, "Unsupported data type: " + dType.getTypeName());
        }
        return result;
    }
}

