/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.relational.LOCALCastFormatter;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;

public class SQLFormat
extends SQLExpression {
    public static final String TEXT_DATATYPE_PROPERTY_STR = "string";
    private static final String PROP_OBJECT_FORMAT = "format";
    private static final String PROP_OBJECT_SOURCE_DATATYPE = "sourceDataType";
    private static final String PROP_OBJECT_TARGET_DATATYPE = "targetDataType";
    private static final String PROP_OBJECT_VALUE = "value";
    private static final String FORMATTING_ON_CAST_OPERATOR;
    private static final String TRUE_STR = "true";

    public SQLFormat() {
        if (!FORMATTING_ON_CAST_OPERATOR.equalsIgnoreCase(TRUE_STR)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LocalFormattingDisabled);
        }
    }

    public static Node jjtCreate(SQLParser p, int jjtid) {
        if (!FORMATTING_ON_CAST_OPERATOR.equalsIgnoreCase(TRUE_STR)) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_LocalFormattingDisabled);
        }
        return SQLFormat.create(p, jjtid, 301097);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301097;
    }

    public void setValue(String format) {
        try {
            Object[] values = new Object[2];
            ArrayList<ChronoField> accessors = new ArrayList<ChronoField>();
            DateTimeFormatter dtf = LOCALCastFormatter.getInstance().getJavaPatternFromSQLPattern(format, accessors);
            values[0] = dtf;
            values[1] = accessors;
            ObjectValue v = DataValueFactory.createObjectValue();
            v.set(values);
            this.setPropertyValue(PROP_OBJECT_VALUE, v);
            this.setPropertyValue(PROP_OBJECT_FORMAT, format.trim());
        }
        catch (IllegalArgumentException e) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidFormattingPattern, format);
        }
    }

    public IValue getValue() {
        return (IValue)this.getPropertyValue(PROP_OBJECT_VALUE);
    }

    public String getFormat() {
        return (String)this.getPropertyValue(PROP_OBJECT_FORMAT);
    }

    public void setTargetDataType(IDataType targetDataType) {
        this.setPropertyValue(PROP_OBJECT_TARGET_DATATYPE, targetDataType);
    }

    public IDataType getTargetDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_TARGET_DATATYPE);
    }

    public void setSourceDataType(IDataType sourceDataType) {
        this.setPropertyValue(PROP_OBJECT_SOURCE_DATATYPE, sourceDataType);
    }

    public IDataType getSourceDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_SOURCE_DATATYPE);
    }

    @Override
    public IValue execute(XDataContext context) {
        return this.getValue();
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (this.getFormat() == null) {
            return node.getPropertyValue(PROP_OBJECT_FORMAT) == null;
        }
        return this.getFormat().equals(node.getPropertyValue(PROP_OBJECT_FORMAT));
    }

    @Override
    public boolean isProjectable() {
        return false;
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        if (this.getSourceDataType() == null) {
            IXQEQueryNode sourceNode = this.getParent().getChild(0);
            if (sourceNode instanceof SQLFid) {
                this.setSourceDataType(((SQLFid)sourceNode).getDataType());
            } else {
                this.setSourceDataType(((SQLLiteral)sourceNode).getDataType());
            }
        }
        StringBuilder sb = new StringBuilder("supports.formatters.");
        if (!this.getSourceDataType().isTextType()) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedCastWithFormat);
        }
        sb.append(TEXT_DATATYPE_PROPERTY_STR);
        sb.append("_to_");
        if (this.getTargetDataType().isTextType()) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedCastWithFormat);
        }
        sb.append(this.getTargetDataType().getCapabilitiesKey());
        if (dataSource.getCapabilities().isSupported(sb.toString())) {
            return true;
        }
        SQLFormat.addUnsupportedReason(ul, "Unsupported Formatting Pattern: " + sb.toString(), this);
        return false;
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        return true;
    }

    static {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        FORMATTING_ON_CAST_OPERATOR = config.getStringProperty("queryPlanning.localFormattingOnCastOperator[@enabled]", "false");
    }
}

