/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.sql;

import com.cognos.xqe.ast.INodeCondition;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.sql.IOutputList;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.sql.parser.Node;
import com.cognos.xqe.ast.sql.parser.SQLParser;
import com.cognos.xqe.ast.sql.util.SQLQueryNodeVisitor;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.Governors;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class SQLGroupByList
extends SQLExpression {
    private static final String SPACE = " ";

    public static Node jjtCreate(SQLParser p, int jjtid) {
        return SQLGroupByList.create(p, jjtid, 301029);
    }

    @Override
    public void accept(SQLQueryNodeVisitor visitor, IDataSourceCapabilities capabilities) {
        visitor.visit(this, capabilities);
    }

    @Override
    public int getType() {
        return 301029;
    }

    public int indexOf(Object o) {
        if (!(o instanceof IXQEQueryNode)) {
            return -1;
        }
        IXQEQueryNode node = (IXQEQueryNode)o;
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            if (!node.isSameExpression(this.getChild(i), false)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void getCognosSQL(IDataSourceCapabilities capabilities, QueryFormatter formatter) {
        formatter.addNewLineAndIndentation();
        formatter.addText(this.getPattern(capabilities));
        formatter.addText(SPACE);
        formatter.increaseCurrentNodeIndentationLevel();
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            if (i > 0) {
                formatter.addText(", ");
            }
            formatter.addNewLineAndIndentation();
            ((SQLQueryNode)this.getChild(i)).accept(formatter, capabilities);
        }
        formatter.decreaseCurrentNodeIndentationLevel();
    }

    @Override
    protected boolean isSupportedImpl(IDataSource dataSource, List<String> ul) {
        boolean result;
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        int maxColumnsInGroupby = capabilities.getIntegerValue("limits.maxColumnsInGroupBy");
        boolean bl = result = maxColumnsInGroupby <= 0 || this.getNumberChildren() <= maxColumnsInGroupby;
        if (result) {
            result = super.isSupportedImpl(dataSource, ul);
        }
        if (result) {
            boolean bl2 = result = this.getPattern(capabilities) != null;
        }
        if (result) {
            result = this.validate(false);
        }
        boolean blobIsAllowed = result && capabilities.getBooleanValue("supports.blobsInGroupBy");
        for (int i = 0; i < this.getNumberChildren() && result; ++i) {
            IDataType dType = ((SQLQueryNode)this.getChild(i)).getDataType();
            if (dType == null || !dType.isBlob() || blobIsAllowed) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_GroupByNotAllowed);
        }
        if (result && !capabilities.getBooleanValue("supports.duplicateColumnsInSelectList")) {
            IXQEQueryNode[] children = this.getChildrenOfType(301032);
            for (int i = 0; i < children.length && result; ++i) {
                SQLFid fid1 = (SQLFid)children[i];
                for (int j = i + 1; j < children.length && result; ++j) {
                    SQLFid fid2 = (SQLFid)children[j];
                    if (!fid1.getName().equalsIgnoreCase(fid2.getName())) continue;
                    if (fid1.getTableName() != null) {
                        if (!fid1.getTableName().equalsIgnoreCase(fid2.getTableName())) continue;
                        result = false;
                        continue;
                    }
                    if (fid2.getTableName() != null) continue;
                    result = false;
                }
            }
        }
        if (!result) {
            SQLGroupByList.addUnsupportedReason(ul, "Unsupported Group By, or grouping list ", this);
        }
        return result;
    }

    @Override
    protected String getKey() {
        return "clauses.GroupBy";
    }

    public boolean validate(boolean throwException) {
        boolean result = true;
        SQLValueList projectList = ((IOutputList)((Object)this.getParent())).getOutputList();
        HashSet<Integer> groupingColumns = new HashSet<Integer>();
        List<SQLFid> fids = this.getFieldIdentifiers();
        for (SQLFid fid : this.getFieldIdentifiers()) {
            groupingColumns.add(fid.getVirtualColumnNo());
        }
        fids = projectList.getFieldIdentifiers(new FidAnchor());
        for (SQLFid fid : fids) {
            if (groupingColumns.contains(fid.getVirtualColumnNo())) continue;
            result = false;
            if (!this.isStrictGroupingEnabled() || !throwException) break;
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidGroupByClause, fid.getName());
        }
        return result;
    }

    private boolean isStrictGroupingEnabled() {
        Governors governors = this.getGovernors();
        if (governors != null && governors.getStrictGroupBy()) {
            return true;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty("queryPlanning.strictGroupingListRules[@enabled]", false);
    }

    @Override
    public boolean isVectorizable(List<String> ul) {
        boolean vectorizable = true;
        for (int i = 0; i < this.getNumberChildren() && vectorizable; ++i) {
            vectorizable = this.getChild(i).getType() == 301032;
        }
        if (!vectorizable) {
            SQLGroupByList.addUnsupportedReasonForVQE(ul, "Only column reference supported in GroupBy list");
        }
        return vectorizable;
    }

    private class FidAnchor
    implements INodeCondition {
        private FidAnchor() {
        }

        @Override
        public boolean applies(IXQEQueryNode node) {
            return node.getType() == 301034 && !node.hasChildOfType(301041);
        }

        @Override
        public void applies(Collection<IXQEQueryNode> nodes, Collection<IXQEQueryNode> appliedNodes) {
        }

        @Override
        public int[] getNodeTypes() {
            return null;
        }

        @Override
        public boolean isAncestorNode(AbstractMDXNode node) {
            return false;
        }

        @Override
        public void setNodeTypes(int[] nodeTypes) {
        }
    }
}

